/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;

public class EllipsoidTag
implements ObjectTag,
Notable {
    private LocationTag loc;
    private LocationTag size;
    String prefix = "ellipsoid";
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static List<EllipsoidTag> getNotableEllipsoidsContaining(Location location) {
        ArrayList<EllipsoidTag> cuboids = new ArrayList<EllipsoidTag>();
        for (EllipsoidTag ellipsoid : NotableManager.getAllType(EllipsoidTag.class)) {
            if (!ellipsoid.contains(location)) continue;
            cuboids.add(ellipsoid);
        }
        return cuboids;
    }

    public static EllipsoidTag valueOf(String string) {
        return EllipsoidTag.valueOf(string, null);
    }

    @Fetchable(value="ellipsoid")
    public static EllipsoidTag valueOf(String string, TagContext context) {
        if (string.startsWith("ellipsoid@")) {
            string = string.substring(10);
        }
        if (NotableManager.isType(string, EllipsoidTag.class)) {
            return (EllipsoidTag)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 7) {
            return null;
        }
        WorldTag world = WorldTag.valueOf(split.get(3), false);
        if (world == null) {
            return null;
        }
        LocationTag location = new LocationTag(world.getWorld(), ArgumentHelper.getDoubleFrom(split.get(0)), ArgumentHelper.getDoubleFrom(split.get(1)), ArgumentHelper.getDoubleFrom(split.get(2)));
        LocationTag size = new LocationTag(null, ArgumentHelper.getDoubleFrom(split.get(4)), ArgumentHelper.getDoubleFrom(split.get(5)), ArgumentHelper.getDoubleFrom(split.get(6)));
        return new EllipsoidTag(location, size);
    }

    public static boolean matches(String arg) {
        try {
            return EllipsoidTag.valueOf(arg) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public EllipsoidTag(LocationTag loc, LocationTag size) {
        this.loc = loc;
        this.size = size;
    }

    public ListTag getBlocks(Attribute attribute) {
        return this.getBlocks(null, attribute);
    }

    public ListTag getBlocks(List<MaterialTag> materials, Attribute attribute) {
        List<LocationTag> initial = new CuboidTag(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(materials, attribute);
        ListTag list = new ListTag();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            list.add(loc.identify());
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered() {
        List<LocationTag> initial = new CuboidTag(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlockLocationsUnfiltered();
        ArrayList<LocationTag> locations = new ArrayList<LocationTag>();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    public List<LocationTag> getBlockLocations(Attribute attribute) {
        List<LocationTag> initial = new CuboidTag(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(null, attribute);
        ArrayList<LocationTag> locations = new ArrayList<LocationTag>();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    public boolean contains(Location test) {
        double xbase = test.getX() - this.loc.getX();
        double ybase = test.getY() - this.loc.getY();
        double zbase = test.getZ() - this.loc.getZ();
        return xbase * xbase / (this.size.getX() * this.size.getX()) + ybase * ybase / (this.size.getY() * this.size.getY()) + zbase * zbase / (this.size.getZ() * this.size.getZ()) < 1.0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "cu@" + NotableManager.getSavedId(this) + "<GR> (" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    @Note(value="Ellipsoids")
    public Object getSaveObject() {
        return this.identifyFull().substring(10);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "Ellipsoid";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "ellipsoid@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        return "ellipsoid@" + this.loc.getX() + "," + this.loc.getY() + "," + this.loc.getZ() + "," + this.loc.getWorld().getName() + "," + this.size.getX() + "," + this.size.getY() + "," + this.size.getZ();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public static void registerTags() {
        EllipsoidTag.registerTag("blocks", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.hasContext(1)) {
                    return new ListTag(((EllipsoidTag)object).getBlocks(ListTag.valueOf(attribute.getContext(1)).filter(MaterialTag.class, attribute.context), attribute)).getObjectAttribute(attribute.fulfill(1));
                }
                return new ListTag(((EllipsoidTag)object).getBlocks(attribute)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        EllipsoidTag.registerTag("get_blocks", EllipsoidTag.tagProcessor.registeredObjectTags.get("blocks"));
        EllipsoidTag.registerTag("location", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((EllipsoidTag)object).loc.getObjectAttribute(attribute.fulfill(1));
            }
        });
        EllipsoidTag.registerTag("size", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((EllipsoidTag)object).size.getObjectAttribute(attribute.fulfill(1));
            }
        });
        EllipsoidTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Ellipsoid").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }
}

