/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.npc.DenizenNPCHelper;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.npc.traits.ConstantsTrait;
import com.denizenscript.denizen.npc.traits.FishingTrait;
import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.npc.traits.NicknameTrait;
import com.denizenscript.denizen.npc.traits.PushableTrait;
import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.npc.EngageCommand;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.core.NPCTagBase;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.Pose;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class NPCTag
implements ObjectTag,
Adjustable,
InventoryHolder,
EntityFormObject {
    private int npcid = -1;
    private final Location locationCache = new Location(null, 0.0, 0.0, 0.0);
    private String prefix = "npc";
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static NPCTag mirrorCitizensNPC(NPC npc) {
        return new NPCTag(npc);
    }

    public static NPCTag fromEntity(Entity entity) {
        return NPCTag.mirrorCitizensNPC(CitizensAPI.getNPCRegistry().getNPC(entity));
    }

    public static NPCTag valueOf(String string) {
        return NPCTag.valueOf(string, null);
    }

    @Fetchable(value="n")
    public static NPCTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (ArgumentHelper.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            int id = ArgumentHelper.getIntegerFrom(string);
            NPC npc = CitizensAPI.getNPCRegistry().getById(id);
            if (npc != null) {
                return new NPCTag(npc);
            }
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("n@")) {
            return true;
        }
        if (ArgumentHelper.matchesInteger(string = string.toUpperCase().replace("N@", ""))) {
            NPC npc = CitizensAPI.getNPCRegistry().getById(ArgumentHelper.getIntegerFrom(string));
            if (npc != null) {
                return true;
            }
        } else {
            for (NPC test : CitizensAPI.getNPCRegistry()) {
                if (!test.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.getCitizen() != null;
    }

    public NPCTag(NPC citizensNPC) {
        if (citizensNPC != null) {
            this.npcid = citizensNPC.getId();
        }
    }

    public NPC getCitizen() {
        if (this.npcid < 0) {
            return null;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        if (npc == null) {
            // empty if block
        }
        return npc;
    }

    public Entity getEntity() {
        try {
            return this.getCitizen().getEntity();
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC entity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public LivingEntity getLivingEntity() {
        try {
            if (this.getCitizen().getEntity() instanceof LivingEntity) {
                return (LivingEntity)this.getCitizen().getEntity();
            }
            Debug.log("Uh oh! Tried to get the living entity of a non-living NPC!");
            return null;
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC livingEntity. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    @Override
    public EntityTag getDenizenEntity() {
        try {
            return new EntityTag(this.getCitizen().getEntity());
        }
        catch (NullPointerException ex) {
            Debug.echoError("Uh oh! Denizen has encountered a NPE while trying to fetch an NPC EntityTag. Has this NPC been removed?");
            if (Debug.verbose) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public org.bukkit.inventory.Inventory getInventory() {
        return DenizenNPCHelper.getInventory(this.getCitizen());
    }

    public InventoryTag getDenizenInventory() {
        return new InventoryTag(this);
    }

    public EntityType getEntityType() {
        return this.getCitizen().getEntity().getType();
    }

    public Navigator getNavigator() {
        return this.getCitizen().getNavigator();
    }

    public int getId() {
        return this.npcid;
    }

    public String getName() {
        return this.getCitizen().getName();
    }

    public InteractScriptContainer getInteractScript(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        return InteractScriptHelper.getInteractScript(this, player, triggerType);
    }

    public InteractScriptContainer getInteractScriptQuietly(PlayerTag player, Class<? extends AbstractTrigger> triggerType) {
        InteractScriptHelper.debugGet = false;
        InteractScriptContainer script = InteractScriptHelper.getInteractScript(this, player, triggerType);
        InteractScriptHelper.debugGet = true;
        return script;
    }

    public void destroy() {
        this.getCitizen().destroy();
    }

    public LocationTag getLocation() {
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public LocationTag getEyeLocation() {
        if (this.isSpawned() && this.getCitizen().getEntity() instanceof LivingEntity) {
            return new LocationTag(((LivingEntity)this.getCitizen().getEntity()).getEyeLocation());
        }
        if (this.isSpawned()) {
            return new LocationTag(this.getEntity().getLocation());
        }
        return new LocationTag(this.getCitizen().getStoredLocation());
    }

    public World getWorld() {
        if (this.isSpawned()) {
            return this.getEntity().getWorld();
        }
        return null;
    }

    public String toString() {
        return this.identify();
    }

    public boolean isEngaged() {
        return EngageCommand.getEngaged(this.getCitizen());
    }

    public boolean isSpawned() {
        NPC npc = CitizensAPI.getNPCRegistry().getById(this.npcid);
        return npc != null && npc.isSpawned();
    }

    public String getOwner() {
        if (((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId() == null) {
            return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwner();
        }
        return ((Owner)this.getCitizen().getTrait(Owner.class)).getOwnerId().toString();
    }

    public AssignmentTrait getAssignmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(AssignmentTrait.class)) {
            npc.addTrait(AssignmentTrait.class);
        }
        return (AssignmentTrait)npc.getTrait(AssignmentTrait.class);
    }

    public Equipment getEquipmentTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Equipment.class)) {
            npc.addTrait(Equipment.class);
        }
        return (Equipment)npc.getTrait(Equipment.class);
    }

    public NicknameTrait getNicknameTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(NicknameTrait.class)) {
            npc.addTrait(NicknameTrait.class);
        }
        return (NicknameTrait)npc.getTrait(NicknameTrait.class);
    }

    public FishingTrait getFishingTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(FishingTrait.class)) {
            npc.addTrait(FishingTrait.class);
        }
        return (FishingTrait)npc.getTrait(FishingTrait.class);
    }

    public HealthTrait getHealthTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(HealthTrait.class)) {
            npc.addTrait(HealthTrait.class);
        }
        return (HealthTrait)npc.getTrait(HealthTrait.class);
    }

    public Inventory getInventoryTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(Inventory.class)) {
            npc.addTrait(Inventory.class);
        }
        return (Inventory)npc.getTrait(Inventory.class);
    }

    public PushableTrait getPushableTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(PushableTrait.class)) {
            npc.addTrait(PushableTrait.class);
        }
        return (PushableTrait)npc.getTrait(PushableTrait.class);
    }

    public LookClose getLookCloseTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(LookClose.class)) {
            npc.addTrait(LookClose.class);
        }
        return (LookClose)npc.getTrait(LookClose.class);
    }

    public TriggerTrait getTriggerTrait() {
        NPC npc = this.getCitizen();
        if (!npc.hasTrait(TriggerTrait.class)) {
            npc.addTrait(TriggerTrait.class);
        }
        return (TriggerTrait)npc.getTrait(TriggerTrait.class);
    }

    public String action(String actionName, PlayerTag player, Map<String, ObjectTag> context) {
        if (this.getCitizen() != null && this.getCitizen().hasTrait(AssignmentTrait.class)) {
            return DenizenAPI.getCurrentInstance().getNPCHelper().getActionHandler().doAction(actionName, this, player, this.getAssignmentTrait().getAssignment(), context);
        }
        return "none";
    }

    public String action(String actionName, PlayerTag player) {
        return this.action(actionName, player, null);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        return "n@" + this.npcid + "<GR> (" + this.getName() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "NPC";
    }

    @Override
    public String identify() {
        return "n@" + this.npcid;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public NPCTag setPrefix(String prefix) {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NPCTag)) {
            return false;
        }
        return this.getId() == ((NPCTag)o).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public static void registerTags() {
        NPCTag.registerTag("is_npc", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("location", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.getAttributeWithoutContext(2).equals("previous_location")) {
                    return NPCTagBase.previousLocations.containsKey(((NPCTag)object).getId()) ? NPCTagBase.previousLocations.get(((NPCTag)object).getId()).getObjectAttribute(attribute.fulfill(2)) : null;
                }
                if (((NPCTag)object).isSpawned()) {
                    return new EntityTag((NPCTag)object).getObjectAttribute(attribute);
                }
                return ((NPCTag)object).getLocation().getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("eye_location", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((NPCTag)object).getEyeLocation().getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("has_nickname", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                NPC citizen = ((NPCTag)object).getCitizen();
                return new ElementTag(citizen.hasTrait(NicknameTrait.class) && ((NicknameTrait)citizen.getTrait(NicknameTrait.class)).hasNickname()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("name", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.getAttributeWithoutContext(2).equals("nickname")) {
                    return new ElementTag(((NPCTag)object).getCitizen().hasTrait(NicknameTrait.class) ? ((NicknameTrait)((NPCTag)object).getCitizen().getTrait(NicknameTrait.class)).getNickname() : ((NPCTag)object).getName()).getObjectAttribute(attribute.fulfill(2));
                }
                return new ElementTag(((NPCTag)object).getName()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("list_traits", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ArrayList<String> list = new ArrayList<String>();
                for (Trait trait : ((NPCTag)object).getCitizen().getTraits()) {
                    list.add(trait.getName());
                }
                return new ListTag((List<String>)list).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("has_trait", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Class trait;
                if (attribute.hasContext(1) && (trait = CitizensAPI.getTraitFactory().getTraitClass(attribute.getContext(1))) != null) {
                    return new ElementTag(((NPCTag)object).getCitizen().hasTrait(trait)).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        NPCTag.registerTag("pushable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getPushableTrait().isPushable()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_pushable", NPCTag.tagProcessor.registeredObjectTags.get("pushable"));
        NPCTag.registerTag("has_trigger", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                if (!((NPCTag)object).getCitizen().hasTrait(TriggerTrait.class)) {
                    return new ElementTag(false).getObjectAttribute(attribute.fulfill(1));
                }
                TriggerTrait trait = (TriggerTrait)((NPCTag)object).getCitizen().getTrait(TriggerTrait.class);
                return new ElementTag(trait.hasTrigger(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("has_anchors", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((Anchors)((NPCTag)object).getCitizen().getTrait(Anchors.class)).getAnchors().size() > 0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("anchor", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.hasContext(1) && ((Anchors)((NPCTag)object).getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)) != null) {
                    return new LocationTag(((Anchors)((NPCTag)object).getCitizen().getTrait(Anchors.class)).getAnchor(attribute.getContext(1)).getLocation()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.getAttributeWithoutContext(2).equals("list")) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Anchor anchor : ((Anchors)((NPCTag)object).getCitizen().getTrait(Anchors.class)).getAnchors()) {
                        list.add(anchor.getName());
                    }
                    return new ListTag((List<String>)list).getObjectAttribute(attribute.fulfill(2));
                }
                return null;
            }
        });
        NPCTag.registerTag("anchors", NPCTag.tagProcessor.registeredObjectTags.get("anchor"));
        NPCTag.registerTag("has_flag", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                return new ElementTag(FlagManager.npcHasFlag((NPCTag)object, flag_name)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("flag", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                    return new ElementTag(!FlagManager.npcHasFlag((NPCTag)object, flag_name)).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.npcHasFlag((NPCTag)object, flag_name)) {
                    return new ElementTag(0).getObjectAttribute(attribute.fulfill(2));
                }
                if (FlagManager.npcHasFlag((NPCTag)object, flag_name)) {
                    FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(((NPCTag)object).getId(), flag_name);
                    if (attribute.getAttribute(2).equalsIgnoreCase("expiration")) {
                        return flag.expiration().getObjectAttribute(attribute.fulfill(2));
                    }
                    return new ListTag(flag.toString(), true, flag.values()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((NPCTag)object).identify()).getObjectAttribute(attribute);
            }
        });
        NPCTag.registerTag("list_flags", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listNPCFlags(((NPCTag)object).getId()));
                ListTag searchFlags = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    searchFlags = new ListTag();
                    String search = attribute.getContext(1);
                    if (search.startsWith("regex:")) {
                        try {
                            Pattern pattern = Pattern.compile(search.substring(6), 2);
                            for (String flag : allFlags) {
                                if (!pattern.matcher(flag).matches()) continue;
                                searchFlags.add(flag);
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    } else {
                        search = CoreUtilities.toLowerCase(search);
                        for (String flag : allFlags) {
                            if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                            searchFlags.add(flag);
                        }
                    }
                }
                return searchFlags == null ? allFlags.getObjectAttribute(attribute.fulfill(1)) : searchFlags.getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("constant", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.hasContext(1)) {
                    if (((NPCTag)object).getCitizen().hasTrait(ConstantsTrait.class) && ((ConstantsTrait)((NPCTag)object).getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1)) != null) {
                        return new ElementTag(((ConstantsTrait)((NPCTag)object).getCitizen().getTrait(ConstantsTrait.class)).getConstant(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                    }
                    return null;
                }
                return null;
            }
        });
        NPCTag.registerTag("has_pose", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.hasContext(1)) {
                    return new ElementTag(((Poses)((NPCTag)object).getCitizen().getTrait(Poses.class)).hasPose(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        NPCTag.registerTag("pose", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (attribute.hasContext(1)) {
                    Pose pose = ((Poses)((NPCTag)object).getCitizen().getTrait(Poses.class)).getPose(attribute.getContext(1));
                    return new LocationTag((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, pose.getYaw(), pose.getPitch()).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        NPCTag.registerTag("get_pose", NPCTag.tagProcessor.registeredObjectTags.get("pose"));
        NPCTag.registerTag("is_sneaking", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!((NPCTag)object).isSpawned() && ((NPCTag)object).getEntity() instanceof Player) {
                    return null;
                }
                return new ElementTag(((Player)((NPCTag)object).getEntity()).isSneaking()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("engaged", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).isEngaged()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_engaged", NPCTag.tagProcessor.registeredObjectTags.get("engaged"));
        NPCTag.registerTag("invulnerable", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag((Boolean)((NPCTag)object).getCitizen().data().get("protected", (Object)true)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("vulnerable", NPCTag.tagProcessor.registeredObjectTags.get("invulnerable"));
        NPCTag.registerTag("id", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getId()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("owner", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String owner = ((NPCTag)object).getOwner();
                PlayerTag player = null;
                if (!owner.equalsIgnoreCase("server")) {
                    player = PlayerTag.valueOfInternal(owner, false);
                }
                if (player != null) {
                    return player.getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(owner).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("has_skin", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getCitizen().data().has("player-skin-name")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("skin_blob", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((NPCTag)object).getCitizen().data().has("player-skin-textures")) {
                    String tex = ((NPCTag)object).getCitizen().data().get("player-skin-textures").toString();
                    String sign = "";
                    if (((NPCTag)object).getCitizen().data().has("player-skin-signature")) {
                        sign = ";" + ((NPCTag)object).getCitizen().data().get("player-skin-signature").toString();
                    }
                    return new ElementTag(tex + sign).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        NPCTag.registerTag("skin", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((NPCTag)object).getCitizen().data().has("player-skin-name")) {
                    return new ElementTag(((NPCTag)object).getCitizen().data().get("player-skin-name").toString()).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        NPCTag.registerTag("inventory", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((NPCTag)object).getDenizenInventory().getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_spawned", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).isSpawned()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_protected", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getCitizen().isProtected()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("lookclose", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                NPC citizen = ((NPCTag)object).getCitizen();
                if (citizen.hasTrait(LookClose.class)) {
                    String lookclose = ((LookClose)citizen.getTrait(LookClose.class)).toString();
                    lookclose = lookclose.substring(10, lookclose.length() - 1);
                    return new ElementTag(Boolean.valueOf(lookclose)).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(false).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("teleport_on_stuck", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getDefaultParameters().stuckAction() == TeleportStuckAction.INSTANCE).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("has_script", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                NPC citizen = ((NPCTag)object).getCitizen();
                return new ElementTag(citizen.hasTrait(AssignmentTrait.class) && ((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("script", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                NPC citizen = ((NPCTag)object).getCitizen();
                if (!citizen.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).hasAssignment()) {
                    return null;
                }
                return new ScriptTag(((AssignmentTrait)citizen.getTrait(AssignmentTrait.class)).getAssignment().getName()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("distance_margin", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getDefaultParameters().distanceMargin()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("path_distance_margin", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getDefaultParameters().pathDistanceMargin()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_navigating", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().isNavigating()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("speed", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().speed()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("range", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().range()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("attack_range", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().attackRange()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("attack_strategy", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().attackStrategy().toString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("speed_modifier", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().speedModifier()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("base_speed", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().baseSpeed()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("avoid_water", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getLocalParameters().avoidWater()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("target_location", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((NPCTag)object).getNavigator().getTargetAsLocation() == null) {
                    return null;
                }
                return new LocationTag(((NPCTag)object).getNavigator().getTargetAsLocation()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("is_fighting", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((NPCTag)object).getNavigator().getEntityTarget() != null && ((NPCTag)object).getNavigator().getEntityTarget().isAggressive()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("target_type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((NPCTag)object).getNavigator().getTargetType() == null) {
                    return null;
                }
                return new ElementTag(((NPCTag)object).getNavigator().getTargetType().toString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("target_entity", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((NPCTag)object).getNavigator().getEntityTarget() == null || ((NPCTag)object).getNavigator().getEntityTarget().getTarget() == null) {
                    return null;
                }
                return new EntityTag(((NPCTag)object).getNavigator().getEntityTarget().getTarget()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("navigator", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Deprecations.oldNPCNavigator.warn(attribute.context);
                return object.getObjectAttribute(attribute.fulfill(1));
            }
        });
        NPCTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("NPC").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        if (this.getEntity() != null) {
            return new EntityTag(this);
        }
        return new ElementTag(this.identify());
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to an NPC!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Waypoints wp;
        if (mechanism.matches("set_assignment") && mechanism.requireObject(ScriptTag.class)) {
            this.getAssignmentTrait().setAssignment(mechanism.valueAsType(ScriptTag.class).getName(), null);
        }
        if (mechanism.matches("remove_assignment")) {
            this.getAssignmentTrait().removeAssignment(null);
        }
        if (mechanism.matches("set_nickname")) {
            this.getNicknameTrait().setNickname(mechanism.getValue().asString());
        }
        if (mechanism.matches("remove_nickname")) {
            this.getNicknameTrait().removeNickname();
        }
        if (mechanism.matches("set_entity_type") && mechanism.requireObject(EntityTag.class)) {
            this.getCitizen().setBukkitEntityType(mechanism.valueAsType(EntityTag.class).getBukkitEntityType());
        }
        if (mechanism.matches("name") || mechanism.matches("set_name")) {
            this.getCitizen().setName(mechanism.getValue().asString().length() > 64 ? mechanism.getValue().asString().substring(0, 64) : mechanism.getValue().asString());
        }
        if (mechanism.matches("owner")) {
            ((Owner)this.getCitizen().getTrait(Owner.class)).setOwner(mechanism.getValue().asString());
        }
        if (mechanism.matches("skin_blob")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("cached-skin-uuid");
                this.getCitizen().data().remove("player-skin-textures");
                this.getCitizen().data().remove("player-skin-signature");
                if (this.getCitizen().isSpawned()) {
                    this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                    this.getCitizen().spawn(this.getCitizen().getStoredLocation());
                }
            } else {
                String[] dat = mechanism.getValue().asString().split(";");
                this.getCitizen().data().remove("cached-skin-uuid");
                this.getCitizen().data().setPersistent("player-skin-textures", (Object)dat[0]);
                this.getCitizen().data().setPersistent("player-skin-signature", dat.length > 1 ? dat[1] : null);
                if (dat.length > 2) {
                    this.getCitizen().data().setPersistent("player-skin-name", (Object)dat[2]);
                }
                if (this.getCitizen().isSpawned() && this.getCitizen().getEntity() instanceof SkinnableEntity) {
                    ((SkinnableEntity)this.getCitizen().getEntity()).setSkinPersistent(dat.length > 2 ? dat[2] : "unspecified", dat.length > 1 ? dat[1] : null, dat[0]);
                    ((SkinnableEntity)this.getCitizen().getEntity()).getSkinTracker().notifySkinChange(true);
                }
            }
        }
        if (mechanism.matches("skin")) {
            if (!mechanism.hasValue()) {
                this.getCitizen().data().remove("player-skin-name");
            } else {
                this.getCitizen().data().setPersistent("player-skin-name", (Object)mechanism.getValue().asString());
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn(DespawnReason.PENDING_RESPAWN);
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("item_type") && mechanism.requireObject(ItemTag.class)) {
            ItemTag item = mechanism.valueAsType(ItemTag.class);
            Material mat = item.getMaterial().getMaterial();
            byte data = item.getMaterial().getData((byte)0);
            switch (this.getEntity().getType()) {
                case DROPPED_ITEM: {
                    ((Item)this.getEntity()).getItemStack().setType(mat);
                    break;
                }
                case ITEM_FRAME: {
                    ((ItemFrame)this.getEntity()).getItem().setType(mat);
                    break;
                }
                case FALLING_BLOCK: {
                    break;
                }
                default: {
                    Debug.echoError("NPC is the not an item type!");
                }
            }
            if (this.getCitizen().isSpawned()) {
                this.getCitizen().despawn();
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("spawn")) {
            if (mechanism.requireObject("Invalid LocationTag specified. Assuming last known NPC location.", LocationTag.class)) {
                this.getCitizen().spawn((Location)mechanism.valueAsType(LocationTag.class));
            } else {
                this.getCitizen().spawn(this.getCitizen().getStoredLocation());
            }
        }
        if (mechanism.matches("range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().range(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("attack_range") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().attackRange((double)mechanism.getValue().asFloat());
        }
        if (mechanism.matches("speed") && mechanism.requireFloat()) {
            this.getCitizen().getNavigator().getDefaultParameters().speedModifier(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("despawn")) {
            this.getCitizen().despawn(DespawnReason.PLUGIN);
        }
        if (mechanism.matches("set_sneaking") && mechanism.requireBoolean()) {
            SneakingTrait trait;
            if (!this.getCitizen().hasTrait(SneakingTrait.class)) {
                this.getCitizen().addTrait(SneakingTrait.class);
            }
            if ((trait = (SneakingTrait)this.getCitizen().getTrait(SneakingTrait.class)).isSneaking() && !mechanism.getValue().asBoolean()) {
                trait.sneak();
            } else if (!trait.isSneaking() && mechanism.getValue().asBoolean()) {
                trait.stand();
            }
        }
        if (mechanism.matches("set_protected") && mechanism.requireBoolean()) {
            this.getCitizen().setProtected(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("lookclose") && mechanism.requireBoolean()) {
            this.getLookCloseTrait().lookClose(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("teleport_on_stuck") && mechanism.requireBoolean()) {
            if (mechanism.getValue().asBoolean()) {
                this.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
            } else {
                this.getNavigator().getDefaultParameters().stuckAction(null);
            }
        }
        if ((mechanism.matches("distance_margin") || mechanism.matches("set_distance")) && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().distanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("path_distance_margin") && mechanism.requireDouble()) {
            this.getNavigator().getDefaultParameters().pathDistanceMargin(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("name_visible")) {
            this.getCitizen().data().setPersistent("nameplate-visible", (Object)mechanism.getValue().asString());
        }
        if (mechanism.matches("clear_waypoints")) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).clear();
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                List locs = ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres();
                for (Location loc : locs) {
                    locs.remove(loc);
                }
            }
        }
        if (mechanism.matches("add_waypoint") && mechanism.requireObject(LocationTag.class)) {
            if (!this.getCitizen().hasTrait(Waypoints.class)) {
                this.getCitizen().addTrait(Waypoints.class);
            }
            if ((wp = (Waypoints)this.getCitizen().getTrait(Waypoints.class)).getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
                ((List)((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()).add(new Waypoint((Location)mechanism.valueAsType(LocationTag.class)));
            } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
                ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres().add(mechanism.valueAsType(LocationTag.class));
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isSpawned()) {
            new EntityTag(this.getEntity()).adjust(mechanism);
        }
    }
}

