/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.flags.FlagManager;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.interfaces.AdvancementHelper;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityHealth;
import com.denizenscript.denizen.scripts.commands.player.SidebarCommand;
import com.denizenscript.denizen.tags.core.PlayerTagBase;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.BossBarHelper;
import com.denizenscript.denizen.utilities.packets.ItemChangeMessage;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Block;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.map.MapView;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.BlockIterator;

public class PlayerTag
implements ObjectTag,
Adjustable,
EntityFormObject {
    static Map<String, UUID> playerNames = new HashMap<String, UUID>();
    public static String playerByNameMessage = Deprecations.playerByNameWarning.message;
    OfflinePlayer offlinePlayer = null;
    private String prefix = "Player";
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static PlayerTag mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return new PlayerTag(player);
    }

    public static void notePlayer(OfflinePlayer player) {
        if (player.getName() == null) {
            Debug.echoError("Null player " + player.toString());
            return;
        }
        if (!playerNames.containsKey(CoreUtilities.toLowerCase(player.getName()))) {
            playerNames.put(CoreUtilities.toLowerCase(player.getName()), player.getUniqueId());
        }
    }

    public static boolean isNoted(OfflinePlayer player) {
        return playerNames.containsValue(player.getUniqueId());
    }

    public static Map<String, UUID> getAllPlayers() {
        return playerNames;
    }

    public static PlayerTag valueOf(String string) {
        return PlayerTag.valueOf(string, null);
    }

    @Fetchable(value="p")
    public static PlayerTag valueOf(String string, TagContext context) {
        return PlayerTag.valueOfInternal(string, context, true);
    }

    public static PlayerTag valueOfInternal(String string, boolean announce) {
        return PlayerTag.valueOfInternal(string, null, announce);
    }

    public static PlayerTag valueOfInternal(String string, TagContext context, boolean defaultAnnounce) {
        if (string == null) {
            return null;
        }
        boolean announce = context == null ? defaultAnnounce : context.debug;
        if ((string = string.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null) {
                    return new PlayerTag(player);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        if (playerNames.containsKey(CoreUtilities.toLowerCase(string))) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerNames.get(CoreUtilities.toLowerCase(string)));
            if (announce) {
                Deprecations.playerByNameWarning.message = playerByNameMessage + " Player named '" + player.getName() + "' has UUID: " + player.getUniqueId();
                Deprecations.playerByNameWarning.warn(context);
            }
            return new PlayerTag(player);
        }
        if (announce) {
            Debug.log("Minor: Invalid Player! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (CoreUtilities.toLowerCase(arg).startsWith("p@")) {
            return true;
        }
        if ((arg = arg.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(arg);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null && player.hasPlayedBefore()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean playerNameIsValid(String name) {
        return playerNames.containsKey(CoreUtilities.toLowerCase(name));
    }

    public PlayerTag(OfflinePlayer player) {
        this.offlinePlayer = player;
    }

    public PlayerTag(UUID uuid) {
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public PlayerTag(Player player) {
        this((OfflinePlayer)player);
        if (EntityTag.isNPC((Entity)player)) {
            throw new IllegalStateException("NPCs are not allowed as PlayerTag objects!");
        }
    }

    public boolean isValid() {
        return this.getPlayerEntity() != null || this.getOfflinePlayer() != null;
    }

    public Player getPlayerEntity() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)this.offlinePlayer.getUniqueId());
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public ImprovedOfflinePlayer getNBTEditor() {
        return NMSHandler.getPlayerHelper().getOfflineData(this.getOfflinePlayer());
    }

    @Override
    public EntityTag getDenizenEntity() {
        return new EntityTag((Entity)this.getPlayerEntity());
    }

    public NPCTag getSelectedNPC() {
        NPC npc;
        if (Depends.citizens != null && CitizensAPI.hasImplementation() && (npc = CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)this.getPlayerEntity())) != null) {
            return NPCTag.mirrorCitizensNPC(npc);
        }
        return null;
    }

    public String getName() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return this.offlinePlayer.getName();
    }

    public String getSaveName() {
        if (this.offlinePlayer == null) {
            return "00.UNKNOWN";
        }
        String baseID = this.offlinePlayer.getUniqueId().toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    public LocationTag getLocation() {
        if (this.isOnline()) {
            return new LocationTag(this.getPlayerEntity().getLocation());
        }
        return new LocationTag(this.getNBTEditor().getLocation());
    }

    public int getRemainingAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getRemainingAir();
        }
        return this.getNBTEditor().getRemainingAir();
    }

    public int getMaximumAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaximumAir();
        }
        return 300;
    }

    public double getHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getHealth();
        }
        return this.getNBTEditor().getHealthFloat();
    }

    public double getMaxHealth() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaxHealth();
        }
        return this.getNBTEditor().getMaxHealth();
    }

    public int getFoodLevel() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getFoodLevel();
        }
        return this.getNBTEditor().getFoodLevel();
    }

    public LocationTag getEyeLocation() {
        if (this.isOnline()) {
            return new LocationTag(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public PlayerInventory getBukkitInventory() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getInventory();
        }
        return this.getNBTEditor().getInventory();
    }

    public InventoryTag getInventory() {
        if (this.isOnline()) {
            return InventoryTag.mirrorBukkitInventory((Inventory)this.getPlayerEntity().getInventory());
        }
        return new InventoryTag(this.getNBTEditor());
    }

    public CraftingInventory getBukkitWorkbench() {
        if (this.isOnline() && (this.getPlayerEntity().getOpenInventory().getType() == InventoryType.WORKBENCH || this.getPlayerEntity().getOpenInventory().getType() == InventoryType.CRAFTING)) {
            return (CraftingInventory)this.getPlayerEntity().getOpenInventory().getTopInventory();
        }
        return null;
    }

    public InventoryTag getWorkbench() {
        CraftingInventory workbench;
        if (this.isOnline() && (workbench = this.getBukkitWorkbench()) != null) {
            return new InventoryTag((Inventory)workbench, (InventoryHolder)this.getPlayerEntity());
        }
        return null;
    }

    public Inventory getBukkitEnderChest() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getEnderChest();
        }
        return this.getNBTEditor().getEnderChest();
    }

    public InventoryTag getEnderChest() {
        if (this.isOnline()) {
            return new InventoryTag(this.getPlayerEntity().getEnderChest(), (InventoryHolder)this.getPlayerEntity());
        }
        return new InventoryTag(this.getNBTEditor(), true);
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return this.getLocation().getWorld();
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().decrementStatistic(statistic, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().decrementStatistic(statistic, entity, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().decrementStatistic(statistic, material, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().incrementStatistic(statistic, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().incrementStatistic(statistic, entity, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().incrementStatistic(statistic, material, amount);
        }
    }

    public void setStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().setStatistic(statistic, amount);
        }
    }

    public void setStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().setStatistic(statistic, entity, amount);
        }
    }

    public void setStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().setStatistic(statistic, material, amount);
        }
    }

    public boolean isOnline() {
        return this.getPlayerEntity() != null;
    }

    public void setBedSpawnLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().setBedSpawnLocation(location);
        } else {
            this.getNBTEditor().setBedSpawnLocation(location, this.getNBTEditor().isSpawnForced());
        }
    }

    public void setLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().teleport(location);
        } else {
            this.getNBTEditor().setLocation(location);
        }
    }

    public void setMaximumAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaximumAir(air);
        } else {
            Debug.echoError("Cannot set the maximum air of an offline player!");
        }
    }

    public void setRemainingAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setRemainingAir(air);
        } else {
            this.getNBTEditor().setRemainingAir(air);
        }
    }

    public void setHealth(double health) {
        if (this.isOnline()) {
            this.getPlayerEntity().setHealth(health);
        } else {
            this.getNBTEditor().setHealthFloat((float)health);
        }
    }

    public void setMaxHealth(double maxHealth) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaxHealth(maxHealth);
        } else {
            this.getNBTEditor().setMaxHealth(maxHealth);
        }
    }

    public void setFoodLevel(int foodLevel) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFoodLevel(foodLevel);
        } else {
            this.getNBTEditor().setFoodLevel(foodLevel);
        }
    }

    public void setLevel(int level) {
        if (this.isOnline()) {
            this.getPlayerEntity().setLevel(level);
        } else {
            this.getNBTEditor().setLevel(level);
        }
    }

    public void setFlySpeed(float speed) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFlySpeed(speed);
        } else {
            this.getNBTEditor().setFlySpeed(speed);
        }
    }

    public void setGameMode(GameMode mode) {
        if (this.isOnline()) {
            this.getPlayerEntity().setGameMode(mode);
        } else {
            this.getNBTEditor().setGameMode(mode);
        }
    }

    public boolean hasChunkLoaded(Chunk chunk) {
        return NMSHandler.getPlayerHelper().hasChunkLoaded(this.getPlayerEntity(), chunk);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public PlayerTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "p@" + this.offlinePlayer.getUniqueId().toString() + "<GR> (" + this.offlinePlayer.getName() + ")";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "Player";
    }

    @Override
    public String identify() {
        return "p@" + this.offlinePlayer.getUniqueId().toString();
    }

    @Override
    public String identifySimple() {
        return "p@" + this.offlinePlayer.getName();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        PlayerTag.registerTag("is_player", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("chat_history_list", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ListTag(PlayerTagBase.playerChatHistory.get(((PlayerTag)object).getOfflinePlayer().getUniqueId())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("chat_history", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                int x = 1;
                if (attribute.hasContext(1) && ArgumentHelper.matchesInteger(attribute.getContext(1))) {
                    x = attribute.getIntContext(1);
                }
                if (!PlayerTagBase.playerChatHistory.containsKey(((PlayerTag)object).getOfflinePlayer().getUniqueId())) {
                    return null;
                }
                List<String> messages = PlayerTagBase.playerChatHistory.get(((PlayerTag)object).getOfflinePlayer().getUniqueId());
                if (messages.size() < x || x < 1) {
                    return null;
                }
                return new ElementTag(messages.get(x - 1)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("flag", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                    return new ElementTag(!FlagManager.playerHasFlag((PlayerTag)object, flag_name)).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.playerHasFlag((PlayerTag)object, flag_name)) {
                    return new ElementTag(0).getObjectAttribute(attribute.fulfill(2));
                }
                if (FlagManager.playerHasFlag((PlayerTag)object, flag_name)) {
                    FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag((PlayerTag)object, flag_name);
                    if (attribute.getAttribute(2).equalsIgnoreCase("expiration")) {
                        return flag.expiration().getObjectAttribute(attribute.fulfill(2));
                    }
                    return new ListTag(flag.toString(), true, flag.values()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).identify()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("has_flag", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String flag_name = attribute.getContext(1);
                return new ElementTag(FlagManager.playerHasFlag((PlayerTag)object, flag_name)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("list_flags", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag allFlags = new ListTag(DenizenAPI.getCurrentInstance().flagManager().listPlayerFlags((PlayerTag)object));
                ListTag searchFlags = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    searchFlags = new ListTag();
                    String search = attribute.getContext(1);
                    if (search.startsWith("regex:")) {
                        try {
                            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(search.substring(6), 2);
                            for (String flag : allFlags) {
                                if (!pattern.matcher(flag).matches()) continue;
                                searchFlags.add(flag);
                            }
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                    } else {
                        search = CoreUtilities.toLowerCase(search);
                        for (String flag : allFlags) {
                            if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                            searchFlags.add(flag);
                        }
                    }
                    DenizenAPI.getCurrentInstance().flagManager().shrinkPlayerFlags((PlayerTag)object, searchFlags);
                } else {
                    DenizenAPI.getCurrentInstance().flagManager().shrinkPlayerFlags((PlayerTag)object, allFlags);
                }
                return searchFlags == null ? allFlags.getObjectAttribute(attribute.fulfill(1)) : searchFlags.getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("current_step", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String outcome = "null";
                if (attribute.hasContext(1)) {
                    try {
                        outcome = DenizenAPI.getCurrentInstance().getSaves().getString("Players." + ((PlayerTag)object).getName() + ".Scripts." + ScriptTag.valueOf(attribute.getContext(1)).getName() + ".Current Step");
                    }
                    catch (Exception e) {
                        outcome = "null";
                    }
                }
                return new ElementTag(outcome).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("money", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (Depends.economy == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    }
                    return null;
                }
                if ((attribute = attribute.fulfill(1)).startsWith("formatted")) {
                    return new ElementTag(Depends.economy.format(Depends.economy.getBalance(((PlayerTag)object).getOfflinePlayer()))).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("currency_singular")) {
                    Deprecations.oldEconomyTags.warn(attribute.getScriptEntry());
                    return new ElementTag(Depends.economy.currencyNameSingular()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("currency")) {
                    Deprecations.oldEconomyTags.warn(attribute.getScriptEntry());
                    return new ElementTag(Depends.economy.currencyNamePlural()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(Depends.economy.getBalance(((PlayerTag)object).getOfflinePlayer())).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("target", new TagRunnable.ObjectForm(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                int range = 50;
                int attribs = 1;
                if (attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2) && ArgumentHelper.matchesInteger(attribute.getContext(2))) {
                    attribs = 2;
                    range = attribute.getIntContext(2);
                }
                List entities = ((PlayerTag)object).getPlayerEntity().getNearbyEntities((double)range, (double)range, (double)range);
                ArrayList<LivingEntity> possibleTargets = new ArrayList<LivingEntity>();
                if (!attribute.hasContext(1)) {
                    for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        possibleTargets.add((LivingEntity)entity);
                    }
                } else {
                    ListTag list = ListTag.getListFor(attribute.getContextObject(1));
                    block8: for (Entity entity : entities) {
                        if (!(entity instanceof LivingEntity)) continue;
                        for (ObjectTag obj : list.objectForms) {
                            boolean valid = false;
                            EntityTag filterEntity = null;
                            if (obj instanceof EntityTag) {
                                filterEntity = (EntityTag)obj;
                            } else if (CoreUtilities.toLowerCase(obj.toString()).equals("npc")) {
                                valid = EntityTag.isCitizensNPC(entity);
                            } else {
                                filterEntity = EntityTag.getEntityFor(obj, attribute.context);
                                if (filterEntity == null) {
                                    Debug.echoError("Trying to filter 'player.target[...]' tag with invalid input: " + obj.toString());
                                    continue;
                                }
                            }
                            if (!valid && filterEntity != null) {
                                valid = filterEntity.isGeneric() ? filterEntity.getBukkitEntityType().equals((Object)entity.getType()) : filterEntity.getUUID().equals(entity.getUniqueId());
                            }
                            if (!valid) continue;
                            possibleTargets.add((LivingEntity)entity);
                            continue block8;
                        }
                    }
                }
                try {
                    BlockIterator bi;
                    NMSHandler.getChunkHelper().changeChunkServerThread(((PlayerTag)object).getWorld());
                    try {
                        bi = new BlockIterator((LivingEntity)((PlayerTag)object).getPlayerEntity(), range);
                    }
                    catch (IllegalStateException e) {
                        Entity entity;
                        entity = null;
                        NMSHandler.getChunkHelper().restoreServerThread(((PlayerTag)object).getWorld());
                        return entity;
                    }
                    while (bi.hasNext()) {
                        Block b = bi.next();
                        int bx = b.getX();
                        int by = b.getY();
                        int bz = b.getZ();
                        if (b.getType().isSolid()) {
                            break;
                        }
                        for (LivingEntity possibleTarget : possibleTargets) {
                            Location l = possibleTarget.getLocation();
                            double ex = l.getX();
                            double ey = l.getY();
                            double ez = l.getZ();
                            if (!((double)bx - 0.5 <= ex) || !(ex <= (double)bx + 1.5) || !((double)bz - 0.5 <= ez) || !(ez <= (double)bz + 1.5) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                            ObjectTag objectTag = new EntityTag((Entity)possibleTarget).getDenizenObject().getObjectAttribute(attribute.fulfill(attribs));
                            return objectTag;
                        }
                    }
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(((PlayerTag)object).getWorld());
                }
                return null;
            }
        });
        PlayerTag.registerTag("list_effects", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag effects = new ListTag();
                for (PotionEffect effect : ((PlayerTag)object).getPlayerEntity().getActivePotionEffects()) {
                    effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "t");
                }
                return effects.getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("list", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Debug.echoError("DO NOT USE PLAYER.LIST AS A TAG, please use <server.list_online_players> and related tags!");
                ArrayList<String> players = new ArrayList<String>();
                if (attribute.startsWith("list.online")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        players.add(player.getName());
                    }
                    return new ListTag((List<String>)players).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("list.offline")) {
                    for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                        if (player.isOnline()) continue;
                        players.add("p@" + player.getUniqueId().toString());
                    }
                    return new ListTag((List<String>)players).getObjectAttribute(attribute.fulfill(2));
                }
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    players.add("p@" + player.getUniqueId().toString());
                }
                return new ListTag((List<String>)players).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Player").getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("save_name", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getSaveName()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("bed_spawn", new TagRunnable.ObjectForm(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                try {
                    NMSHandler.getChunkHelper().changeChunkServerThread(((PlayerTag)object).getWorld());
                    if (((PlayerTag)object).getOfflinePlayer().getBedSpawnLocation() == null) {
                        ObjectTag objectTag = null;
                        return objectTag;
                    }
                    ObjectTag objectTag = new LocationTag(((PlayerTag)object).getOfflinePlayer().getBedSpawnLocation()).getObjectAttribute(attribute.fulfill(1));
                    return objectTag;
                }
                finally {
                    NMSHandler.getChunkHelper().restoreServerThread(((PlayerTag)object).getWorld());
                }
            }
        });
        PlayerTag.registerTag("location", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((PlayerTag)object).isOnline() && !((PlayerTag)object).getPlayerEntity().isDead()) {
                    return new EntityTag((Entity)((PlayerTag)object).getPlayerEntity()).getObjectAttribute(attribute);
                }
                return ((PlayerTag)object).getLocation().getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("world", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new WorldTag(((PlayerTag)object).getWorld()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("item_cooldown", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                MaterialTag mat = new ElementTag(attribute.getContext(1)).asType(MaterialTag.class, attribute.context);
                if (mat != null) {
                    return new DurationTag((long)((PlayerTag)object).getPlayerEntity().getCooldown(mat.getMaterial())).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerTag("first_played", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                    return new ElementTag(((PlayerTag)object).getOfflinePlayer().getFirstPlayed()).getObjectAttribute(attribute.fulfill(1));
                }
                return new DurationTag(((PlayerTag)object).getOfflinePlayer().getFirstPlayed() / 50L).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("has_played_before", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("absorption_health", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(NMSHandler.getPlayerHelper().getAbsorption(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("exhaustion", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getExhaustion()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("oxygen", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("max")) {
                    return new DurationTag((long)((PlayerTag)object).getMaximumAir()).getObjectAttribute(attribute.fulfill(1));
                }
                return new DurationTag((long)((PlayerTag)object).getRemainingAir()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("health", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("is_scaled")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().isHealthScaled()).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("scale")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getHealthScale()).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("formatted")) {
                    return EntityHealth.getHealthFormatted(new EntityTag((Entity)((PlayerTag)object).getPlayerEntity()), attribute.fulfill(1));
                }
                if (attribute.startsWith("percentage")) {
                    double maxHealth = ((PlayerTag)object).getPlayerEntity().getMaxHealth();
                    if (attribute.hasContext(1)) {
                        maxHealth = attribute.getIntContext(1);
                    }
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getHealth() / maxHealth * 100.0).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("max")) {
                    return new ElementTag(((PlayerTag)object).getMaxHealth()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).getHealth()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("is_banned", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(((PlayerTag)object).getName());
                if (ban == null) {
                    return new ElementTag(false).getObjectAttribute(attribute.fulfill(1));
                }
                if (ban.getExpiration() == null) {
                    return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(ban.getExpiration().after(new Date())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("is_online", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).isOnline()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("is_op", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getOfflinePlayer().isOp()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("is_whitelisted", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getOfflinePlayer().isWhitelisted()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("last_played", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                    if (((PlayerTag)object).isOnline()) {
                        return new ElementTag(System.currentTimeMillis()).getObjectAttribute(attribute.fulfill(1));
                    }
                    return new ElementTag(((PlayerTag)object).getOfflinePlayer().getLastPlayed()).getObjectAttribute(attribute.fulfill(1));
                }
                if (((PlayerTag)object).isOnline()) {
                    return new DurationTag(System.currentTimeMillis() / 50L).getObjectAttribute(attribute);
                }
                return new DurationTag(((PlayerTag)object).getOfflinePlayer().getLastPlayed() / 50L).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("groups", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                ListTag list = new ListTag();
                for (String group : Depends.permissions.getGroups()) {
                    if (!Depends.permissions.playerInGroup(null, ((PlayerTag)object).offlinePlayer, group)) continue;
                    list.add(group);
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("ban_info", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                attribute.fulfill(1);
                BanEntry ban = Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntry(((PlayerTag)object).getName());
                if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                    return null;
                }
                if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                    return new DurationTag(ban.getExpiration().getTime() / 50L).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("reason")) {
                    return new ElementTag(ban.getReason()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("created")) {
                    return new DurationTag(ban.getCreated().getTime() / 50L).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("source")) {
                    return new ElementTag(ban.getSource()).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerTag("in_group", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                String group = attribute.getContext(1);
                if (attribute.getAttribute(2).startsWith("global")) {
                    return new ElementTag(Depends.permissions.playerInGroup((World)null, ((PlayerTag)object).getName(), group)).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    return new ElementTag(Depends.permissions.playerInGroup(attribute.getContext(2), ((PlayerTag)object).getName(), group)).getObjectAttribute(attribute.fulfill(2));
                }
                if (((PlayerTag)object).isOnline()) {
                    return new ElementTag(Depends.permissions.playerInGroup(((PlayerTag)object).getPlayerEntity(), group)).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerTag("has_permission", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                String permission = attribute.getContext(1);
                if (attribute.getAttribute(2).startsWith("global")) {
                    if (Depends.permissions == null) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                        }
                        return null;
                    }
                    return new ElementTag(Depends.permissions.playerHas(null, ((PlayerTag)object).getOfflinePlayer(), permission)).getObjectAttribute(attribute.fulfill(2));
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    if (Depends.permissions == null) {
                        if (!attribute.hasAlternative()) {
                            Debug.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                        }
                        return null;
                    }
                    return new ElementTag(Depends.permissions.playerHas(attribute.getContext(2), ((PlayerTag)object).getOfflinePlayer(), permission)).getObjectAttribute(attribute.fulfill(2));
                }
                if (((PlayerTag)object).isOnline()) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().hasPermission(permission)).getObjectAttribute(attribute.fulfill(1));
                }
                if (Depends.permissions != null) {
                    return new ElementTag(Depends.permissions.playerHas(null, ((PlayerTag)object).getOfflinePlayer(), permission)).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerTag("permission", PlayerTag.tagProcessor.registeredObjectTags.get("has_permission"));
        PlayerTag.registerTag("uuid", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getOfflinePlayer().getUniqueId().toString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("name", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("list") && ((PlayerTag)object).isOnline()) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getPlayerListName()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("display") && ((PlayerTag)object).isOnline()) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getDisplayName()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).getName()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("inventory", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((PlayerTag)object).getInventory().getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("enderchest", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return ((PlayerTag)object).getEnderChest().getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("open_inventory", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return InventoryTag.mirrorBukkitInventory(((PlayerTag)object).getPlayerEntity().getOpenInventory().getTopInventory()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("discovered_recipes", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ListTag(NMSHandler.getEntityHelper().getDiscoveredRecipes(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("selected_trade_index", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((PlayerTag)object).getPlayerEntity().getOpenInventory().getTopInventory() instanceof MerchantInventory) {
                    return new ElementTag(((MerchantInventory)((PlayerTag)object).getPlayerEntity().getOpenInventory().getTopInventory()).getSelectedRecipeIndex() + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("item_on_cursor", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ItemTag(((PlayerTag)object).getPlayerEntity().getItemOnCursor()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("item_in_hand", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("slot")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getInventory().getHeldItemSlot() + 1).getObjectAttribute(attribute.fulfill(1));
                }
                return new ItemTag(((PlayerTag)object).getPlayerEntity().getEquipment().getItemInMainHand()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerOnlineOnlyTag("sidebar", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("lines")) {
                    Sidebar sidebar = SidebarCommand.getSidebar((PlayerTag)object);
                    if (sidebar == null) {
                        return null;
                    }
                    return new ListTag(sidebar.getLinesText()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("title")) {
                    Sidebar sidebar = SidebarCommand.getSidebar((PlayerTag)object);
                    if (sidebar == null) {
                        return null;
                    }
                    return new ElementTag(sidebar.getTitle()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("scores")) {
                    Sidebar sidebar = SidebarCommand.getSidebar((PlayerTag)object);
                    if (sidebar == null) {
                        return null;
                    }
                    ListTag scores = new ListTag();
                    for (int score : sidebar.getScores()) {
                        scores.add(String.valueOf(score));
                    }
                    return scores.getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("skin_blob", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(NMSHandler.getInstance().getProfileEditor().getPlayerSkinBlob(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("attack_cooldown", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                attribute.fulfill(1);
                if (attribute.startsWith("duration")) {
                    return new DurationTag((long)NMSHandler.getPlayerHelper().ticksPassedDuringCooldown(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("max_duration")) {
                    return new DurationTag((long)NMSHandler.getPlayerHelper().getMaxAttackCooldownTicks(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("percent")) {
                    return new ElementTag(NMSHandler.getPlayerHelper().getAttackCooldownPercent(((PlayerTag)object).getPlayerEntity()) * 100.0f).getObjectAttribute(attribute.fulfill(1));
                }
                Debug.echoError("The tag 'player.attack_cooldown...' must be followed by a sub-tag.");
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("selected_npc", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((PlayerTag)object).getPlayerEntity().hasMetadata("selected")) {
                    return ((PlayerTag)object).getSelectedNPC().getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("entity", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new EntityTag((Entity)((PlayerTag)object).getPlayerEntity()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("ip", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("address_only")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getAddress().toString()).getObjectAttribute(attribute.fulfill(1));
                }
                String host = ((PlayerTag)object).getPlayerEntity().getAddress().getHostName();
                if (attribute.startsWith("address")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getAddress().toString()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(host).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerOnlineOnlyTag("host_name", PlayerTag.tagProcessor.registeredObjectTags.get("ip"));
        PlayerTag.registerOnlineOnlyTag("nameplate", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(NMSHandler.getInstance().getProfileEditor().getPlayerName(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("compass_target", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Location target = ((PlayerTag)object).getPlayerEntity().getCompassTarget();
                if (target != null) {
                    return new LocationTag(target).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("chunk_loaded", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                ChunkTag chunk = ChunkTag.valueOf(attribute.getContext(1));
                if (chunk == null) {
                    return null;
                }
                return new ElementTag(chunk.isLoadedSafe() && ((PlayerTag)object).hasChunkLoaded(chunk.getChunkForTag(attribute))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("can_fly", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getAllowFlight()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("allowed_flight", PlayerTag.tagProcessor.registeredObjectTags.get("can_fly"));
        PlayerTag.registerOnlineOnlyTag("fly_speed", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getFlySpeed()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("saturation", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getSaturation()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("food_level", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("formatted")) {
                    int foodLevel;
                    double maxHunger = ((PlayerTag)object).getPlayerEntity().getMaxHealth();
                    if (attribute.hasContext(1)) {
                        maxHunger = attribute.getIntContext(1);
                    }
                    if ((double)(foodLevel = ((PlayerTag)object).getFoodLevel()) / maxHunger < 0.1) {
                        return new ElementTag("starving").getObjectAttribute(attribute.fulfill(1));
                    }
                    if ((double)foodLevel / maxHunger < 0.4) {
                        return new ElementTag("famished").getObjectAttribute(attribute.fulfill(1));
                    }
                    if ((double)foodLevel / maxHunger < 0.75) {
                        return new ElementTag("parched").getObjectAttribute(attribute.fulfill(1));
                    }
                    if ((double)foodLevel / maxHunger < 1.0) {
                        return new ElementTag("hungry").getObjectAttribute(attribute.fulfill(1));
                    }
                    return new ElementTag("healthy").getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).getFoodLevel()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerOnlineOnlyTag("gamemode", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("id")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getGameMode().getValue()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getGameMode().name()).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerOnlineOnlyTag("is_blocking", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().isBlocking()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("ping", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(NMSHandler.getPlayerHelper().getPing(((PlayerTag)object).getPlayerEntity())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("is_flying", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().isFlying()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("is_sleeping", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().isSleeping()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("is_sneaking", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().isSneaking()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("is_sprinting", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().isSprinting()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("has_advancement", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                Advancement adv = AdvancementHelper.getAdvancement(attribute.getContext(1));
                if (adv == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Advancement '" + attribute.getContext(1) + "' does not exist.");
                    }
                    return null;
                }
                AdvancementProgress progress = ((PlayerTag)object).getPlayerEntity().getAdvancementProgress(adv);
                return new ElementTag(progress.isDone()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("list_advancements", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                ListTag list = new ListTag();
                Bukkit.advancementIterator().forEachRemaining(adv -> {
                    if (((PlayerTag)object).getPlayerEntity().getAdvancementProgress(adv).isDone()) {
                        list.add(adv.getKey().toString());
                    }
                });
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("statistic", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                Statistic statistic = Statistic.valueOf((String)attribute.getContext(1).toUpperCase());
                if (statistic == null) {
                    return null;
                }
                if (attribute.getAttribute(2).startsWith("qualifier")) {
                    ObjectTag obj = ObjectFetcher.pickObjectFor(attribute.getContext(2), attribute.context);
                    try {
                        if (obj instanceof MaterialTag) {
                            return new ElementTag(((PlayerTag)object).getPlayerEntity().getStatistic(statistic, ((MaterialTag)obj).getMaterial())).getObjectAttribute(attribute.fulfill(2));
                        }
                        if (obj instanceof EntityTag) {
                            return new ElementTag(((PlayerTag)object).getPlayerEntity().getStatistic(statistic, ((EntityTag)obj).getBukkitEntityType())).getObjectAttribute(attribute.fulfill(2));
                        }
                        return null;
                    }
                    catch (Exception e) {
                        Debug.echoError("Invalid statistic: " + statistic + " for this player!");
                        return null;
                    }
                }
                try {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getStatistic(statistic)).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception e) {
                    Debug.echoError("Invalid statistic: " + statistic + " for this player!");
                    return null;
                }
            }
        });
        PlayerTag.registerOnlineOnlyTag("time_asleep", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new DurationTag(((PlayerTag)object).getPlayerEntity().getSleepTicks() / 20).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("time", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getPlayerTime()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("walk_speed", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getWalkSpeed()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerOnlineOnlyTag("weather", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (((PlayerTag)object).getPlayerEntity().getPlayerWeather() != null) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getPlayerWeather().name()).getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        PlayerTag.registerOnlineOnlyTag("xp", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if ((attribute = attribute.fulfill(1)).startsWith("level")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getLevel()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("to_next_level")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getExpToLevel()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("total")) {
                    return new ElementTag(((PlayerTag)object).getPlayerEntity().getTotalExperience()).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(((PlayerTag)object).getPlayerEntity().getExp() * 100.0f).getObjectAttribute(attribute);
            }
        });
        PlayerTag.registerTag("chat_prefix", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (Depends.chat == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'chat_prefix' tag unavailable: Vault and a chat plugin are required.");
                    }
                    return null;
                }
                String prefix = Depends.chat.getPlayerPrefix(((PlayerTag)object).getWorld().getName(), ((PlayerTag)object).getOfflinePlayer());
                if (prefix == null) {
                    return null;
                }
                return new ElementTag(prefix).getObjectAttribute(attribute.fulfill(1));
            }
        });
        PlayerTag.registerTag("chat_suffix", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (Depends.chat == null) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("'chat_suffix' tag unavailable: Vault and a chat plugin are required.");
                    }
                    return null;
                }
                String suffix = Depends.chat.getPlayerSuffix(((PlayerTag)object).getWorld().getName(), ((PlayerTag)object).getOfflinePlayer());
                if (suffix == null) {
                    return null;
                }
                return new ElementTag(suffix).getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerOnlineOnlyTag(String name, final TagRunnable.ObjectForm runnable) {
        TagRunnable.ObjectForm newRunnable = new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!((PlayerTag)object).isOnline()) {
                    if (!attribute.hasAlternative()) {
                        Debug.echoError("Player is not online, but tag '" + attribute.getAttributeWithoutContext(1) + "' requires the player be online, for player: " + object.debuggable());
                    }
                    return null;
                }
                return runnable.run(attribute, object);
            }
        };
        newRunnable.name = runnable.name;
        PlayerTag.registerTag(name, newRunnable);
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        if (this.isOnline()) {
            return new EntityTag((Entity)this.getPlayerEntity());
        }
        return new ElementTag(this.identify());
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("Cannot apply properties to a player!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("respawn")) {
            NMSHandler.getPacketHelper().respawn(this.getPlayerEntity());
        }
        if (mechanism.matches("vision")) {
            if (mechanism.hasValue() && mechanism.requireEnum(false, (Enum<?>[])EntityType.values())) {
                NMSHandler.getPacketHelper().setVision(this.getPlayerEntity(), EntityType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else {
                NMSHandler.getPacketHelper().forceSpectate(this.getPlayerEntity(), (Entity)this.getPlayerEntity());
            }
        }
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.setLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("item_slot") && mechanism.requireInteger()) {
            if (this.isOnline()) {
                this.getPlayerEntity().getInventory().setHeldItemSlot(mechanism.getValue().asInt() - 1);
            } else {
                this.getNBTEditor().setItemInHand(mechanism.getValue().asInt() - 1);
            }
        }
        if (mechanism.matches("window_property")) {
            String[] split = mechanism.getValue().asString().split(",", 2);
            if (split.length != 2) {
                Debug.echoError("Invalid input! Must be in the form PROPERTY,VALUE");
            } else {
                try {
                    this.getPlayerEntity().setWindowProperty(InventoryView.Property.valueOf((String)split[0].toUpperCase()), Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    Debug.echoError("Input value must be a number!");
                }
                catch (IllegalArgumentException e) {
                    Debug.echoError("Must specify a valid window property!");
                }
            }
        }
        if (mechanism.matches("item_on_cursor") && mechanism.requireObject(ItemTag.class)) {
            this.getPlayerEntity().setItemOnCursor(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
        if (mechanism.matches("award_advancement")) {
            Advancement adv = AdvancementHelper.getAdvancement(mechanism.getValue().asString());
            if (adv == null) {
                if (mechanism.shouldDebug()) {
                    Debug.echoError("Advancement '" + mechanism.getValue().asString() + "' does not exist.");
                }
                return;
            }
            AdvancementProgress prog = this.getPlayerEntity().getAdvancementProgress(adv);
            for (String criteria : prog.getRemainingCriteria()) {
                prog.awardCriteria(criteria);
            }
        }
        if (mechanism.matches("absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getPlayerHelper().setAbsorption(this.getPlayerEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fake_absorption_health") && mechanism.requireFloat()) {
            NMSHandler.getPacketHelper().setFakeAbsorption(this.getPlayerEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("health_scale") && mechanism.requireDouble()) {
            this.getPlayerEntity().setHealthScale(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("scale_health") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setHealthScaled(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("max_health") && mechanism.requireDouble()) {
            this.setMaxHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("health") && mechanism.requireDouble()) {
            this.setHealth(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("redo_attack_cooldown")) {
            NMSHandler.getPlayerHelper().setAttackCooldown(this.getPlayerEntity(), 0);
        }
        if (mechanism.matches("reset_attack_cooldown")) {
            PlayerHelper playerHelper = NMSHandler.getPlayerHelper();
            playerHelper.setAttackCooldown(this.getPlayerEntity(), Math.round(playerHelper.getMaxAttackCooldownTicks(this.getPlayerEntity())));
        }
        if (mechanism.matches("attack_cooldown_percent") && mechanism.requireFloat()) {
            float percent = mechanism.getValue().asFloat();
            System.out.println(percent + " >> " + (percent >= 0.0f && percent <= 1.0f));
            if (percent >= 0.0f && percent <= 1.0f) {
                PlayerHelper playerHelper = NMSHandler.getPlayerHelper();
                playerHelper.setAttackCooldown(this.getPlayerEntity(), Math.round(playerHelper.getMaxAttackCooldownTicks(this.getPlayerEntity()) * mechanism.getValue().asFloat()));
            } else {
                Debug.echoError("Invalid percentage! \"" + percent + "\" is not between 0 and 1!");
            }
        }
        if (mechanism.matches("attack_cooldown") && mechanism.requireObject(DurationTag.class)) {
            NMSHandler.getPlayerHelper().setAttackCooldown(this.getPlayerEntity(), mechanism.getValue().asType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("resource_pack") || mechanism.matches("texture_pack")) {
            this.getPlayerEntity().setResourcePack(mechanism.getValue().asString());
        }
        if (mechanism.matches("saturation") && mechanism.requireFloat()) {
            this.getPlayerEntity().setSaturation(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("send_map") && mechanism.requireInteger()) {
            MapView map = Bukkit.getServer().getMap((int)((short)mechanism.getValue().asInt()));
            if (map != null) {
                this.getPlayerEntity().sendMap(map);
            } else {
                Debug.echoError("No map found for ID " + mechanism.getValue().asInt() + "!");
            }
        }
        if (mechanism.matches("food_level") && mechanism.requireInteger()) {
            this.setFoodLevel(mechanism.getValue().asInt());
        }
        if (mechanism.matches("bed_spawn_location") && mechanism.requireObject(LocationTag.class)) {
            this.setBedSpawnLocation(mechanism.valueAsType(LocationTag.class));
        }
        if (mechanism.matches("can_fly") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setAllowFlight(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fly_speed") && mechanism.requireFloat()) {
            this.setFlySpeed(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("flying") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setFlying(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sprinting") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setSprinting(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("gamemode") && mechanism.requireEnum(false, (Enum<?>[])GameMode.values())) {
            this.setGameMode(GameMode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("kick")) {
            this.getPlayerEntity().kickPlayer(mechanism.getValue().asString());
        }
        if (mechanism.matches("weather") && mechanism.requireEnum(false, (Enum<?>[])WeatherType.values())) {
            this.getPlayerEntity().setPlayerWeather(WeatherType.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("reset_weather")) {
            this.getPlayerEntity().resetPlayerWeather();
        }
        if (mechanism.matches("player_list_name")) {
            this.getPlayerEntity().setPlayerListName(mechanism.getValue().asString());
        }
        if (mechanism.matches("display_name")) {
            this.getPlayerEntity().setDisplayName(mechanism.getValue().asString());
            return;
        }
        if (mechanism.matches("show_workbench") && mechanism.requireObject(LocationTag.class)) {
            this.getPlayerEntity().openWorkbench((Location)mechanism.valueAsType(LocationTag.class), true);
            return;
        }
        if (mechanism.matches("location") && mechanism.requireObject(LocationTag.class)) {
            this.setLocation(mechanism.valueAsType(LocationTag.class));
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), true);
        }
        if (mechanism.matches("freeze_time")) {
            if (mechanism.requireInteger("Invalid integer specified. Assuming current world time.")) {
                this.getPlayerEntity().setPlayerTime((long)mechanism.getValue().asInt(), false);
            } else {
                this.getPlayerEntity().setPlayerTime(this.getPlayerEntity().getWorld().getTime(), false);
            }
        }
        if (mechanism.matches("reset_time")) {
            this.getPlayerEntity().resetPlayerTime();
        }
        if (mechanism.matches("walk_speed") && mechanism.requireFloat()) {
            this.getPlayerEntity().setWalkSpeed(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("exhaustion") && mechanism.requireFloat()) {
            this.getPlayerEntity().setExhaustion(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("show_entity") && mechanism.requireObject(EntityTag.class)) {
            NMSHandler.getEntityHelper().unhideEntity(this.getPlayerEntity(), mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("hide_entity")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 2);
                if (split.length > 0 && new ElementTag(split[0]).matchesType(EntityTag.class)) {
                    EntityTag entity = mechanism.valueAsType(EntityTag.class);
                    if (!entity.isSpawnedOrValidForTag()) {
                        Debug.echoError("Can't hide the unspawned entity '" + split[0] + "'!");
                    } else if (split.length > 1 && new ElementTag(split[1]).isBoolean()) {
                        NMSHandler.getEntityHelper().hideEntity(this.getPlayerEntity(), entity.getBukkitEntity(), new ElementTag(split[1]).asBoolean());
                    } else {
                        NMSHandler.getEntityHelper().hideEntity(this.getPlayerEntity(), entity.getBukkitEntity(), false);
                    }
                } else {
                    Debug.echoError("'" + split[0] + "' is not a valid entity!");
                }
            } else {
                Debug.echoError("Must specify an entity to hide!");
            }
        }
        if (mechanism.matches("show_boss_bar")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 2);
                if (split.length == 2 && new ElementTag(split[0]).isDouble()) {
                    BossBarHelper.showSimpleBossBar(this.getPlayerEntity(), split[1], new ElementTag(split[0]).asDouble() * 0.005);
                } else {
                    BossBarHelper.showSimpleBossBar(this.getPlayerEntity(), split[0], 1.0);
                }
            } else {
                BossBarHelper.removeSimpleBossBar(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_experience")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 2);
                if (split.length > 0 && new ElementTag(split[0]).isFloat()) {
                    if (split.length > 1 && new ElementTag(split[1]).isInt()) {
                        NMSHandler.getPacketHelper().showExperience(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt());
                    } else {
                        NMSHandler.getPacketHelper().showExperience(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), this.getPlayerEntity().getLevel());
                    }
                } else {
                    Debug.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.getPacketHelper().resetExperience(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_health")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 3);
                if (split.length > 0 && new ElementTag(split[0]).isFloat()) {
                    if (split.length > 1 && new ElementTag(split[1]).isInt()) {
                        if (split.length > 2 && new ElementTag(split[2]).isFloat()) {
                            NMSHandler.getPacketHelper().showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt(), new ElementTag(split[2]).asFloat());
                        } else {
                            NMSHandler.getPacketHelper().showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), new ElementTag(split[1]).asInt(), this.getPlayerEntity().getSaturation());
                        }
                    } else {
                        NMSHandler.getPacketHelper().showHealth(this.getPlayerEntity(), new ElementTag(split[0]).asFloat(), this.getPlayerEntity().getFoodLevel(), this.getPlayerEntity().getSaturation());
                    }
                } else {
                    Debug.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                NMSHandler.getPacketHelper().resetHealth(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_equipment") && !mechanism.getValue().asString().isEmpty()) {
            String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 3);
            if (split.length > 0 && new ElementTag(split[0]).matchesType(EntityTag.class)) {
                Object slot;
                Object object = slot = split.length > 1 ? split[1].toUpperCase() : null;
                if (split.length > 1 && (new ElementTag((String)slot).matchesEnum((Enum[])EquipmentSlot.values()) || ((String)slot).equals("MAIN_HAND") || ((String)slot).equals("BOOTS"))) {
                    if (split.length > 2 && new ElementTag(split[2]).matchesType(ItemTag.class)) {
                        if (((String)slot).equals("MAIN_HAND")) {
                            slot = "HAND";
                        } else if (((String)slot).equals("BOOTS")) {
                            slot = "FEET";
                        }
                        NMSHandler.getPacketHelper().showEquipment(this.getPlayerEntity(), new ElementTag(split[0]).asType(EntityTag.class, mechanism.context).getLivingEntity(), EquipmentSlot.valueOf((String)slot), new ElementTag(split[2]).asType(ItemTag.class, mechanism.context).getItemStack());
                    } else if (split.length > 2) {
                        Debug.echoError("'" + split[2] + "' is not a valid ItemTag!");
                    }
                } else if (split.length > 1) {
                    Debug.echoError("'" + split[1] + "' is not a valid slot; must be HAND, OFF_HAND, BOOTS, LEGS, CHEST, or HEAD!");
                } else {
                    NMSHandler.getPacketHelper().resetEquipment(this.getPlayerEntity(), new ElementTag(split[0]).asType(EntityTag.class, mechanism.context).getLivingEntity());
                }
            } else {
                Debug.echoError("'" + split[0] + "' is not a valid EntityTag!");
            }
        }
        if (mechanism.matches("fov_multiplier")) {
            if (mechanism.hasValue() && mechanism.requireFloat()) {
                NMSHandler.getPacketHelper().setFieldOfView(this.getPlayerEntity(), mechanism.getValue().asFloat());
            } else {
                NMSHandler.getPacketHelper().setFieldOfView(this.getPlayerEntity(), Float.NaN);
            }
        }
        if (mechanism.matches("item_message")) {
            ItemChangeMessage.sendMessage(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("show_endcredits")) {
            NMSHandler.getPlayerHelper().showEndCredits(this.getPlayerEntity());
        }
        if (mechanism.matches("show_demo")) {
            NMSHandler.getPacketHelper().showDemoScreen(this.getPlayerEntity());
        }
        if (mechanism.matches("spectate") && mechanism.requireObject(EntityTag.class)) {
            NMSHandler.getPacketHelper().forceSpectate(this.getPlayerEntity(), mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("open_book")) {
            NMSHandler.getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.HAND);
        }
        if (mechanism.matches("open_offhand_book")) {
            NMSHandler.getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
        }
        if (mechanism.matches("show_book") && mechanism.requireObject(ItemTag.class)) {
            ItemTag book = mechanism.valueAsType(ItemTag.class);
            if (!book.getItemStack().hasItemMeta() || !(book.getItemStack().getItemMeta() instanceof BookMeta)) {
                Debug.echoError("show_book mechanism must have a book as input.");
                return;
            }
            NMSHandler.getPacketHelper().showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, book.getItemStack());
            NMSHandler.getPacketHelper().openBook(this.getPlayerEntity(), EquipmentSlot.OFF_HAND);
            NMSHandler.getPacketHelper().showEquipment(this.getPlayerEntity(), (LivingEntity)this.getPlayerEntity(), EquipmentSlot.OFF_HAND, this.getPlayerEntity().getEquipment().getItemInOffHand());
        }
        if (mechanism.matches("discover_recipe")) {
            ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
            for (String key : mechanism.valueAsType(ListTag.class)) {
                keys.add(Utilities.parseNamespacedKey(key));
            }
            this.getPlayerEntity().discoverRecipes(keys);
        }
        if (mechanism.matches("forget_recipe")) {
            ArrayList<NamespacedKey> keys = new ArrayList<NamespacedKey>();
            for (String key : mechanism.valueAsType(ListTag.class)) {
                keys.add(Utilities.parseNamespacedKey(key));
            }
            this.getPlayerEntity().undiscoverRecipes(keys);
        }
        if (mechanism.matches("edit_sign") && mechanism.requireObject(LocationTag.class) && !NMSHandler.getPacketHelper().showSignEditor(this.getPlayerEntity(), mechanism.valueAsType(LocationTag.class))) {
            Debug.echoError("Can't edit non-sign materials!");
        }
        if (mechanism.matches("tab_list_info")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 2);
                if (split.length > 0) {
                    String header = split[0];
                    String footer = "";
                    if (split.length > 1) {
                        footer = split[1];
                    }
                    NMSHandler.getPacketHelper().showTabListHeaderFooter(this.getPlayerEntity(), header, footer);
                } else {
                    Debug.echoError("Must specify a header and footer to show!");
                }
            } else {
                NMSHandler.getPacketHelper().resetTabListHeaderFooter(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("sign_update")) {
            if (!mechanism.getValue().asString().isEmpty()) {
                String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]", 2);
                if (LocationTag.matches(split[0]) && split.length > 1) {
                    ListTag lines = ListTag.valueOf(split[1]);
                    this.getPlayerEntity().sendSignChange((Location)LocationTag.valueOf(split[0]), lines.toArray(4));
                } else {
                    Debug.echoError("Must specify a valid location and at least one sign line!");
                }
            } else {
                Debug.echoError("Must specify a valid location and at least one sign line!");
            }
        }
        if (mechanism.matches("banner_update") && mechanism.getValue().asString().length() > 0) {
            String[] split = mechanism.getValue().asString().split("[\\|" + ListTag.internal_escape + "]");
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (split.length > 2) {
                for (int i = 2; i < split.length; ++i) {
                    String string = split[i];
                    try {
                        List<String> splitList = CoreUtilities.split(string, '/', 2);
                        patterns.add(new Pattern(DyeColor.valueOf((String)splitList.get(0).toUpperCase()), PatternType.valueOf((String)splitList.get(1).toUpperCase())));
                        continue;
                    }
                    catch (Exception e) {
                        Debug.echoError("Could not apply pattern to banner: " + string);
                    }
                }
            }
            if (LocationTag.matches(split[0]) && split.length > 1) {
                DyeColor base;
                LocationTag location = LocationTag.valueOf(split[0]);
                try {
                    base = DyeColor.valueOf((String)split[1].toUpperCase());
                }
                catch (Exception e) {
                    Debug.echoError("Could not apply base color to banner: " + split[1]);
                    return;
                }
                NMSHandler.getPacketHelper().showBannerUpdate(this.getPlayerEntity(), location, base, patterns);
            } else {
                Debug.echoError("Must specify a valid location and a base color!");
            }
        }
        if (mechanism.matches("stop_sound")) {
            if (!mechanism.hasValue()) {
                this.getPlayerEntity().stopSound("");
            } else {
                try {
                    this.getPlayerEntity().stopSound("", SoundCategory.valueOf((String)mechanism.getValue().asString().toUpperCase()));
                }
                catch (Exception e) {
                    Debug.echoError("Invalid SoundCategory. Must specify a valid name.");
                }
            }
        }
        if (mechanism.matches("action_bar")) {
            NMSHandler.getPacketHelper().sendActionBarMessage(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("update_advancements")) {
            NMSHandler.getAdvancementHelper().update(this.getPlayerEntity());
        }
        if (mechanism.matches("name")) {
            String name = mechanism.getValue().asString();
            if (name.length() > 16) {
                Debug.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.getInstance().getProfileEditor().setPlayerName(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin")) {
            String name = mechanism.getValue().asString();
            if (name.length() > 16) {
                Debug.echoError("Must specify a name with no more than 16 characters.");
            } else {
                NMSHandler.getInstance().getProfileEditor().setPlayerSkin(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        if (mechanism.matches("skin_blob")) {
            NMSHandler.getInstance().getProfileEditor().setPlayerSkinBlob(this.getPlayerEntity(), mechanism.getValue().asString());
        }
        if (mechanism.matches("is_whitelisted") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setWhitelisted(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("is_op") && mechanism.requireBoolean()) {
            this.getOfflinePlayer().setOp(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("money") && mechanism.requireDouble() && Depends.economy != null) {
            double bal = Depends.economy.getBalance(this.getOfflinePlayer());
            double goal = mechanism.getValue().asDouble();
            if (goal > bal) {
                Depends.economy.depositPlayer(this.getOfflinePlayer(), goal - bal);
            } else if (bal > goal) {
                Depends.economy.withdrawPlayer(this.getOfflinePlayer(), bal - goal);
            }
        }
        if (Depends.chat != null) {
            if (mechanism.matches("chat_prefix")) {
                Depends.chat.setPlayerPrefix(this.getPlayerEntity(), mechanism.getValue().asString());
            }
            if (mechanism.matches("chat_suffix")) {
                Depends.chat.setPlayerSuffix(this.getPlayerEntity(), mechanism.getValue().asString());
            }
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
        if (!mechanism.fulfilled() && this.isOnline()) {
            new EntityTag((Entity)this.getPlayerEntity()).adjust(mechanism);
        }
    }
}

