/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.MaterialCompat;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EntityFirework
implements Property {
    public static final String[] handledTags = new String[]{"firework_item"};
    public static final String[] handledMechs = new String[]{"firework_item", "detonate"};
    EntityTag firework;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntityType() == EntityType.FIREWORK;
    }

    public static EntityFirework getFrom(ObjectTag entity) {
        if (!EntityFirework.describes(entity)) {
            return null;
        }
        return new EntityFirework((EntityTag)entity);
    }

    private EntityFirework(EntityTag entity) {
        this.firework = entity;
    }

    @Override
    public String getPropertyString() {
        ItemStack item = new ItemStack(MaterialCompat.FIREWORK_ROCKET);
        item.setItemMeta((ItemMeta)((Firework)this.firework.getBukkitEntity()).getFireworkMeta());
        return new ItemTag(item).identify();
    }

    @Override
    public String getPropertyId() {
        return "firework_item";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("firework_item")) {
            ItemStack item = new ItemStack(MaterialCompat.FIREWORK_ROCKET);
            item.setItemMeta((ItemMeta)((Firework)this.firework.getBukkitEntity()).getFireworkMeta());
            return new ItemTag(item).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("firework_item") && mechanism.requireObject(ItemTag.class)) {
            ItemTag item = mechanism.valueAsType(ItemTag.class);
            if (item != null && item.getItemStack().getItemMeta() instanceof FireworkMeta) {
                ((Firework)this.firework.getBukkitEntity()).setFireworkMeta((FireworkMeta)item.getItemStack().getItemMeta());
            } else {
                Debug.echoError("'" + mechanism.getValue().asString() + "' is not a valid firework item.");
            }
        }
        if (mechanism.matches("detonate")) {
            ((Firework)this.firework.getBukkitEntity()).detonate();
        }
    }
}

