/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;

public class InventoryTitle
implements Property {
    public static final String[] handledTags = new String[]{"title"};
    public static final String[] handledMechs = new String[]{"title"};
    InventoryTag inventory;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag;
    }

    public static InventoryTitle getFrom(ObjectTag inventory) {
        if (!InventoryTitle.describes(inventory)) {
            return null;
        }
        return new InventoryTitle((InventoryTag)inventory);
    }

    public InventoryTitle(InventoryTag inventory) {
        this.inventory = inventory;
    }

    public String getTitle() {
        String title;
        if (this.inventory.getInventory() != null && (title = NMSHandler.getInstance().getTitle(this.inventory.getInventory())) != null) {
            if (this.inventory.isUnique()) {
                return title.substring(0, title.length() - InventoryTag.inventoryNameNotableRequired);
            }
            if (!title.startsWith("container.")) {
                return title;
            }
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.inventory.isUnique() || this.inventory.getIdType().equals("generic") || this.inventory.getIdType().equals("location")) {
            return this.getTitle();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "title";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("title")) {
            return new ElementTag(this.getTitle()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("title") && this.inventory.getIdType().equals("generic")) {
            this.inventory.setTitle(mechanism.getValue().asString());
        }
    }
}

