/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.maps.MapObject;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

public class MapDot
extends MapObject {
    protected String radiusTag;
    protected String colorTag;

    public MapDot(String xTag, String yTag, String visibilityTag, boolean debug, String radiusTag, String colorTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.radiusTag = radiusTag;
        this.colorTag = colorTag;
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "DOT");
        data.put("radius", this.radiusTag);
        data.put("color", this.colorTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        int baseX = this.getX(player, uuid);
        int baseY = this.getY(player, uuid);
        int radius = (int)ArgumentHelper.getDoubleFrom(this.tag(this.radiusTag, player));
        Color color = ColorTag.valueOf(this.tag(this.colorTag, player)).getColor();
        for (int x = -radius; x < radius; ++x) {
            int finalX = baseX + x;
            if (finalX >= 128) continue;
            for (int y = -radius; y < radius; ++y) {
                int finalY = baseY + y;
                if (finalY >= 128 || !(((double)x + 0.5) * ((double)x + 0.5) + ((double)y + 0.5) * ((double)y + 0.5) <= (double)(radius * radius))) continue;
                mapCanvas.setPixel(finalX, finalY, MapPalette.matchColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            }
        }
    }
}

