/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class ArgumentHelper {
    public static final Pattern floatPrimitive;
    public static final Pattern doublePrimitive;
    public static final Pattern percentagePrimitive;
    public static final Pattern integerPrimitive;
    public static final Pattern booleanPrimitive;
    public static final Pattern wordPrimitive;
    public static List<String> specialInterpretTrickStrings;
    public static List<Argument> specialInterpretTrickObjects;

    public static List<Argument> interpretObjects(List<ObjectTag> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (ObjectTag obj : args) {
            arg_list.add(new Argument(obj));
        }
        return arg_list;
    }

    public static List<Argument> interpretArguments(List<Argument> args) {
        for (Argument arg : args) {
            if (!arg.needsFill && !arg.hasSpecialPrefix) continue;
            if (arg.object instanceof ElementTag && arg.prefix == null) {
                arg.fillStr(arg.object.toString());
                continue;
            }
            arg.value = arg.object.toString();
            arg.lower_value = CoreUtilities.toLowerCase(arg.value);
            arg.raw_value = arg.generateRaw();
        }
        return args;
    }

    public static List<Argument> interpret(List<String> args) {
        if (args == specialInterpretTrickStrings) {
            return ArgumentHelper.interpretArguments(specialInterpretTrickObjects);
        }
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (String string : args) {
            arg_list.add(new Argument(string));
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        stringArgs = stringArgs.trim();
        stringArgs = stringArgs.replace('\r', ' ').replace('\n', ' ');
        ArrayList<String> matchList = new ArrayList<String>();
        int start = 0;
        int len = stringArgs.length();
        char currentQuote = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = stringArgs.charAt(i);
            if (c == ' ' && currentQuote == '\u0000') {
                if (i > start) {
                    matchList.add(stringArgs.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (c != '\"' && c != '\'') continue;
            if (currentQuote == '\u0000') {
                if (i - 1 >= 0 && stringArgs.charAt(i - 1) != ' ') continue;
                currentQuote = c;
                start = i + 1;
                continue;
            }
            if (currentQuote != c || i + 1 < len && stringArgs.charAt(i + 1) != ' ') continue;
            currentQuote = '\u0000';
            if (i >= start) {
                matchList.add(stringArgs.substring(start, i));
            }
            start = ++i + 1;
        }
        if (start < len) {
            matchList.add(stringArgs.substring(start));
        }
        if (Debug.showScriptBuilder) {
            Debug.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + (value != null ? (value instanceof ObjectTag ? ((ObjectTag)value).debuggable() : value.toString()) : "null") + "<G>'  ";
    }

    public static <T extends ObjectTag> String debugList(String prefix, Collection<T> objects) {
        if (objects == null) {
            return ArgumentHelper.debugObj(prefix, null);
        }
        StringBuilder sb = new StringBuilder();
        for (ObjectTag obj : objects) {
            sb.append(obj.debuggable()).append("<G>, ");
        }
        if (sb.length() == 0) {
            return ArgumentHelper.debugObj(prefix, sb);
        }
        return ArgumentHelper.debugObj(prefix, "[" + sb.substring(0, sb.length() - "<G>, ".length()) + "<Y>]");
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + (value != null ? value.toString() : "null") + ")<G>'  ";
    }

    public static boolean getBooleanFrom(String arg) {
        return Boolean.valueOf(ArgumentHelper.getStringFrom(arg));
    }

    public static double getDoubleFrom(String arg) {
        try {
            return Double.valueOf(ArgumentHelper.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static float getFloatFrom(String arg) {
        try {
            return Float.valueOf(ArgumentHelper.getStringFrom(arg)).floatValue();
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            return Double.valueOf(ArgumentHelper.getStringFrom(arg)).intValue();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long getLongFrom(String arg) {
        try {
            return Long.valueOf(arg);
        }
        catch (NumberFormatException ex) {
            try {
                return Double.valueOf(ArgumentHelper.getStringFrom(arg)).longValue();
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
    }

    public static String getStringFrom(String arg) {
        String[] parts = arg.split(":", 2);
        return parts.length >= 2 ? parts[1] : arg;
    }

    public static boolean matchesDouble(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    public static boolean matchesInteger(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    static {
        doublePrimitive = floatPrimitive = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
        percentagePrimitive = Pattern.compile("-?(?:\\d+)?(\\.\\d+)?(%)?");
        integerPrimitive = Pattern.compile("(-)?[0-9]+");
        booleanPrimitive = Pattern.compile("true|false", 2);
        wordPrimitive = Pattern.compile("\\w+");
        specialInterpretTrickStrings = null;
        specialInterpretTrickObjects = null;
    }

    public static enum PrimitiveType {
        Float,
        Double,
        Integer,
        Boolean,
        String,
        Word,
        Percentage;

    }
}

