/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.TagRunnable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DurationTag
implements ObjectTag {
    public static final DurationTag ZERO = new DurationTag(0);
    private double seconds;
    private String prefix = "Duration";
    public static ObjectTagProcessor tagProcessor = new ObjectTagProcessor();

    public static DurationTag valueOf(String string) {
        return DurationTag.valueOf(string, null);
    }

    @Fetchable(value="d")
    public static DurationTag valueOf(String string, TagContext context) {
        String[] split;
        if (string == null) {
            return null;
        }
        if ((string = CoreUtilities.toLowerCase(string.replace("d@", ""))).equals("instant")) {
            return new DurationTag(0);
        }
        if (string.contains("-") && !string.contains("e-") && (split = string.split("-", 2)).length == 2) {
            DurationTag low = DurationTag.valueOf(split[0]);
            DurationTag high = DurationTag.valueOf(split[1]);
            if (low != null && high != null) {
                if (high.getSecondsAsInt() < low.getSecondsAsInt()) {
                    DurationTag temp = low;
                    low = high;
                    high = temp;
                }
                int seconds = CoreUtilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1) + low.getSecondsAsInt();
                if (Debug.verbose) {
                    Debug.log("Getting random duration between " + low.identify() + " and " + high.identify() + "... " + seconds + "s");
                }
                return new DurationTag(seconds);
            }
            return null;
        }
        String numericString = Character.isDigit(string.charAt(string.length() - 1)) ? string : string.substring(0, string.length() - 1);
        try {
            if (string.endsWith("t")) {
                return new DurationTag(Double.valueOf(numericString) * 0.05);
            }
            if (string.endsWith("d")) {
                return new DurationTag(Double.valueOf(numericString) * 86400.0);
            }
            if (string.endsWith("w")) {
                return new DurationTag(Double.valueOf(numericString) * 604800.0);
            }
            if (string.endsWith("m")) {
                return new DurationTag(Double.valueOf(numericString) * 60.0);
            }
            if (string.endsWith("h")) {
                return new DurationTag(Double.valueOf(numericString) * 3600.0);
            }
            if (string.endsWith("s")) {
                return new DurationTag(Double.valueOf(numericString));
            }
            if (numericString.equals(string)) {
                return new DurationTag(Double.valueOf(numericString));
            }
            if (context == null || context.debug) {
                Debug.echoError("Duration type '" + string + "' is not valid.");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        try {
            return DurationTag.valueOf(string, CoreUtilities.noDebugContext) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public DurationTag(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public DurationTag(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public DurationTag(long ticks) {
        this.seconds = (double)ticks / 20.0;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return (int)(this.seconds * 20.0);
    }

    public long getMillis() {
        Double millis = this.seconds * 1000.0;
        return millis.longValue();
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        return "d@" + this.seconds + "s <GR>(" + this.formatted() + ")";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "duration";
    }

    @Override
    public String identify() {
        return "d@" + this.seconds + "s";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void registerTags() {
        DurationTag.registerTag("in_years", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds / 3.1536E7).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("years", DurationTag.tagProcessor.registeredObjectTags.get("in_years"));
        DurationTag.registerTag("in_weeks", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds / 604800.0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("weeks", DurationTag.tagProcessor.registeredObjectTags.get("in_weeks"));
        DurationTag.registerTag("in_days", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds / 86400.0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("days", DurationTag.tagProcessor.registeredObjectTags.get("in_days"));
        DurationTag.registerTag("in_hours", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds / 3600.0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("hours", DurationTag.tagProcessor.registeredObjectTags.get("in_hours"));
        DurationTag.registerTag("in_minutes", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds / 60.0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("minutes", DurationTag.tagProcessor.registeredObjectTags.get("in_minutes"));
        DurationTag.registerTag("in_seconds", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("seconds", DurationTag.tagProcessor.registeredObjectTags.get("in_seconds"));
        DurationTag.registerTag("in_milliseconds", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).seconds * 1000.0).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("milliseconds", DurationTag.tagProcessor.registeredObjectTags.get("in_milliseconds"));
        DurationTag.registerTag("in_ticks", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag((long)(((DurationTag)object).seconds * 20.0)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("ticks", DurationTag.tagProcessor.registeredObjectTags.get("in_ticks"));
        DurationTag.registerTag("sub", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag DurationTag.sub[...] must have a value.");
                    return null;
                }
                return new DurationTag(((DurationTag)object).getTicks() - DurationTag.valueOf(attribute.getContext(1)).getTicks()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("add", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                if (!attribute.hasContext(1)) {
                    Debug.echoError("The tag DurationTag.add[...] must have a value.");
                    return null;
                }
                return new DurationTag(((DurationTag)object).getTicks() + DurationTag.valueOf(attribute.getContext(1)).getTicks()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("time", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                Date currentDate = new Date(((DurationTag)object).getTicks() * 50L);
                SimpleDateFormat format = new SimpleDateFormat();
                if ((attribute = attribute.fulfill(1)).startsWith("year")) {
                    return new ElementTag(currentDate.getYear() + 1900).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("month")) {
                    return new ElementTag(currentDate.getMonth() + 1).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("day")) {
                    return new ElementTag(currentDate.getDate()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("day_of_week")) {
                    return new ElementTag(currentDate.getDay()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("hour")) {
                    return new ElementTag(currentDate.getHours()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("minute")) {
                    return new ElementTag(currentDate.getMinutes()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("second")) {
                    return new ElementTag(currentDate.getSeconds()).getObjectAttribute(attribute.fulfill(1));
                }
                format.applyPattern("EEE, d MMM yyyy HH:mm:ss");
                return new ElementTag(format.format(currentDate)).getObjectAttribute(attribute);
            }
        });
        DurationTag.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag("Duration").getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("formatted", new TagRunnable.ObjectForm(){

            @Override
            public ObjectTag run(Attribute attribute, ObjectTag object) {
                return new ElementTag(((DurationTag)object).formatted()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        DurationTag.registerTag("value", DurationTag.tagProcessor.registeredObjectTags.get("formatted"));
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        tagProcessor.registerTag(name, runnable);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public String formatted() {
        long seconds = (long)this.seconds;
        long days = seconds / 86400L;
        long hours = (seconds - days * 86400L) / 3600L;
        long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
        seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
        String timeString = "";
        if (days > 0L) {
            timeString = String.valueOf(days) + "d ";
        }
        if (hours > 0L) {
            timeString = timeString + String.valueOf(hours) + "h ";
        }
        if (minutes > 0L && days == 0L) {
            timeString = timeString + String.valueOf(minutes) + "m ";
        }
        if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
            timeString = timeString + String.valueOf(seconds) + "s";
        }
        if (timeString.isEmpty()) {
            timeString = this.seconds <= 0.0 ? "forever" : (double)((long)(this.seconds * 100.0)) / 100.0 + "s";
        }
        return timeString.trim();
    }
}

