/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;

public class EntityCombustsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityCombustsScriptEvent instance;
    public EntityTag entity;
    private int burntime;
    public EntityCombustEvent event;

    public EntityCombustsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("combusts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityCombusts";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag && ((ElementTag)determinationObj).isInt()) {
            this.burntime = ((ElementTag)determinationObj).asInt();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("duration")) {
            return new DurationTag(this.burntime);
        }
        if (name.equals("source")) {
            Block combuster;
            if (this.event instanceof EntityCombustByEntityEvent) {
                return new EntityTag(((EntityCombustByEntityEvent)this.event).getCombuster());
            }
            if (this.event instanceof EntityCombustByBlockEvent && (combuster = ((EntityCombustByBlockEvent)this.event).getCombuster()) != null) {
                return new LocationTag(combuster.getLocation());
            }
        } else if (name.equals("source_type")) {
            if (this.event instanceof EntityCombustByEntityEvent) {
                return new ElementTag("ENTITY");
            }
            if (this.event instanceof EntityCombustByBlockEvent) {
                return new ElementTag("LOCATION");
            }
            return new ElementTag("NONE");
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityCombusts(EntityCombustEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.burntime = event.getDuration();
        this.event = event;
        this.fire((Event)event);
        event.setDuration(this.burntime);
    }
}

