/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerClicksBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerClicksBlockScriptEvent instance = this;
    PlayerInteractEvent event;
    ItemTag item;
    LocationTag location;
    ElementTag click_type;
    ElementTag hand;
    MaterialTag blockMaterial;
    private static final HashSet<String> matchHelpList = new HashSet<String>(Arrays.asList("at", "entity", "npc", "player", "vehicle", "projectile", "hanging"));
    private static final HashSet<String> withHelpList = new HashSet<String>(Arrays.asList("with", "using", "in"));
    public boolean wasCancellationAltered;

    private boolean couldMatchIn(String lower) {
        String next;
        int index = CoreUtilities.split(lower, ' ').indexOf("in");
        if (index == -1) {
            return true;
        }
        String in = CoreUtilities.getXthArg(index + 1, lower);
        if (InventoryTag.matches(in) || in.equalsIgnoreCase("inventory") || PlayerClicksBlockScriptEvent.isRegexMatchable(in)) {
            return false;
        }
        return !in.equalsIgnoreCase("notable") || (next = CoreUtilities.getXthArg(index + 2, lower)).equalsIgnoreCase("cuboid") || next.equalsIgnoreCase("ellipsoid");
    }

    private boolean runUsingCheck(ScriptEvent.ScriptPath path) {
        int index;
        for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("using"); ++index) {
        }
        String using = index >= path.eventArgsLower.length ? "hand" : path.eventArgLowerAt(index + 1);
        if (!(using.equals("hand") || using.equals("off_hand") || using.equals("either_hand"))) {
            Debug.echoError("Invalid USING hand in " + this.getName() + " for '" + path.event + "' in " + path.container.getName());
            return false;
        }
        return using.equals("either_hand") || using.equalsIgnoreCase(this.hand.identify());
    }

    public boolean nonSwitchWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        int index;
        for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("with"); ++index) {
        }
        if (index >= path.eventArgsLower.length) {
            return true;
        }
        String with = path.eventArgLowerAt(index + 1);
        return with == null || this.tryItem(held, with);
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return (path.eventLower.startsWith("player clicks") || path.eventLower.startsWith("player left clicks") || path.eventLower.startsWith("player right clicks") && !matchHelpList.contains(path.eventArgLowerAt(3)) && !EntityTag.matches(path.eventArgLowerAt(3))) && this.couldMatchIn(path.eventLower);
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int index;
        int n = index = path.eventArgLowerAt(1).equals("clicks") ? 1 : 2;
        if (index == 2 && !this.click_type.identify().startsWith(path.eventArgLowerAt(1).toUpperCase())) {
            return false;
        }
        String mat = path.eventArgLowerAt(index + 1);
        if (mat.length() > 0 && !withHelpList.contains(mat) && !this.tryMaterial(this.blockMaterial, mat)) {
            return false;
        }
        if (!this.nonSwitchWithCheck(path, new ItemTag(this.event.getItem()))) {
            return false;
        }
        if (!this.runUsingCheck(path)) {
            return false;
        }
        if (this.location != null ? !this.runInCheck(path, this.location) : !this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "PlayerClicksBlock";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        this.wasCancellationAltered = true;
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.getPlayerFrom((Entity)this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("click_type")) {
            return this.click_type;
        }
        if (name.equals("hand")) {
            return this.hand;
        }
        if (name.equals("relative")) {
            return this.event.hasBlock() ? new LocationTag(this.event.getClickedBlock().getRelative(this.event.getBlockFace()).getLocation()) : null;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerClicksBlock(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.blockMaterial = event.hasBlock() ? new MaterialTag(event.getClickedBlock()) : new MaterialTag(Material.AIR);
        this.hand = new ElementTag(event.getHand().name());
        this.item = new ItemTag(event.getItem());
        this.location = event.hasBlock() ? new LocationTag(event.getClickedBlock().getLocation()) : null;
        this.click_type = new ElementTag(event.getAction().name());
        this.cancelled = event.isCancelled() && event.useItemInHand() == Event.Result.DENY;
        this.event = event;
        this.wasCancellationAltered = false;
        this.fire();
        if (this.wasCancellationAltered) {
            event.setCancelled(this.cancelled);
        }
    }
}

