/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class ItemScriptHelper
implements Listener {
    public static final Map<String, ItemScriptContainer> item_scripts = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> item_scripts_by_hash_id = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> recipeIdToItemScript = new HashMap<String, ItemScriptContainer>();
    public static String ItemScriptHashID = ChatColor.RED.toString() + ChatColor.BLUE + ChatColor.BLACK;
    public static Map<ItemScriptContainer, List<ItemTag>> specialrecipesMap = new HashMap<ItemScriptContainer, List<ItemTag>>();
    public static Map<ItemScriptContainer, List<ItemTag>> shapelessRecipesMap = new HashMap<ItemScriptContainer, List<ItemTag>>();
    public Map<ItemScriptContainer, ItemTag> currentFurnaceRecipes = new HashMap<ItemScriptContainer, ItemTag>();

    public ItemScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static void removeDenizenRecipes() {
        recipeIdToItemScript.clear();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            NMSHandler.getItemHelper().clearDenizenRecipes();
        } else {
            specialrecipesMap.clear();
            shapelessRecipesMap.clear();
        }
    }

    public String getIdFor(ItemScriptContainer container, String type, int id) {
        String basicId = type + "_" + Utilities.cleanseNamespaceID(container.getName()) + "_" + id;
        if (!recipeIdToItemScript.containsKey(basicId)) {
            recipeIdToItemScript.put("denizen:" + basicId, container);
            return basicId;
        }
        int newNumber = 1;
        String newId = basicId + "_1";
        while (recipeIdToItemScript.containsKey(newId)) {
            newId = basicId + "_" + newNumber++;
        }
        recipeIdToItemScript.put("denizen:" + newId, container);
        return newId;
    }

    public void registerShapedRecipe(ItemScriptContainer container, ItemStack item, List<String> recipeList, String internalId, String group) {
        for (int n = 0; n < recipeList.size(); ++n) {
            recipeList.set(n, TagManager.tag(ScriptBuilder.stripLinePrefix(recipeList.get(n)), new BukkitTagContext(null, null, new ScriptTag(container))));
        }
        ArrayList<ItemTag> ingredients = new ArrayList<ItemTag>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        int width = 1;
        for (String recipeRow : recipeList) {
            String[] elements = recipeRow.split("\\|", 3);
            if (width < 3 && elements.length == 3) {
                width = 3;
            }
            if (width < 2 && elements.length >= 2) {
                width = 2;
            }
            for (String element : elements) {
                String itemText = element.replaceAll("[iImM]@", "");
                if (itemText.startsWith("material:")) {
                    exacts.add(false);
                    itemText = itemText.substring("material:".length());
                } else {
                    exacts.add(true);
                }
                ItemTag ingredient = ItemTag.valueOf(itemText, container);
                if (ingredient == null) {
                    Debug.echoError("Invalid ItemTag ingredient, recipe will not be registered for item script '" + container.getName() + "': " + element);
                    return;
                }
                ingredients.add(ingredient);
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            NamespacedKey key = new NamespacedKey("denizen", internalId);
            ShapedRecipe recipe = new ShapedRecipe(key, item);
            recipe.setGroup(group);
            String shape1 = "ABC".substring(0, width);
            String shape2 = "DEF".substring(0, width);
            String shape3 = "GHI".substring(0, width);
            String itemChars = shape1 + shape2 + shape3;
            recipe = recipeList.size() == 3 ? recipe.shape(new String[]{shape1, shape2, shape3}) : (recipeList.size() == 2 ? recipe.shape(new String[]{shape1, shape2}) : recipe.shape(new String[]{shape1}));
            for (int i = 0; i < ingredients.size(); ++i) {
                NMSHandler.getItemHelper().setShapedRecipeIngredient(recipe, itemChars.charAt(i), ((ItemTag)ingredients.get(i)).getItemStack().clone(), (Boolean)exacts.get(i));
            }
            Bukkit.addRecipe((Recipe)recipe);
        } else {
            specialrecipesMap.put(container, ingredients);
        }
    }

    public void registerShapelessRecipe(ItemScriptContainer container, ItemStack item, String shapelessString, String internalId, String group) {
        String list = TagManager.tag(shapelessString, new BukkitTagContext(null, null, new ScriptTag(container)));
        ArrayList<ItemTag> ingredients = new ArrayList<ItemTag>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        for (String element : ListTag.valueOf(list)) {
            String itemText = element.replaceAll("[iImM]@", "");
            if (itemText.startsWith("material:")) {
                exacts.add(false);
                itemText = itemText.substring("material:".length());
            } else {
                exacts.add(true);
            }
            ItemTag ingredient = ItemTag.valueOf(itemText, container);
            if (ingredient == null) {
                Debug.echoError("Invalid ItemTag ingredient, shapeless recipe will not be registered for item script '" + container.getName() + "': " + element);
                return;
            }
            ingredients.add(ingredient);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            ItemStack[] input = new ItemStack[ingredients.size()];
            for (int i = 0; i < input.length; ++i) {
                input[i] = ((ItemTag)ingredients.get(i)).getItemStack().clone();
            }
            boolean[] bools = new boolean[exacts.size()];
            for (int i = 0; i < exacts.size(); ++i) {
                bools[i] = (Boolean)exacts.get(i);
            }
            NMSHandler.getItemHelper().registerShapelessRecipe(internalId, group, item, input, bools);
        } else {
            shapelessRecipesMap.put(container, ingredients);
        }
    }

    public void registerFurnaceRecipe(ItemScriptContainer container, ItemStack item, String furnaceItemString, float exp, int time, String type, String internalId, String group) {
        ItemTag furnace_item;
        boolean exact = true;
        if (furnaceItemString.startsWith("material:")) {
            exact = false;
            furnaceItemString = furnaceItemString.substring("material:".length());
        }
        if ((furnace_item = ItemTag.valueOf(furnaceItemString, container)) == null) {
            Debug.echoError("Invalid item '" + furnaceItemString + "', furnace recipe will not be registered for item script '" + container.getName() + "'.");
            return;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13)) {
            ItemStack input = furnace_item.getItemStack().clone();
            NMSHandler.getItemHelper().registerFurnaceRecipe(internalId, group, item, input, exp, time, type, exact);
        } else {
            FurnaceRecipe recipe = new FurnaceRecipe(item, furnace_item.getMaterial().getMaterial(), (int)furnace_item.getItemStack().getDurability());
            Bukkit.addRecipe((Recipe)recipe);
            this.currentFurnaceRecipes.put(container, furnace_item);
        }
    }

    public void registerStonecuttingRecipe(ItemScriptContainer container, ItemStack item, String inputItemString, String internalId, String group) {
        ItemTag stonecutting_item;
        if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14)) {
            return;
        }
        boolean exact = true;
        if (inputItemString.startsWith("material:")) {
            exact = false;
            inputItemString = inputItemString.substring("material:".length());
        }
        if ((stonecutting_item = ItemTag.valueOf(inputItemString, container)) == null) {
            Debug.echoError("Invalid item '" + inputItemString + "', stonecutting recipe will not be registered for item script '" + container.getName() + "'.");
            return;
        }
        ItemStack input = stonecutting_item.getItemStack().clone();
        NMSHandler.getItemHelper().registerStonecuttingRecipe(internalId, group, item, input, exact);
    }

    public void rebuildRecipes() {
        this.currentFurnaceRecipes.clear();
        for (ItemScriptContainer container : item_scripts.values()) {
            try {
                if (container.contains("recipes")) {
                    YamlConfiguration section = container.getConfigurationSection("recipes");
                    int id = 0;
                    for (StringHolder key : section.getKeys(false)) {
                        YamlConfiguration subSection = section.getConfigurationSection(key.str);
                        String type = CoreUtilities.toLowerCase(subSection.getString("type"));
                        String internalId = subSection.contains("recipe_id") ? subSection.getString("recipe_id") : this.getIdFor(container, type + "_recipe", ++id);
                        String group = subSection.contains("group") ? subSection.getString("group") : "";
                        ItemStack item = container.getCleanReference().getItemStack().clone();
                        if (subSection.contains("output_quantity")) {
                            item.setAmount(Integer.parseInt(subSection.getString("output_quantity")));
                        }
                        if (type.equals("shaped")) {
                            this.registerShapedRecipe(container, item, subSection.getStringList("input"), internalId, group);
                            continue;
                        }
                        if (type.equals("shapeless")) {
                            this.registerShapelessRecipe(container, item, subSection.getString("input"), internalId, group);
                            continue;
                        }
                        if (type.equals("stonecutting")) {
                            this.registerStonecuttingRecipe(container, item, subSection.getString("input"), internalId, group);
                            continue;
                        }
                        if (!type.equals("furnace") && !type.equals("blast") && !type.equals("smoker") && !type.equals("campfire")) continue;
                        float exp = 0.0f;
                        int cookTime = 40;
                        if (subSection.contains("experience")) {
                            exp = Float.parseFloat(subSection.getString("experience"));
                        }
                        if (subSection.contains("cook_time")) {
                            cookTime = DurationTag.valueOf(subSection.getString("cook_time")).getTicksAsInt();
                        }
                        this.registerFurnaceRecipe(container, item, subSection.getString("input"), exp, cookTime, type, internalId, group);
                    }
                }
                if (container.contains("RECIPE")) {
                    Deprecations.oldRecipeScript.warn(container);
                    this.registerShapedRecipe(container, container.getCleanReference().getItemStack().clone(), container.getStringList("RECIPE"), this.getIdFor(container, "old_recipe", 0), "custom");
                }
                if (container.contains("SHAPELESS_RECIPE")) {
                    Deprecations.oldRecipeScript.warn(container);
                    this.registerShapelessRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("SHAPELESS_RECIPE"), this.getIdFor(container, "old_shapeless", 0), "custom");
                }
                if (!container.contains("FURNACE_RECIPE")) continue;
                Deprecations.oldRecipeScript.warn(container);
                this.registerFurnaceRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("FURNACE_RECIPE"), 0.0f, 40, "furnace", this.getIdFor(container, "old_furnace", 0), "custom");
            }
            catch (Exception ex) {
                Debug.echoError("Error while rebuilding item script recipes for '" + container.getName() + "'...");
                Debug.echoError(ex);
            }
        }
    }

    @EventHandler
    public void scriptReload(ScriptReloadEvent event) {
        this.rebuildRecipes();
    }

    public static boolean isItemscript(ItemStack item) {
        return ItemScriptHelper.getItemScriptContainer(item) != null;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (item == null) {
            return null;
        }
        String nbt = NMSHandler.getItemHelper().getNbtData(item).getString("Denizen Item Script");
        if (nbt != null && !nbt.equals("")) {
            return item_scripts_by_hash_id.get(nbt);
        }
        if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        for (String itemLore : item.getItemMeta().getLore()) {
            if (itemLore.startsWith("\u00a70id:")) {
                return item_scripts.get(itemLore.replace("\u00a70id:", ""));
            }
            if (!itemLore.startsWith(ItemScriptHashID)) continue;
            return item_scripts_by_hash_id.get(itemLore);
        }
        return null;
    }

    public static String createItemScriptID(ItemScriptContainer container) {
        String colors = ItemScriptHelper.createItemScriptID(container.getName());
        container.setHashID(colors);
        return colors;
    }

    public static String createItemScriptID(String name) {
        String script = name.toUpperCase();
        StringBuilder colors = new StringBuilder();
        colors.append(ItemScriptHashID);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = script.getBytes(StandardCharsets.UTF_8);
            md.update(bytes, 0, bytes.length);
            String hash = new BigInteger(1, md.digest()).toString(16);
            for (int i = 0; i < 16; ++i) {
                colors.append('\u00a7').append(hash.charAt(i));
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            colors.append(ChatColor.BLUE);
        }
        return colors.toString();
    }

    @EventHandler
    public void furnaceSmeltHandler(FurnaceSmeltEvent event) {
        if (ItemScriptHelper.isItemscript(event.getResult())) {
            ItemScriptContainer isc = ItemScriptHelper.getItemScriptContainer(event.getResult());
            ItemTag convertResult = this.currentFurnaceRecipes.get(isc);
            if (convertResult == null) {
                return;
            }
            ItemTag itm = new ItemTag(convertResult.getItemStack().clone());
            itm.setAmount(1);
            ItemTag src = new ItemTag(event.getSource().clone());
            src.setAmount(1);
            if (!itm.getFullString().equals(src.getFullString())) {
                List recipes = Bukkit.getServer().getRecipesFor(event.getSource());
                for (Recipe rec : recipes) {
                    if (!(rec instanceof FurnaceRecipe)) continue;
                    event.setResult(rec.getResult());
                    return;
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler
    public void specialRecipeClick(InventoryClickEvent event) {
        if (specialrecipesMap.isEmpty() && shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType.equals((Object)InventoryType.SlotType.CRAFTING) || slotType.equals((Object)InventoryType.SlotType.RESULT)) {
            boolean clicked;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            Map.Entry<ItemScriptContainer, List<ItemTag>> recipeEntry = null;
            if (slotType == InventoryType.SlotType.RESULT && inventory.getResult() != null && inventory.getResult().getData().getItemType() != Material.AIR) {
                if (!(event.isShiftClick() || event.getCursor().getData().getItemType() == Material.AIR || event.getCursor().isSimilar(inventory.getResult()) && event.getCursor().getAmount() + inventory.getResult().getAmount() <= event.getCursor().getMaxStackSize())) {
                    return;
                }
                recipeEntry = this.getSpecialRecipeEntry(inventory.getMatrix());
                if (recipeEntry == null) {
                    return;
                }
            }
            if ((clicked = slotType == InventoryType.SlotType.RESULT && event.isShiftClick() ? this.emulateSpecialRecipeResultShiftClick(inventory, player) : this.processSpecialRecipes(inventory, player)) && slotType.equals((Object)InventoryType.SlotType.RESULT)) {
                this.removeFromEachSlot(inventory, recipeEntry.getValue(), player);
            }
        }
    }

    public void removeFromEachSlot(final CraftingInventory inventory, final List<ItemTag> recipe, final Player player) {
        final ItemStack[] matrix = inventory.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack is = matrix[i];
            matrix[i] = is == null ? new ItemStack(Material.AIR) : is.clone();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < matrix.length; ++i) {
                    if (matrix[i] == null) continue;
                    if (matrix[i].getAmount() == 0) {
                        matrix[i] = null;
                        continue;
                    }
                    matrix[i].setAmount(matrix[i].getAmount() - (recipe != null ? ((ItemTag)recipe.get(i)).getAmount() : 1));
                    if (matrix[i].getAmount() > 0) continue;
                    matrix[i] = null;
                }
                inventory.setMatrix(matrix);
                player.updateInventory();
            }
        }, 0L);
    }

    @EventHandler
    public void specialRecipeDrag(InventoryDragEvent event) {
        if (specialrecipesMap.isEmpty() && shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        for (Integer slot : event.getInventorySlots()) {
            if (slot >= 10) continue;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            this.processSpecialRecipes(inventory, player);
            break;
        }
    }

    public boolean processSpecialRecipes(final CraftingInventory inventory, final Player player) {
        ItemStack[] matrix1 = inventory.getMatrix();
        for (int i = 0; i < matrix1.length; ++i) {
            matrix1[i] = matrix1[i] == null ? new ItemStack(Material.AIR) : matrix1[i].clone();
        }
        ItemTag result1 = this.getSpecialRecipeResult(matrix1, player);
        boolean returnme = result1 != null;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                ItemStack[] matrix = inventory.getMatrix();
                for (int i = 0; i < matrix.length; ++i) {
                    matrix[i] = matrix[i] == null ? new ItemStack(Material.AIR) : matrix[i].clone();
                }
                ItemTag result = ItemScriptHelper.this.getSpecialRecipeResult(matrix, player);
                if (result != null) {
                    ListTag recipeList = new ListTag();
                    for (ItemStack item : matrix) {
                        if (item != null) {
                            recipeList.add(new ItemTag(item).identify());
                            continue;
                        }
                        recipeList.add(new ItemTag(Material.AIR).identify());
                    }
                    inventory.setResult(result.getItemStack());
                    player.updateInventory();
                }
            }
        }, 2L);
        return returnme;
    }

    public Map.Entry<ItemScriptContainer, List<ItemTag>> getSpecialRecipeEntry(ItemStack[] matrix) {
        block0: for (Map.Entry<ItemScriptContainer, List<ItemTag>> entry : specialrecipesMap.entrySet()) {
            for (int n = 0; n < 9; ++n) {
                ItemStack[] matrixN;
                ItemTag valueN = entry.getValue().get(n);
                ItemStack[] itemStackArray = matrixN = matrix.length <= n || matrix[n] == null ? new ItemTag(Material.AIR) : new ItemTag(matrix[n].clone());
                if (valueN.isItemscript() != matrixN.isItemscript() || matrixN.getAmount() < valueN.getAmount() || valueN.isItemscript() && matrixN.isItemscript() && !valueN.getScriptName().equalsIgnoreCase(matrixN.getScriptName()) || !valueN.getMaterial().matchesMaterialData(matrixN.getMaterial().getMaterialData())) continue block0;
            }
            return entry;
        }
        block2: for (Map.Entry<ItemScriptContainer, List<ItemTag>> entry : shapelessRecipesMap.entrySet()) {
            ArrayList<ItemStack> entryList = new ArrayList<ItemStack>();
            ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
            for (ItemTag entryItem : entry.getValue()) {
                entryList.add(entryItem.getItemStack().clone());
            }
            for (ItemStack itemStack : matrix) {
                matrixList.add(itemStack != null ? itemStack.clone() : new ItemStack(Material.AIR));
            }
            ArrayList<ItemTag> shapedRecipe = new ArrayList<ItemTag>();
            Iterator mL = matrixList.iterator();
            while (mL.hasNext()) {
                ItemStack matrixItem = (ItemStack)mL.next();
                if (matrixItem != null && matrixItem.getType() != Material.AIR) {
                    boolean matched = false;
                    Iterator eL = entryList.iterator();
                    while (eL.hasNext()) {
                        ItemStack entryItem = (ItemStack)eL.next();
                        if (!matrixItem.isSimilar(entryItem) || matrixItem.getAmount() < entryItem.getAmount()) continue;
                        shapedRecipe.add(new ItemTag(entryItem));
                        mL.remove();
                        eL.remove();
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    continue block2;
                }
                shapedRecipe.add(new ItemTag(Material.AIR));
                mL.remove();
            }
            if (!entryList.isEmpty() || !matrixList.isEmpty()) continue;
            return new AbstractMap.SimpleEntry<ItemScriptContainer, List<ItemTag>>(entry.getKey(), shapedRecipe);
        }
        return null;
    }

    public ItemTag getSpecialRecipeResult(ItemStack[] matrix, Player player) {
        Map.Entry<ItemScriptContainer, List<ItemTag>> recipeEntry = this.getSpecialRecipeEntry(matrix);
        if (recipeEntry != null) {
            return recipeEntry.getKey().getItemFrom(new BukkitTagContext(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player), null, null));
        }
        return null;
    }

    public boolean emulateSpecialRecipeResultShiftClick(CraftingInventory inventory, Player player) {
        ItemStack[] matrix = inventory.getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = matrix[i] == null ? new ItemStack(Material.AIR) : matrix[i].clone();
        }
        Map.Entry<ItemScriptContainer, List<ItemTag>> recipeEntry = this.getSpecialRecipeEntry(matrix);
        if (recipeEntry != null) {
            int n;
            List<ItemTag> recipe = recipeEntry.getValue();
            ItemTag result = recipeEntry.getKey().getItemFrom(new BukkitTagContext(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player), null, null));
            int lowestAmount = 0;
            for (n = 0; n < matrix.length; ++n) {
                if (matrix[n].getAmount() == 0 || recipe.get(n).getAmount() == 0 || matrix[n].getAmount() / recipe.get(n).getAmount() >= lowestAmount && lowestAmount != 0) continue;
                lowestAmount = matrix[n].getAmount() / recipe.get(n).getAmount();
            }
            for (n = 0; n < matrix.length; ++n) {
                if (matrix[n].getAmount() <= 0) continue;
                matrix[n].setAmount(matrix[n].getAmount() - lowestAmount * recipe.get(n).getAmount());
                if (matrix[n].getAmount() > 0) continue;
                matrix[n] = null;
            }
            if (lowestAmount > 1) {
                ItemStack resultStack = result.getItemStack().clone();
                resultStack.setAmount(lowestAmount * resultStack.getAmount());
                inventory.setMatrix(matrix);
                inventory.setResult(resultStack);
                player.updateInventory();
            }
            return true;
        }
        return false;
    }
}

