/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ExCommandHandler
implements CommandExecutor,
TabCompleter {
    public HashSet<String> allTagsEver = new HashSet();

    public void enableFor(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        if (cmdName.equalsIgnoreCase("ex")) {
            boolean quiet;
            ArrayList<Object> entries = new ArrayList<Object>();
            String entry = String.join((CharSequence)" ", args);
            boolean bl = quiet = !Settings.showExDebug();
            if (entry.length() > 3 && entry.startsWith("-q ")) {
                quiet = !quiet;
                entry = entry.substring("-q ".length());
            }
            if (entry.length() < 2) {
                sender.sendMessage("/ex (-q) <denizen script command> (arguments)");
                return true;
            }
            if (Settings.showExHelp()) {
                if (Debug.showDebug) {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... check the console for full debug output!");
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "Executing Denizen script command... to see debug, use /denizen debug");
                }
            }
            entries.add(entry);
            InstantQueue queue = new InstantQueue("EXCOMMAND");
            NPCTag npc = null;
            if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
                npc = new NPCTag(Depends.citizens.getNPCSelector().getSelected(sender));
            }
            List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(sender instanceof Player ? new PlayerTag((Player)sender) : null, npc));
            queue.addEntries(scriptEntries);
            if (!quiet && sender instanceof Player) {
                Player player = (Player)sender;
                queue.debugOutput = s -> player.spigot().sendMessage(FormattedTextHelper.parse(s));
            }
            queue.start();
            return true;
        }
        return false;
    }

    public void processTagList() {
        this.allTagsEver.clear();
        for (ObjectFetcher.ObjectType<? extends ObjectTag> type : ObjectFetcher.objectsByClass.values()) {
            if (type.tagProcessor == null) continue;
            this.allTagsEver.addAll(type.tagProcessor.registeredObjectTags.keySet());
        }
        for (PropertyParser.ClassPropertiesInfo properties : PropertyParser.propertiesByClass.values()) {
            this.allTagsEver.addAll(properties.propertiesByTag.keySet());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String cmdName, String[] rawArgs) {
        String lastArg;
        int tagStartIndex;
        boolean isCommandArg;
        boolean isNewArg;
        if (!cmdName.equalsIgnoreCase("ex") || !sender.hasPermission("denizen.ex")) {
            return null;
        }
        String entry = String.join((CharSequence)" ", rawArgs);
        if (entry.length() > 3 && entry.startsWith("-q ")) {
            entry = entry.substring("-q ".length());
        }
        String[] args = ArgumentHelper.buildArgs(entry);
        boolean bl = isNewArg = rawArgs.length == 0 || rawArgs[rawArgs.length - 1].isEmpty();
        boolean bl2 = args.length == 0 || args.length == 1 && !isNewArg || args[args.length - (isNewArg ? 1 : 2)].equals("-") ? true : (isCommandArg = false);
        if (isCommandArg) {
            if (isNewArg || args.length == 0) {
                return new ArrayList<String>(DenizenCore.getCommandRegistry().instances.keySet());
            }
            ArrayList<String> output = new ArrayList<String>();
            String startOfName = CoreUtilities.toLowerCase(args[args.length - 1]);
            for (String command : DenizenCore.getCommandRegistry().instances.keySet()) {
                if (!command.startsWith(startOfName)) continue;
                output.add(command);
            }
            return output;
        }
        if (!isNewArg && (tagStartIndex = (lastArg = rawArgs[rawArgs.length - 1]).lastIndexOf(60)) > lastArg.lastIndexOf(62)) {
            String actualTag = lastArg.substring(tagStartIndex + 1);
            String beforeTag = lastArg.substring(0, tagStartIndex + 1);
            if (!actualTag.contains("[") && !actualTag.contains(".")) {
                String tagText = CoreUtilities.toLowerCase(actualTag);
                ArrayList<String> output = new ArrayList<String>();
                for (String tagBase : TagManager.properTagBases) {
                    if (!tagBase.startsWith(tagText)) continue;
                    output.add(beforeTag + tagBase);
                }
                return output;
            }
            int lastDot = actualTag.lastIndexOf(46);
            if (lastDot <= 0) {
                return new ArrayList<String>();
            }
            beforeTag = beforeTag + actualTag.substring(0, lastDot + 1);
            String lastPart = CoreUtilities.toLowerCase(actualTag.substring(lastDot + 1));
            if (lastPart.contains("[") || lastPart.isEmpty()) {
                return new ArrayList<String>();
            }
            ArrayList<String> output = new ArrayList<String>();
            for (String singleTag : this.allTagsEver) {
                if (!singleTag.startsWith(lastPart)) continue;
                output.add(beforeTag + singleTag);
            }
            return output;
        }
        AbstractCommand dcmd = DenizenCore.getCommandRegistry().get(args[0]);
        for (int i = args.length - 2; i >= 0; --i) {
            if (!args[i].equals("-")) continue;
            dcmd = DenizenCore.getCommandRegistry().get(args[i + 1]);
        }
        if (dcmd == null) {
            return null;
        }
        String lowArg = CoreUtilities.toLowerCase(rawArgs[rawArgs.length - 1]);
        ArrayList<String> output = new ArrayList<String>();
        for (String flat : dcmd.getOptions().flatArgs) {
            if (!flat.startsWith(lowArg)) continue;
            output.add(flat);
        }
        for (String prefix : dcmd.getOptions().prefixes) {
            if (!prefix.startsWith(lowArg)) continue;
            output.add(prefix + ":");
        }
        return output;
    }
}

