/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.inventory;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;

public class InventorySize
implements Property {
    public static final String[] handledMechs = new String[]{"size"};
    InventoryTag inventory;

    public static boolean describes(ObjectTag inventory) {
        return inventory instanceof InventoryTag;
    }

    public static InventorySize getFrom(ObjectTag inventory) {
        if (!InventorySize.describes(inventory)) {
            return null;
        }
        return new InventorySize((InventoryTag)inventory);
    }

    public InventorySize(InventoryTag inventory) {
        this.inventory = inventory;
    }

    public int getSize() {
        if (this.inventory.getInventory() == null) {
            return 0;
        }
        return this.inventory.getInventory().getSize();
    }

    public void setSize(int size) {
        this.inventory.setSize(size);
    }

    @Override
    public String getPropertyString() {
        if (this.getSize() > 0 && this.inventory.getIdType().equals("generic") && this.inventory.getIdHolder().equals("CHEST")) {
            return String.valueOf(this.getSize());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "size";
    }

    public static void registerTags() {
        PropertyParser.registerTag("size", (attribute, inventory) -> new ElementTag(InventorySize.getFrom(inventory).getSize()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("size") && this.inventory.getIdType().equals("generic") && mechanism.requireInteger()) {
            this.setSize(mechanism.getValue().asInt());
        }
    }
}

