/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;

public class MaterialFaces
implements Property {
    public static final String[] handledTags = new String[]{"faces", "valid_faces"};
    public static final String[] handledMechs = new String[]{"faces"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData().data instanceof MultipleFacing;
    }

    public static MaterialFaces getFrom(ObjectTag _material) {
        if (!MaterialFaces.describes(_material)) {
            return null;
        }
        return new MaterialFaces((MaterialTag)_material);
    }

    private MaterialFaces(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("valid_faces")) {
            ListTag toReturn = new ListTag();
            for (BlockFace face : this.getFaces().getAllowedFaces()) {
                toReturn.add(face.name());
            }
            return toReturn.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("faces")) {
            ListTag toReturn = new ListTag();
            for (BlockFace face : this.getFaces().getFaces()) {
                toReturn.add(face.name());
            }
            return toReturn.getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public MultipleFacing getFaces() {
        return (MultipleFacing)this.material.getModernData().data;
    }

    @Override
    public String getPropertyString() {
        ListTag toReturn = new ListTag();
        for (BlockFace face : this.getFaces().getFaces()) {
            toReturn.add(face.name());
        }
        return toReturn.identify();
    }

    @Override
    public String getPropertyId() {
        return "faces";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("faces")) {
            MultipleFacing facing = this.getFaces();
            for (BlockFace face : facing.getAllowedFaces()) {
                facing.setFace(face, false);
            }
            for (String faceName : mechanism.valueAsType(ListTag.class)) {
                facing.setFace(BlockFace.valueOf((String)faceName.toUpperCase()), true);
            }
        }
    }
}

