/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_14.impl.blocks;

import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_14.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.blocks.ModernBlockData;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.TileEntity;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;

public class BlockDataImpl
implements com.denizenscript.denizen.nms.interfaces.BlockData {
    private BlockData blockData;
    CompoundTagImpl ctag = null;

    public BlockDataImpl() {
    }

    public BlockDataImpl(Material mat, byte dat) {
        if (!mat.isLegacy()) {
            if (dat == 0) {
                this.blockData = Bukkit.createBlockData((Material)mat);
                return;
            }
            mat = Bukkit.getUnsafe().toLegacy(mat);
        }
        this.blockData = Bukkit.getUnsafe().fromLegacy(mat, dat);
    }

    public BlockDataImpl(BlockData data) {
        this.blockData = data;
    }

    public BlockDataImpl(Block block) {
        ModernBlockData mbd = new ModernBlockData(block);
        this.blockData = mbd.data;
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            this.ctag = (CompoundTagImpl)CompoundTagImpl.fromNMSTag(compound);
        }
    }

    @Override
    public void setBlock(Block block, boolean physics) {
        block.setBlockData(this.blockData, physics);
        if (this.ctag != null) {
            CompoundTagBuilder builder = this.ctag.createBuilder();
            builder.putInt("x", block.getX());
            builder.putInt("y", block.getY());
            builder.putInt("z", block.getZ());
            this.ctag = (CompoundTagImpl)builder.build();
            BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
            TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
            te.load(this.ctag.toNMSTag());
        }
    }

    @Override
    public String toCompressedFormat() {
        return "{" + this.blockData.getMaterial().name() + "}";
    }

    public static com.denizenscript.denizen.nms.interfaces.BlockData fromCompressedString(String str) {
        BlockDataImpl data = new BlockDataImpl();
        data.blockData = Bukkit.createBlockData((Material)Material.getMaterial((String)str));
        return data;
    }

    @Override
    public CompoundTag getCompoundTag() {
        return this.ctag;
    }

    @Override
    public void setCompoundTag(CompoundTag tag) {
        this.ctag = (CompoundTagImpl)tag;
    }

    @Override
    public Material getMaterial() {
        return this.blockData.getMaterial();
    }

    @Override
    public void setMaterial(Material material) {
        this.blockData = Bukkit.createBlockData((Material)material);
    }

    @Override
    public byte getData() {
        return 0;
    }

    @Override
    public void setData(byte data) {
    }

    @Override
    public ModernBlockData modern() {
        return new ModernBlockData(this.blockData);
    }
}

