/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Axis;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;

public class MaterialDirectional
implements Property {
    public static final String[] handledTags = new String[]{"direction", "valid_directions"};
    public static final String[] handledMechs = new String[]{"direction"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData().data;
        return data instanceof Directional || data instanceof Orientable;
    }

    public static MaterialDirectional getFrom(ObjectTag _material) {
        if (!MaterialDirectional.describes(_material)) {
            return null;
        }
        return new MaterialDirectional((MaterialTag)_material);
    }

    private MaterialDirectional(MaterialTag _material) {
        this.material = _material;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("valid_directions")) {
            ListTag toReturn = new ListTag();
            if (this.isOrientable()) {
                for (Axis axis : this.getOrientable().getAxes()) {
                    toReturn.add(axis.name());
                }
            } else {
                for (BlockFace face : this.getDirectional().getFaces()) {
                    toReturn.add(face.name());
                }
            }
            return toReturn.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("direction")) {
            return new ElementTag(this.getDirectionName()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public String getDirectionName() {
        if (this.isOrientable()) {
            return this.getOrientable().getAxis().name();
        }
        return this.getDirectional().getFacing().name();
    }

    public boolean isOrientable() {
        return this.material.getModernData().data instanceof Orientable;
    }

    public Orientable getOrientable() {
        return (Orientable)this.material.getModernData().data;
    }

    public Directional getDirectional() {
        return (Directional)this.material.getModernData().data;
    }

    public BlockFace getDirection() {
        return this.getDirectional().getFacing();
    }

    @Override
    public String getPropertyString() {
        return this.getDirectionName();
    }

    @Override
    public String getPropertyId() {
        return "direction";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("direction")) {
            if (this.isOrientable() && mechanism.requireEnum(false, (Enum<?>[])Axis.values())) {
                this.getOrientable().setAxis(Axis.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (!this.isOrientable() && mechanism.requireEnum(false, (Enum<?>[])BlockFace.values())) {
                this.getDirectional().setFacing(BlockFace.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            }
        }
    }
}

