/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.SittingTrait;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sittable;

public class StandCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Entity entity;
        if (Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.PLAYER && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.OCELOT && Utilities.getEntryNPC(scriptEntry).getEntityType() != EntityType.WOLF) {
            Debug.echoError(scriptEntry.getResidingQueue(), "...only Player, ocelot, or wolf type NPCs can sit!");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("npc", Utilities.getEntryNPC(scriptEntry)));
        }
        if ((entity = Utilities.getEntryNPC(scriptEntry).getEntity()) instanceof Sittable) {
            ((Sittable)entity).setSitting(false);
        } else {
            NPC npc = Utilities.getEntryNPC(scriptEntry).getCitizen();
            SittingTrait trait = (SittingTrait)npc.getTrait(SittingTrait.class);
            if (!npc.hasTrait(SittingTrait.class)) {
                npc.addTrait(SittingTrait.class);
                Debug.echoDebug((Debuggable)scriptEntry, "...added sitting trait");
            }
            trait.stand();
            npc.removeTrait(SittingTrait.class);
        }
    }
}

