/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;

public class TimeCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesArgumentType(DurationTag.class)) {
                scriptEntry.addObject("value", arg.asType(DurationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
        if (!scriptEntry.hasObject("world")) {
            scriptEntry.addObject("world", Utilities.entryHasNPC(scriptEntry) ? new WorldTag(Utilities.getEntryNPC(scriptEntry).getWorld()) : (Utilities.entryHasPlayer(scriptEntry) ? new WorldTag(Utilities.getEntryPlayer(scriptEntry).getWorld()) : null));
        }
        scriptEntry.defaultObject("type", new ElementTag("GLOBAL"));
        if (!scriptEntry.hasObject("world")) {
            throw new InvalidArgumentsException("Must specify a valid world!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        DurationTag value = (DurationTag)scriptEntry.getObject("value");
        WorldTag world = (WorldTag)scriptEntry.getObject("world");
        ElementTag type_element = scriptEntry.getElement("type");
        Type type = Type.valueOf(type_element.asString().toUpperCase());
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), type_element.debug() + value.debug() + world.debug());
        }
        if (type.equals((Object)Type.GLOBAL)) {
            world.getWorld().setTime(value.getTicks());
        } else if (!Utilities.entryHasPlayer(scriptEntry)) {
            Debug.echoError("Must have a valid player link!");
        } else {
            Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setPlayerTime(value.getTicks(), true);
        }
    }

    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

