/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers.core;

import com.denizenscript.denizen.npc.traits.TriggerTrait;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.triggers.AbstractTrigger;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.Map;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClickTrigger
extends AbstractTrigger
implements Listener {
    @EventHandler
    public void clickTrigger(NPCRightClickEvent event) {
        Map<String, String> idMap;
        if (!event.getNPC().hasTrait(TriggerTrait.class)) {
            return;
        }
        NPCTag npc = DenizenAPI.getDenizenNPC(event.getNPC());
        if (!npc.getTriggerTrait().isEnabled(this.name)) {
            return;
        }
        PlayerTag player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getClicker());
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, player);
        if (!trigger.wasTriggered()) {
            return;
        }
        if (trigger.hasDetermination() && trigger.getDetermination().equalsIgnoreCase("cancelled")) {
            event.setCancelled(true);
            return;
        }
        InteractScriptContainer script = npc.getInteractScript(player, this.getClass());
        String id = null;
        if (script != null && !(idMap = script.getIdMapFor(this.getClass(), player)).isEmpty()) {
            for (Map.Entry<String, String> entry : idMap.entrySet()) {
                String entry_value = TagManager.tag(entry.getValue(), new BukkitTagContext(player, npc, false, null, false, null));
                ItemTag item = ItemTag.valueOf(entry_value, script);
                if (item == null) {
                    Debug.echoError("Invalid click trigger in script '" + script.getName() + "' (null trigger item)!");
                }
                if (item == null || item.comparesTo(player.getPlayerEntity().getItemInHand()) < 0) continue;
                id = entry.getKey();
            }
        }
        if (!this.parse(npc, player, script, id)) {
            npc.action("no click trigger", player);
        }
    }

    @Override
    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }
}

