/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.CustomScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.TaskScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.WorldScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.YamlDataScriptContainer;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScriptRegistry {
    public static Map<String, ScriptContainer> scriptContainers = new HashMap<String, ScriptContainer>();
    public static Map<String, Class<? extends ScriptContainer>> scriptContainerTypes = new HashMap<String, Class<? extends ScriptContainer>>();
    public static YamlConfiguration fullYaml;
    public static ArrayList<String> toPostLoadAttempt;
    public static List<YamlConfiguration> outside_scripts;

    public static void _registerType(String typeName, Class<? extends ScriptContainer> scriptContainerClass) {
        scriptContainerTypes.put(typeName.toUpperCase(), scriptContainerClass);
    }

    public static void _registerCoreTypes() {
        ScriptRegistry._registerType("custom", CustomScriptContainer.class);
        ScriptRegistry._registerType("task", TaskScriptContainer.class);
        ScriptRegistry._registerType("procedure", ProcedureScriptContainer.class);
        ScriptRegistry._registerType("world", WorldScriptContainer.class);
        ScriptRegistry._registerType("yaml data", YamlDataScriptContainer.class);
    }

    public static boolean containsScript(String id) {
        return scriptContainers.containsKey(id.toUpperCase());
    }

    public static boolean containsScript(String id, Class scriptContainerType) {
        if (!scriptContainers.containsKey(id.toUpperCase())) {
            return false;
        }
        ScriptContainer script = scriptContainers.get(id.toUpperCase());
        String type = null;
        for (Map.Entry<String, Class<? extends ScriptContainer>> entry : scriptContainerTypes.entrySet()) {
            if (entry.getValue() != scriptContainerType) continue;
            type = entry.getKey();
        }
        return type != null && script.getContainerType().equalsIgnoreCase(type);
    }

    public static void postLoadScripts() {
        for (String scriptName : toPostLoadAttempt) {
            ScriptRegistry.attemptLoadSingle(scriptName, true);
        }
        toPostLoadAttempt.clear();
        fullYaml = null;
    }

    public static void attemptLoadSingle(String scriptName, boolean shouldErrorOnType) {
        if (fullYaml.contains(scriptName + ".TYPE")) {
            String type = fullYaml.getString(scriptName + ".TYPE");
            if (!scriptContainerTypes.containsKey(type.toUpperCase())) {
                if (shouldErrorOnType) {
                    Debug.log("<G>Trying to load an invalid script. '<A>" + scriptName + "<Y>(" + type + ")'<G> is an unknown type.");
                    ScriptHelper.setHadError();
                } else {
                    toPostLoadAttempt.add(scriptName);
                }
                return;
            }
            Class<? extends ScriptContainer> typeClass = scriptContainerTypes.get(type.toUpperCase());
            Debug.log("Adding script " + scriptName + " as type " + type.toUpperCase());
            try {
                scriptContainers.put(scriptName, typeClass.getConstructor(YamlConfiguration.class, String.class).newInstance(ScriptHelper._gs().getConfigurationSection(scriptName), scriptName));
            }
            catch (Exception e) {
                Debug.echoError(e);
                ScriptHelper.setHadError();
            }
        } else {
            Debug.echoError("Found type-less container: '" + scriptName + "'.");
            ScriptHelper.setHadError();
        }
    }

    public static void buildCoreYamlScriptContainers(YamlConfiguration yamlScripts) {
        fullYaml = yamlScripts;
        scriptContainers.clear();
        OldEventManager.world_scripts.clear();
        OldEventManager.events.clear();
        DenizenCore.getImplementation().refreshScriptContainers();
        if (yamlScripts == null) {
            return;
        }
        Set<StringHolder> scripts = yamlScripts.getKeys(false);
        for (StringHolder scriptName : scripts) {
            ScriptRegistry.attemptLoadSingle(scriptName.str, false);
        }
    }

    public static void addYamlScriptContainer(YamlConfiguration yaml_script) {
        outside_scripts.add(yaml_script);
    }

    public static void removeYamlScriptContainer(YamlConfiguration yaml_script) {
        outside_scripts.remove(yaml_script);
        DenizenCore.reloadScripts();
    }

    public static <T extends ScriptContainer> T getScriptContainerAs(String name, Class<T> type) {
        try {
            if (scriptContainers.containsKey(name.toUpperCase())) {
                return (T)((ScriptContainer)type.cast(scriptContainers.get(name.toUpperCase())));
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends ScriptContainer> T getScriptContainer(String name) {
        if (scriptContainers.containsKey(name.toUpperCase())) {
            return (T)scriptContainers.get(name.toUpperCase());
        }
        return null;
    }

    static {
        toPostLoadAttempt = new ArrayList();
        outside_scripts = new ArrayList<YamlConfiguration>();
    }
}

