/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.core;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class CommandScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static CommandScriptEvent instance;
    public String commandName;
    public String fullMessage;
    public String sourceType;
    public Location location;
    public PlayerCommandPreprocessEvent playerEvent;
    public ServerCommandEvent serverEvent;

    public CommandScriptEvent() {
        instance = this;
    }

    @Override
    public String getName() {
        return "Command";
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("command") || path.eventArgLowerAt(0).equals("command") && !path.eventArgLowerAt(1).equals("unknown");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.playerEvent == null ? null : this.playerEvent.getPlayer().getLocation())) {
            return false;
        }
        if (!path.eventArgLowerAt(0).equals("command") && !this.runGenericCheck(path.eventArgLowerAt(0), EscapeTagBase.escape(this.commandName))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.playerEvent == null ? null : new PlayerTag(this.playerEvent.getPlayer()), null);
    }

    public String cleanMessageArgs() {
        return this.fullMessage.split(" ").length > 1 ? this.fullMessage.split(" ", 2)[1] : "";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determination = determinationObj.toString())).equals("fulfilled")) {
            this.cancelled = true;
            this.cancellationChanged();
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("command")) {
            return new ElementTag(this.commandName);
        }
        if (name.equals("raw_args")) {
            return new ElementTag(this.cleanMessageArgs());
        }
        if (name.equals("args")) {
            return new ListTag(Arrays.asList(ArgumentHelper.buildArgs(this.cleanMessageArgs())));
        }
        if (name.equals("server")) {
            return new ElementTag(this.sourceType.equals("server"));
        }
        if (name.equals("source_type")) {
            return new ElementTag(this.sourceType);
        }
        if (name.equals("command_block_location") && this.serverEvent != null && this.serverEvent.getSender() instanceof BlockCommandSender) {
            return new LocationTag(((BlockCommandSender)this.serverEvent.getSender()).getBlock().getLocation());
        }
        if (name.equals("command_minecart") && this.serverEvent != null && this.serverEvent.getSender() instanceof CommandMinecart) {
            return new EntityTag((Entity)((CommandMinecart)this.serverEvent.getSender()));
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEvent(PlayerCommandPreprocessEvent event) {
        this.playerEvent = event;
        this.serverEvent = null;
        this.fullMessage = event.getMessage();
        this.commandName = this.fullMessage.split(" ")[0].substring(1);
        this.location = event.getPlayer().getLocation();
        this.sourceType = "player";
        this.fire((Event)event);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && this.serverEvent != null) {
            this.serverEvent.setCommand("denizen do_nothing");
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onServerEvent(ServerCommandEvent event) {
        this.playerEvent = null;
        this.serverEvent = event;
        this.fullMessage = event.getCommand();
        this.commandName = this.fullMessage.split(" ")[0];
        if (event.getSender() instanceof BlockCommandSender) {
            this.location = ((BlockCommandSender)event.getSender()).getBlock().getLocation();
            this.sourceType = "command_block";
        } else if (event.getSender() instanceof CommandMinecart) {
            this.location = ((CommandMinecart)event.getSender()).getLocation();
            this.sourceType = "command_minecart";
        } else {
            this.location = null;
            this.sourceType = "server";
        }
        this.fire((Event)event);
    }
}

