/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class TakeCommand
extends AbstractCommand {
    public TakeCommand() {
        this.setName("take");
        this.setSyntax("take [money/xp/iteminhand/scriptname:<name>/bydisplay:<name>/bycover:<title>|<author>/slot:<slot>/nbt:<key>/material:<material>/<item>|...] (quantity:<#>) (from:<inventory>)");
        this.setRequiredArguments(1, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp")) {
                scriptEntry.addObject("type", (Object)Type.XP);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("item_in_hand", "iteminhand")) {
                scriptEntry.addObject("type", (Object)Type.ITEMINHAND);
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesFloat()) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("bydisplay") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.BYDISPLAY);
                scriptEntry.addObject("displayname", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && arg.matchesPrefix("nbt") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.NBT);
                scriptEntry.addObject("nbt_key", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("bycover")) {
                scriptEntry.addObject("type", (Object)Type.BYCOVER);
                scriptEntry.addObject("cover", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("material")) {
                scriptEntry.addObject("type", (Object)Type.MATERIAL);
                scriptEntry.addObject("material", arg.asType(MaterialTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && !scriptEntry.hasObject("items") && arg.matchesPrefix("script", "scriptname")) {
                scriptEntry.addObject("type", (Object)Type.SCRIPTNAME);
                scriptEntry.addObject("scriptitem", arg.asType(ItemTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && !scriptEntry.hasObject("type") && arg.matchesPrefix("slot")) {
                scriptEntry.addObject("type", (Object)Type.SLOT);
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(ItemTag.class)) {
                scriptEntry.addObject("items", ListTag.valueOf(arg.raw_value.replace("item:", ""), scriptEntry.getContext()).filter(ItemTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("f", "from") && arg.matchesArgumentType(InventoryTag.class)) {
                scriptEntry.addObject("inventory", arg.asType(InventoryTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("inventory")) {
                Deprecations.takeCommandInventory.warn(scriptEntry);
                scriptEntry.addObject("type", (Object)Type.INVENTORY);
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matches("npc")) {
                Deprecations.takeCommandInventory.warn(scriptEntry);
                scriptEntry.addObject("inventory", Utilities.getEntryNPC(scriptEntry).getDenizenEntity().getInventory());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("qty", new ElementTag(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to take from!");
        }
        if (type == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException("Must specify item/items!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        InventoryTag inventory = (InventoryTag)scriptEntry.getObjectTag("inventory");
        ElementTag qty = scriptEntry.getElement("qty");
        ElementTag displayname = scriptEntry.getElement("displayname");
        ItemTag scriptitem = (ItemTag)scriptEntry.getObjectTag("scriptitem");
        ElementTag slot = scriptEntry.getElement("slot");
        ListTag titleAuthor = (ListTag)scriptEntry.getObjectTag("cover");
        ElementTag nbtKey = scriptEntry.getElement("nbt_key");
        MaterialTag material = (MaterialTag)scriptEntry.getObjectTag("material");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("Type", type.name()) + qty.debug() + (inventory != null ? inventory.debug() : "") + (displayname != null ? displayname.debug() : "") + (scriptitem != null ? scriptitem.debug() : "") + ArgumentHelper.debugObj("Items", items) + (slot != null ? slot.debug() : "") + (nbtKey != null ? nbtKey.debug() : "") + (material != null ? material.debug() : "") + (titleAuthor != null ? titleAuthor.debug() : ""));
        }
        switch (type) {
            case INVENTORY: {
                inventory.clear();
                break;
            }
            case ITEMINHAND: {
                int inHandAmt = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getEquipment().getItemInMainHand().getAmount();
                int theAmount = (int)qty.asDouble();
                ItemStack newHandItem = new ItemStack(Material.AIR);
                if (theAmount > inHandAmt) {
                    Debug.echoDebug((Debuggable)scriptEntry, "...player did not have enough of the item in hand, taking all...");
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                if (theAmount == inHandAmt) {
                    Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                    break;
                }
                newHandItem = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().getEquipment().getItemInMainHand().clone();
                newHandItem.setAmount(inHandAmt - theAmount);
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().setItemInHand(newHandItem);
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().updateInventory();
                break;
            }
            case MONEY: {
                if (Depends.economy == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "No economy loaded! Have you installed Vault and a compatible economy plugin?");
                    return;
                }
                Depends.economy.withdrawPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), qty.asDouble());
                break;
            }
            case XP: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp(-qty.asInt());
                break;
            }
            case ITEM: {
                for (ItemTag item2 : items) {
                    ItemStack is = item2.getItemStack();
                    is.setAmount(qty.asInt());
                    if (inventory.removeItem(item2, item2.getAmount())) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "Inventory does not contain at least " + qty.asInt() + " of " + item2.getFullString() + "... Taking all...");
                }
                break;
            }
            case BYDISPLAY: {
                if (displayname == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a displayname!");
                    return;
                }
                this.takeByMatcher(inventory, item -> item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equalsIgnoreCase(displayname.identify()), qty.asInt());
                break;
            }
            case BYCOVER: {
                if (titleAuthor == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a cover!");
                    return;
                }
                inventory.removeBook((String)titleAuthor.get(0), titleAuthor.size() > 1 ? (String)titleAuthor.get(1) : null, qty.asInt());
                break;
            }
            case NBT: {
                if (nbtKey == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify an NBT key!");
                    return;
                }
                this.takeByMatcher(inventory, item -> CustomNBT.hasCustomNBT(item, nbtKey.asString(), "Denizen NBT"), qty.asInt());
                break;
            }
            case SCRIPTNAME: {
                if (scriptitem == null || scriptitem.getScriptName() == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid script name!");
                    return;
                }
                this.takeByMatcher(inventory, item -> scriptitem.getScriptName().equalsIgnoreCase(new ItemTag((ItemStack)item).getScriptName()), qty.asInt());
                break;
            }
            case MATERIAL: {
                if (material == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a valid material!");
                    return;
                }
                this.takeByMatcher(inventory, item -> item.getType() == material.getMaterial() && !new ItemTag((ItemStack)item).isItemscript(), qty.asInt());
                break;
            }
            case SLOT: {
                int slotId = SlotHelper.nameToIndex(slot.asString());
                if (slotId == -1 || slotId >= inventory.getSize()) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "The input '" + slot.asString() + "' is not a valid slot!");
                    return;
                }
                ItemStack original = inventory.getInventory().getItem(slotId);
                if (original == null || original.getType() == Material.AIR) break;
                if (original.getAmount() > qty.asInt()) {
                    original.setAmount(original.getAmount() - qty.asInt());
                    inventory.setSlots(slotId, original);
                    break;
                }
                inventory.setSlots(slotId, new ItemStack(Material.AIR));
                break;
            }
        }
    }

    public void takeByMatcher(InventoryTag inventory, Function<ItemStack, Boolean> matcher, int quantity) {
        int itemsTaken = 0;
        for (ItemStack it : inventory.getContents()) {
            if (itemsTaken >= quantity || it == null || !matcher.apply(it).booleanValue()) continue;
            int amt = it.getAmount();
            if (itemsTaken + amt <= quantity) {
                inventory.getInventory().removeItem(new ItemStack[]{it});
                itemsTaken += amt;
                continue;
            }
            it.setAmount(amt - (quantity - itemsTaken));
            break;
        }
    }

    private static enum Type {
        MONEY,
        XP,
        ITEMINHAND,
        ITEM,
        INVENTORY,
        BYDISPLAY,
        SLOT,
        BYCOVER,
        SCRIPTNAME,
        NBT,
        MATERIAL;

    }
}

