/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.util.Arrays;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Location;

public class AnchorCommand
extends AbstractCommand {
    public AnchorCommand() {
        this.setName("anchor");
        this.setSyntax("anchor [id:<name>] [remove/add <location>]");
        this.setRequiredArguments(2, 3);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("range") && arg.matchesFloat() && arg.matchesPrefix("range", "r")) {
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("id") && arg.matchesPrefix("id", "i")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!Utilities.entryHasNPC(scriptEntry)) {
            throw new InvalidArgumentsException("NPC linked was missing or invalid.");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify an 'Anchor Action'. Valid: " + Arrays.asList(Action.values()));
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify an ID.");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        ElementTag range = scriptEntry.getElement("range");
        ElementTag id = scriptEntry.getElement("id");
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), npc.debug() + action.name() + id.debug() + (location != null ? location.debug() : "") + (range != null ? range.debug() : ""));
        }
        if (!npc.getCitizen().hasTrait(Anchors.class)) {
            npc.getCitizen().addTrait(Anchors.class);
        }
        switch (action) {
            case ADD: {
                if (location == null) {
                    Debug.echoError("Must specify a location!");
                    return;
                }
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).addAnchor(id.asString(), (Location)location);
                return;
            }
            case ASSUME: {
                Deprecations.anchorWalk.warn(scriptEntry);
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getEntity().teleport(n.getLocation());
                }
                return;
            }
            case WALKNEAR: {
                Deprecations.anchorWalk.warn(scriptEntry);
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else if (range == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Must specify a range!");
                } else {
                    npc.getNavigator().setTarget(Utilities.getWalkableLocationNear(n.getLocation(), range.asInt()));
                }
                return;
            }
            case WALKTO: {
                Deprecations.anchorWalk.warn(scriptEntry);
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                } else {
                    npc.getNavigator().setTarget(n.getLocation());
                }
                return;
            }
            case REMOVE: {
                Anchor n = ((Anchors)npc.getCitizen().getTrait(Anchors.class)).getAnchor(id.asString());
                if (n == null) {
                    Debug.echoError(scriptEntry.getResidingQueue(), "Invalid anchor name '" + id.asString() + "'");
                    break;
                }
                ((Anchors)npc.getCitizen().getTrait(Anchors.class)).removeAnchor(n);
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        ASSUME,
        WALKTO,
        WALKNEAR;

    }
}

