/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import java.util.Arrays;
import java.util.List;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.trait.trait.Spawned;

public class DespawnCommand
extends AbstractCommand {
    public DespawnCommand() {
        this.setName("despawn");
        this.setSyntax("despawn (<npc>|...)");
        this.setRequiredArguments(0, 1);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(NPCTag.class)) {
                scriptEntry.addObject("npcs", arg.asType(ListTag.class).filter(NPCTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (Utilities.entryHasNPC(scriptEntry)) {
                scriptEntry.addObject("npcs", Arrays.asList(Utilities.getEntryNPC(scriptEntry)));
            } else {
                throw new InvalidArgumentsException("Must specify a valid list of NPCs!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), ArgumentHelper.debugObj("NPCs", npcs.toString()));
        }
        for (NPCTag npc : npcs) {
            if (!npc.isSpawned()) continue;
            if (npc.getCitizen().hasTrait(Spawned.class)) {
                ((Spawned)npc.getCitizen().getTrait(Spawned.class)).setSpawned(false);
            }
            npc.getCitizen().despawn(DespawnReason.PLUGIN);
        }
    }
}

