/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.shaded.org.json.JSONObject;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapTag
implements ObjectTag,
Adjustable {
    public LinkedHashMap<StringHolder, ObjectTag> map;
    String prefix = "Map";
    public static ObjectTagProcessor<MapTag> tagProcessor = new ObjectTagProcessor();

    public static String escapeEntry(String value) {
        return value.replace("&", "&amp").replace("|", "&pipe").replace("/", "&fs");
    }

    public static String unescapeEntry(String value) {
        return value.replace("&fs", "/").replace("&pipe", "|").replace("&amp", "&");
    }

    public static MapTag valueOf(String string) {
        return MapTag.valueOf(string, null);
    }

    @Fetchable(value="map")
    public static MapTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("map@") && string.length() > "map@".length()) {
            string = string.substring("map@".length());
        }
        MapTag result = new MapTag();
        if (string.length() == 0) {
            return result;
        }
        if (!string.endsWith("|")) {
            string = string + "|";
        }
        int pipe = string.indexOf(124);
        int lastPipe = 0;
        while (pipe != -1) {
            int slash = string.indexOf(47, lastPipe);
            if (slash == -1 || slash > pipe) {
                return null;
            }
            String key = string.substring(lastPipe, slash);
            String value = string.substring(slash + 1, pipe);
            result.map.put(new StringHolder(MapTag.unescapeEntry(key)), ObjectFetcher.pickObjectFor(MapTag.unescapeEntry(value), context));
            lastPipe = pipe + 1;
            pipe = string.indexOf(124, lastPipe);
        }
        return result;
    }

    public static MapTag getMapFor(ObjectTag inp, TagContext context) {
        return inp instanceof MapTag ? (MapTag)inp : MapTag.valueOf(inp.toString(), context);
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("map@")) {
            return true;
        }
        return MapTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public MapTag() {
        this.map = new LinkedHashMap();
    }

    public MapTag(Map<StringHolder, ObjectTag> map) {
        this.map = new LinkedHashMap<StringHolder, ObjectTag>(map);
    }

    @Override
    public MapTag duplicate() {
        MapTag newMap = new MapTag();
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            newMap.map.put(entry.getKey(), entry.getValue().duplicate());
        }
        return newMap;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public MapTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "map";
    }

    @Override
    public String debuggable() {
        if (this.map.isEmpty()) {
            return "map@";
        }
        StringBuilder debugText = new StringBuilder();
        debugText.append("<G>map@<Y> ");
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            debugText.append(entry.getKey().str).append(" <G>/<Y> ").append(entry.getValue().debuggable()).append(" <G>|<Y> ");
        }
        return debugText.substring(0, debugText.length() - " <G>|<Y> ".length());
    }

    @Override
    public String identify() {
        StringBuilder output = new StringBuilder();
        output.append("map@");
        for (Map.Entry<StringHolder, ObjectTag> entry : this.map.entrySet()) {
            output.append(MapTag.escapeEntry(entry.getKey().str)).append("/").append(MapTag.escapeEntry(entry.getValue().identify())).append("|");
        }
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        MapTag.registerTag("size", (attribute, object) -> new ElementTag(object.map.size()), new String[0]);
        MapTag.registerTag("is_empty", (attribute, object) -> new ElementTag(object.map.isEmpty()), new String[0]);
        MapTag.registerTag("get", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag 'MapTag.get' must have an input value.");
                return null;
            }
            return object.map.get(new StringHolder(attribute.getContext(1)));
        }, new String[0]);
        MapTag.registerTag("with", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag 'MapTag.with' must have an input value.");
                return null;
            }
            String key = attribute.getContext(1);
            attribute.fulfill(1);
            if (!attribute.matches("as")) {
                attribute.echoError("The tag 'MapTag.with' must be followed by '.as'.");
                return null;
            }
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag 'MapTag.with.as' must have an input value for 'as'.");
                return null;
            }
            ObjectTag value = attribute.getContextObject(1);
            MapTag result = object.duplicate();
            result.map.put(new StringHolder(key), value);
            return result;
        }, new String[0]);
        MapTag.registerTag("invert", (attribute, object) -> {
            MapTag result = new MapTag();
            for (Map.Entry<StringHolder, ObjectTag> entry : object.map.entrySet()) {
                result.map.put(new StringHolder(entry.getValue().identify()), new ElementTag(entry.getKey().str));
            }
            return result;
        }, new String[0]);
        MapTag.registerTag("exclude", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag 'MapTag.exclude' must have an input value.");
                return null;
            }
            MapTag result = object.duplicate();
            for (String key : ListTag.getListFor(attribute.getContextObject(1), attribute.context)) {
                result.map.remove(new StringHolder(key));
            }
            return result;
        }, new String[0]);
        MapTag.registerTag("include", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag 'MapTag.include' must have an input value.");
                return null;
            }
            MapTag result = object.duplicate();
            result.map.putAll(MapTag.getMapFor((ObjectTag)attribute.getContextObject((int)1), (TagContext)attribute.context).map);
            return result;
        }, new String[0]);
        MapTag.registerTag("list_keys", (attribute, object) -> {
            ListTag result = new ListTag();
            for (StringHolder entry : object.map.keySet()) {
                result.add(entry.str);
            }
            return result;
        }, new String[0]);
        MapTag.registerTag("list_values", (attribute, object) -> {
            ListTag result = new ListTag();
            for (ObjectTag entry : object.map.values()) {
                result.addObject(entry);
            }
            return result;
        }, new String[0]);
        MapTag.registerTag("to_json", (attribute, object) -> new ElementTag(new JSONObject((Map)CoreUtilities.objectTagToJavaForm(object.duplicate(), false)).toString()), new String[0]);
        MapTag.registerTag("to_yaml", (attribute, object) -> {
            YamlConfiguration output = new YamlConfiguration();
            output.contents = (Map)CoreUtilities.objectTagToJavaForm(object.duplicate(), true);
            return new ElementTag(output.saveToString(false));
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<MapTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("MapTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

