/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.MapScriptContainer;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.maps.DenizenMapManager;
import com.denizenscript.denizen.utilities.maps.DenizenMapRenderer;
import com.denizenscript.denizen.utilities.maps.MapAnimatedImage;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MapCommand
extends AbstractCommand {
    public MapCommand() {
        this.setName("map");
        this.setSyntax("map [<#>/new:<world>] [reset:<location> (scale:<value>) (tracking)/image:<file> (resize)/script:<script>] (x:<#>) (y:<#>)");
        this.setRequiredArguments(2, 7);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("new") && arg.matchesPrefix("new") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("new", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("reset-loc") && arg.matchesPrefix("r", "reset") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("reset-loc", arg.asType(LocationTag.class));
                scriptEntry.addObject("reset", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("reset") && arg.matches("reset")) {
                scriptEntry.addObject("reset", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("image") && arg.matchesPrefix("i", "img", "image")) {
                scriptEntry.addObject("image", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("resize") && arg.matches("resize")) {
                scriptEntry.addObject("resize", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("width") && arg.matchesPrefix("width") && arg.matchesInteger()) {
                scriptEntry.addObject("width", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrefix("height") && arg.matchesInteger()) {
                scriptEntry.addObject("height", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("scale") && arg.matchesPrefix("scale") && arg.matchesEnum((Enum<?>[])MapView.Scale.values())) {
                scriptEntry.addObject("scale", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("tracking") && arg.matches("tracking")) {
                scriptEntry.addObject("tracking", new ElementTag("true"));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesPrefix("s", "script") && arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("x-value") && arg.matchesPrefix("x") && arg.matchesFloat()) {
                scriptEntry.addObject("x-value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("y-value") && arg.matchesPrefix("y") && arg.matchesFloat()) {
                scriptEntry.addObject("y-value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("map-id") && arg.matchesInteger()) {
                scriptEntry.addObject("map-id", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("map-id") && !scriptEntry.hasObject("new")) {
            throw new InvalidArgumentsException("Must specify a map ID or create a new map!");
        }
        if (!(scriptEntry.hasObject("reset") || scriptEntry.hasObject("reset-loc") || scriptEntry.hasObject("image") || scriptEntry.hasObject("script"))) {
            throw new InvalidArgumentsException("Must specify a valid action to perform!");
        }
        scriptEntry.defaultObject("reset", new ElementTag(false)).defaultObject("resize", new ElementTag(false)).defaultObject("x-value", new ElementTag(0)).defaultObject("y-value", new ElementTag(0));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        MapView map;
        ElementTag id = scriptEntry.getElement("map-id");
        WorldTag create = (WorldTag)scriptEntry.getObjectTag("new");
        ElementTag reset = scriptEntry.getElement("reset");
        LocationTag resetLoc = (LocationTag)scriptEntry.getObjectTag("reset-loc");
        ElementTag image = scriptEntry.getElement("image");
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        ElementTag resize = scriptEntry.getElement("resize");
        ElementTag width = scriptEntry.getElement("width");
        ElementTag height = scriptEntry.getElement("height");
        ElementTag scale = scriptEntry.getElement("scale");
        ElementTag tracking = scriptEntry.getElement("tracking");
        ElementTag x = scriptEntry.getElement("x-value");
        ElementTag y = scriptEntry.getElement("y-value");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), (id != null ? id.debug() : "") + (create != null ? create.debug() : "") + reset.debug() + (resetLoc != null ? resetLoc.debug() : "") + (image != null ? image.debug() : "") + (script != null ? script.debug() : "") + resize.debug() + (width != null ? width.debug() : "") + (height != null ? height.debug() : "") + x.debug() + y.debug());
        }
        if (create != null) {
            map = Bukkit.getServer().createMap(create.getWorld());
            scriptEntry.addObject("created_map", new ElementTag(map.getId()));
        } else if (id != null) {
            map = Bukkit.getServer().getMap((int)((short)id.asInt()));
            if (map == null) {
                Debug.echoError("No map found for ID '" + id.asInt() + "'!");
                return;
            }
        } else {
            Debug.echoError("The map command failed somehow! Report this to a developer!");
            return;
        }
        if (reset.asBoolean()) {
            if (tracking != null) {
                map.setTrackingPosition(true);
            }
            if (scale != null) {
                map.setScale(MapView.Scale.valueOf((String)scale.asString().toUpperCase()));
            }
            List<MapRenderer> oldRenderers = DenizenMapManager.removeDenizenRenderers(map);
            for (MapRenderer renderer : oldRenderers) {
                map.addRenderer(renderer);
            }
            if (resetLoc != null) {
                map.setCenterX(resetLoc.getBlockX());
                map.setCenterZ(resetLoc.getBlockZ());
                map.setWorld(resetLoc.getWorld());
            }
        } else if (script != null) {
            DenizenMapManager.removeDenizenRenderers(map);
            ((MapScriptContainer)script.getContainer()).applyTo(map);
        } else {
            DenizenMapRenderer dmr = DenizenMapManager.getDenizenRenderer(map);
            if (image != null) {
                int high;
                int wide;
                int n = width != null ? width.asInt() : (wide = resize.asBoolean() ? 128 : 0);
                int n2 = height != null ? height.asInt() : (high = resize.asBoolean() ? 128 : 0);
                if (CoreUtilities.toLowerCase(image.asString()).endsWith(".gif")) {
                    dmr.autoUpdate = true;
                    dmr.addObject(new MapAnimatedImage(x.asString(), y.asString(), "true", false, image.asString(), wide, high));
                } else {
                    dmr.addObject(new MapImage(x.asString(), y.asString(), "true", false, image.asString(), wide, high));
                }
            }
        }
    }
}

