/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Map;

public class QueueTag
implements ObjectTag,
Adjustable {
    public ScriptQueue queue;
    String prefix = "Queue";
    public static ObjectTagProcessor<QueueTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static QueueTag valueOf(String string) {
        return QueueTag.valueOf(string, null);
    }

    @Fetchable(value="q")
    public static QueueTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("q@") && string.length() > 2) {
            string = string.substring(2);
        }
        if (ScriptQueue.queueExists(string)) {
            return new QueueTag(ScriptQueue.getExistingQueue(string));
        }
        return null;
    }

    public static boolean matches(String string) {
        return CoreUtilities.toLowerCase(string).startsWith("q@");
    }

    public QueueTag(ScriptQueue queue) {
        this.queue = queue;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public QueueTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "queue";
    }

    @Override
    public String identify() {
        return "q@" + this.queue.id;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String debuggable() {
        return "q@" + this.queue.debugId;
    }

    public static void registerTags() {
        QueueTag.registerTag("id", (attribute, object) -> new ElementTag(object.getQueue().id), new String[0]);
        QueueTag.registerTag("size", (attribute, object) -> new ElementTag(object.getQueue().script_entries.size()), new String[0]);
        QueueTag.registerTag("start_time", (attribute, object) -> new DurationTag(object.getQueue().startTimeMilli / 50L), new String[0]);
        QueueTag.registerTag("time_ran", (attribute, object) -> {
            long timeNano = System.nanoTime() - object.getQueue().startTime;
            return new DurationTag((double)timeNano / 1.0E9);
        }, new String[0]);
        QueueTag.registerTag("state", (attribute, object) -> {
            String state = object.getQueue() instanceof TimedQueue && ((TimedQueue)object.getQueue()).isPaused() ? "paused" : (object.getQueue().is_started ? "running" : (object.getQueue().is_stopping ? "stopping" : "unknown"));
            return new ElementTag(state);
        }, new String[0]);
        QueueTag.registerTag("script", (attribute, object) -> {
            if (object.getQueue().script == null) {
                return null;
            }
            return object.getQueue().script;
        }, new String[0]);
        QueueTag.registerTag("commands", (attribute, object) -> {
            ListTag commands = new ListTag();
            for (ScriptEntry entry : object.getQueue().script_entries) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getCommandName()).append(" ");
                for (String arg : entry.getOriginalArguments()) {
                    sb.append(arg).append(" ");
                }
                commands.add(sb.substring(0, sb.length() - 1));
            }
            return commands;
        }, new String[0]);
        QueueTag.registerTag("definitions", (attribute, object) -> new ListTag(object.getQueue().getAllDefinitions().keySet()), new String[0]);
        QueueTag.registerTag("definition_map", (attribute, object) -> {
            MapTag map = new MapTag();
            for (Map.Entry<String, ObjectTag> entry : object.getQueue().getAllDefinitions().entrySet()) {
                map.putObject(entry.getKey(), entry.getValue());
            }
            return map;
        }, new String[0]);
        QueueTag.registerTag("definition", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                Debug.echoError("The tag QueueTag.definition[...] must have a value.");
                return null;
            }
            return object.getQueue().getDefinitionObject(attribute.getContext(1));
        }, new String[0]);
        QueueTag.registerTag("determination", (attribute, object) -> {
            if (object.getQueue().determinations == null) {
                return null;
            }
            return object.getQueue().determinations;
        }, new String[0]);
        QueueTag.registerTag("speed", (attribute, object) -> {
            if (!(object.getQueue() instanceof TimedQueue)) {
                if (!attribute.hasAlternative()) {
                    Debug.echoError("The tag QueueTag.speed is only valid for Timed queues.");
                }
                return null;
            }
            return ((TimedQueue)object.getQueue()).getSpeed();
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<QueueTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ScriptQueue getQueue() {
        this.ensure();
        return this.queue;
    }

    public void ensure() {
        while (this.queue.replacementQueue != null) {
            this.queue = this.queue.replacementQueue;
        }
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("QueueTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        this.ensure();
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

