/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Comparator;
import org.bukkit.block.data.type.PistonHead;

public class MaterialMode
implements Property {
    public static final String[] handledMechs = new String[]{"mode"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        if (!(material instanceof MaterialTag)) {
            return false;
        }
        MaterialTag mat = (MaterialTag)material;
        if (!mat.hasModernData()) {
            return false;
        }
        BlockData data = mat.getModernData();
        return data instanceof Comparator || data instanceof PistonHead;
    }

    public static MaterialMode getFrom(ObjectTag _material) {
        if (!MaterialMode.describes(_material)) {
            return null;
        }
        return new MaterialMode((MaterialTag)_material);
    }

    private MaterialMode(MaterialTag _material) {
        this.material = _material;
    }

    public static void registerTags() {
        PropertyParser.registerTag("mode", (attribute, material) -> new ElementTag(material.getPropertyString()), new String[0]);
    }

    public boolean isComparator() {
        return this.material.getModernData() instanceof Comparator;
    }

    public boolean isPistonHead() {
        return this.material.getModernData() instanceof PistonHead;
    }

    public Comparator getComparator() {
        return (Comparator)this.material.getModernData();
    }

    public PistonHead getPistonHead() {
        return (PistonHead)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        if (this.isComparator()) {
            return this.getComparator().getMode().name();
        }
        return this.getPistonHead().isShort() ? "SHORT" : "NORMAL";
    }

    @Override
    public String getPropertyId() {
        return "mode";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("mode") && mechanism.requireEnum(false, (Enum<?>[])Comparator.Mode.values())) {
            if (this.isComparator() && mechanism.requireEnum(false, (Enum<?>[])Comparator.Mode.values())) {
                this.getComparator().setMode(Comparator.Mode.valueOf((String)mechanism.getValue().asString().toUpperCase()));
            } else if (this.isPistonHead()) {
                this.getPistonHead().setShort(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "short"));
            }
        }
    }
}

