/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class HurtCommand
extends AbstractCommand {
    public HurtCommand() {
        this.setName("hurt");
        this.setSyntax("hurt (<#.#>) ({player}/<entity>|...) (cause:<cause>) (source:<entity>) (source_once)");
        this.setRequiredArguments(0, 5);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("amount") && (arg.matchesFloat() || arg.matchesInteger())) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("source") && arg.matchesPrefix("source", "s") && arg.matchesArgumentType(EntityTag.class)) {
                scriptEntry.addObject("source", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("cause") && arg.matchesEnum((Enum<?>[])EntityDamageEvent.DamageCause.values())) {
                scriptEntry.addObject("cause", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("source_once") && arg.matches("source_once")) {
                scriptEntry.addObject("source_once", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new ElementTag(1.0));
        }
        if (!scriptEntry.hasObject("entities")) {
            ArrayList<EntityTag> entities = new ArrayList<EntityTag>();
            if (Utilities.getEntryPlayer(scriptEntry) != null) {
                entities.add(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity());
            } else if (Utilities.getEntryNPC(scriptEntry) != null) {
                entities.add(Utilities.getEntryNPC(scriptEntry).getDenizenEntity());
            } else {
                throw new InvalidArgumentsException("No valid target entities found.");
            }
            scriptEntry.addObject("entities", entities);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        EntityTag source = (EntityTag)scriptEntry.getObjectTag("source");
        ElementTag amountElement = scriptEntry.getElement("amount");
        ElementTag cause = scriptEntry.getElement("cause");
        ElementTag source_once = scriptEntry.getElement("source_once");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report(scriptEntry, this.getName(), amountElement.debug() + ArgumentHelper.debugList("entities", entities) + (source_once == null ? "" : source_once.debug()) + (cause == null ? "" : cause.debug()) + (source == null ? "" : source.debug()));
        }
        double amount = amountElement.asDouble();
        for (EntityTag entity : entities) {
            if (entity.getLivingEntity() == null) {
                Debug.echoDebug((Debuggable)scriptEntry, entity + " is not a living entity!");
                continue;
            }
            if (cause == null) {
                if (source == null) {
                    entity.getLivingEntity().damage(amount);
                    continue;
                }
                entity.getLivingEntity().damage(amount, source.getBukkitEntity());
                continue;
            }
            EntityDamageEvent.DamageCause causeEnum = EntityDamageEvent.DamageCause.valueOf((String)cause.asString().toUpperCase());
            EntityDamageEvent ede = source == null ? new EntityDamageEvent(entity.getBukkitEntity(), causeEnum, amount) : new EntityDamageByEntityEvent(source.getBukkitEntity(), entity.getBukkitEntity(), causeEnum, amount);
            Bukkit.getPluginManager().callEvent((Event)ede);
            if (ede.isCancelled()) continue;
            entity.getLivingEntity().setLastDamageCause(ede);
            if (source == null || source_once != null && source_once.asBoolean()) {
                entity.getLivingEntity().damage(ede.getFinalDamage());
            } else {
                entity.getLivingEntity().damage(ede.getFinalDamage(), source.getBukkitEntity());
            }
            entity.getLivingEntity().setLastDamageCause(ede);
        }
    }
}

