/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Sound;

public class PlaySoundCommand
extends AbstractCommand {
    public PlaySoundCommand() {
        this.setName("playsound");
        this.setSyntax("playsound (<location>|...) (<player>|...) [sound:<name>] (volume:<#.#>) (pitch:<#.#>) (custom) (sound_category:<category name>)");
        this.setRequiredArguments(2, 7);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        if (arg.startsWith("sound:")) {
            for (Sound sound : Sound.values()) {
                addOne.accept("sound:" + sound.name());
            }
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("volume") && arg.matchesFloat() && arg.matchesPrefix("volume", "v")) {
                scriptEntry.addObject("volume", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("pitch") && arg.matchesFloat() && arg.matchesPrefix("pitch", "p")) {
                scriptEntry.addObject("pitch", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("sound")) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("custom") && arg.matches("custom")) {
                scriptEntry.addObject("custom", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("sound_category") && arg.matchesPrefix("sound_category")) {
                scriptEntry.addObject("sound_category", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException("Missing sound argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("volume", new ElementTag(1));
        scriptEntry.defaultObject("pitch", new ElementTag(1));
        scriptEntry.defaultObject("custom", new ElementTag(false));
        scriptEntry.defaultObject("sound_category", new ElementTag("MASTER"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block16: {
            List locations = (List)scriptEntry.getObject("locations");
            List players = (List)scriptEntry.getObject("entities");
            ElementTag soundElement = scriptEntry.getElement("sound");
            ElementTag volumeElement = scriptEntry.getElement("volume");
            ElementTag pitchElement = scriptEntry.getElement("pitch");
            ElementTag custom = scriptEntry.getElement("custom");
            ElementTag sound_category = scriptEntry.getElement("sound_category");
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report(scriptEntry, this.getName(), (locations != null ? ArgumentHelper.debugObj("locations", locations.toString()) : "") + (players != null ? ArgumentHelper.debugObj("entities", players.toString()) : "") + soundElement.debug() + volumeElement.debug() + pitchElement.debug() + custom.debug());
            }
            String sound = soundElement.asString();
            float volume = volumeElement.asFloat();
            float pitch = pitchElement.asFloat();
            String category = sound_category.asString().toUpperCase();
            try {
                if (players == null) {
                    if (custom.asBoolean()) {
                        for (LocationTag location : locations) {
                            NMSHandler.getSoundHelper().playSound(null, (Location)location, sound, volume, pitch, category);
                        }
                    } else {
                        for (LocationTag location : locations) {
                            NMSHandler.getSoundHelper().playSound(null, (Location)location, Sound.valueOf((String)sound.toUpperCase()), volume, pitch, category);
                        }
                    }
                } else if (locations != null) {
                    for (LocationTag location : locations) {
                        for (PlayerTag player : players) {
                            if (custom.asBoolean()) {
                                NMSHandler.getSoundHelper().playSound(player.getPlayerEntity(), (Location)location, sound, volume, pitch, category);
                                continue;
                            }
                            NMSHandler.getSoundHelper().playSound(player.getPlayerEntity(), (Location)location, Sound.valueOf((String)sound.toUpperCase()), volume, pitch, category);
                        }
                    }
                } else {
                    for (PlayerTag player : players) {
                        if (custom.asBoolean()) {
                            NMSHandler.getSoundHelper().playSound(player.getPlayerEntity(), (Location)player.getLocation(), sound, volume, pitch, category);
                            continue;
                        }
                        NMSHandler.getSoundHelper().playSound(player.getPlayerEntity(), (Location)player.getLocation(), Sound.valueOf((String)sound.toUpperCase()), volume, pitch, category);
                    }
                }
            }
            catch (Exception e) {
                Debug.echoDebug((Debuggable)scriptEntry, "Unable to play sound.");
                if (!Debug.verbose) break block16;
                Debug.echoError(e);
            }
        }
    }
}

