/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.npc.traits.HealthTrait;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class HealthCommand
extends AbstractCommand {
    public HealthCommand() {
        this.setName("health");
        this.setSyntax("health ({npc}/<entity>|...) [<#>] (state:{true}/false/toggle) (heal)");
        this.setRequiredArguments(1, 4);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("target") && arg.matches("player")) {
                if (!Utilities.entryHasPlayer(scriptEntry)) {
                    throw new InvalidArgumentsException("No player attached!");
                }
                scriptEntry.addObject("target", Collections.singletonList(Utilities.getEntryPlayer(scriptEntry).getDenizenEntity()));
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesFloat()) {
                scriptEntry.addObject("quantity", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("target", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("state")) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("heal") && arg.matches("heal")) {
                scriptEntry.addObject("heal", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("quantity") && !scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a quantity!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsException("Missing NPC!");
            }
            scriptEntry.addObject("target", Collections.singletonList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()));
        }
        scriptEntry.defaultObject("heal", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag quantity = scriptEntry.getElement("quantity");
        ElementTag action = scriptEntry.getElement("action");
        ElementTag heal = scriptEntry.getElement("heal");
        List targets = (List)scriptEntry.getObject("target");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), (quantity != null ? quantity.debug() : "") + (action != null ? action.debug() : "") + heal.debug() + ArgumentHelper.debugObj("target", targets.toString()));
        }
        if (quantity == null && action == null) {
            Debug.echoError(scriptEntry.getResidingQueue(), "Null quantity!");
        }
        if (action == null) {
            action = new ElementTag(true);
        }
        for (EntityTag target : targets) {
            if (target.isCitizensNPC()) {
                if (action.asString().equalsIgnoreCase("true")) {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                } else if (action.asString().equalsIgnoreCase("false")) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                }
            }
            if (quantity == null) continue;
            if (target.isCitizensNPC()) {
                if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    HealthTrait trait = (HealthTrait)target.getDenizenNPC().getCitizen().getOrAddTrait(HealthTrait.class);
                    trait.setMaxhealth(quantity.asInt());
                    if (!heal.asBoolean()) continue;
                    trait.setHealth(quantity.asDouble());
                    continue;
                }
                Debug.echoError(scriptEntry.getResidingQueue(), "NPC doesn't have health trait!");
                continue;
            }
            if (target.isLivingEntity()) {
                target.getLivingEntity().setMaxHealth(quantity.asDouble());
                if (!heal.asBoolean()) continue;
                target.getLivingEntity().setHealth(quantity.asDouble());
                continue;
            }
            Debug.echoError(scriptEntry.getResidingQueue(), "Entity '" + target.identify() + "'is not alive!");
        }
    }
}

