/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.entity.Position;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;

public class MountCommand
extends AbstractCommand {
    public MountCommand() {
        this.setName("mount");
        this.setSyntax("mount (cancel) [<entity>|...] (<location>)");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        List<EntityTag> entities = null;
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel")) {
                scriptEntry.addObject("cancel", "");
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                scriptEntry.addObject("custom_location", new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                entities = arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry);
                scriptEntry.addObject("entities", entities);
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        if (!scriptEntry.hasObject("location")) {
            if (entities != null) {
                for (int i = entities.size() - 1; i >= 0; --i) {
                    if (!((EntityTag)entities.get(i)).isSpawned()) continue;
                    scriptEntry.defaultObject("location", entities.get(i).getLocation());
                    break;
                }
            }
            scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, true));
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        boolean hasCustomLocation = scriptEntry.hasObject("custom_location");
        List entities = (List)scriptEntry.getObject("entities");
        boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), cancel ? ArgumentHelper.debugObj("cancel", true) : "", location, ArgumentHelper.debugList("entities", entities));
        }
        if (!cancel) {
            for (EntityTag entity : entities) {
                if (entity.isSpawned() && !hasCustomLocation) continue;
                entity.spawnAt(location);
            }
            Position.mount(Conversion.convertEntities(entities));
        } else {
            Position.dismount(Conversion.convertEntities(entities));
        }
        ListTag entityList = new ListTag();
        entityList.addObjects(entities);
        scriptEntry.addObject("mounted_entities", entityList);
    }
}

