/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CreateCommand
extends AbstractCommand {
    public CreateCommand() {
        this.setName("create");
        this.setSyntax("create [<entity>] [<name>] (<location>) (traits:<trait>|...) (registry:<name>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(String arg, Consumer<String> addOne) {
        for (EntityType entity : EntityType.values()) {
            addOne.accept(entity.name());
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("entity_type") && arg.matchesArgumentType(EntityTag.class)) {
                EntityTag ent = arg.asType(EntityTag.class);
                if (!ent.isGeneric() && !ent.isCitizensNPC()) {
                    throw new InvalidArgumentsException("Entity supplied must be generic or a Citizens NPC!");
                }
                scriptEntry.addObject("entity_type", ent);
                continue;
            }
            if (!scriptEntry.hasObject("spawn_location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("spawn_location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("traits") && arg.matchesPrefix("t", "trait", "traits")) {
                scriptEntry.addObject("traits", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("registry") && arg.matchesPrefix("registry")) {
                scriptEntry.addObject("registry", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Must specify a name!");
        }
        if (!scriptEntry.hasObject("entity_type")) {
            throw new InvalidArgumentsException("Must specify an entity type!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        NPCTag created;
        ElementTag name = scriptEntry.getElement("name");
        EntityTag type = (EntityTag)scriptEntry.getObjectTag("entity_type");
        LocationTag loc = (LocationTag)scriptEntry.getObjectTag("spawn_location");
        ListTag traits = (ListTag)scriptEntry.getObjectTag("traits");
        ElementTag registry = scriptEntry.getElement("registry");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), name, type, loc, traits, registry);
        }
        if (!type.isGeneric() && type.isCitizensNPC()) {
            created = new NPCTag(type.getDenizenNPC().getCitizen().clone());
            created.getCitizen().setName(name.asString());
        } else {
            NPCRegistry actualRegistry = CitizensAPI.getNPCRegistry();
            if (registry != null && (actualRegistry = NPCTag.getRegistryByName(registry.asString())) == null) {
                actualRegistry = CitizensAPI.createNamedNPCRegistry((String)registry.asString(), (NPCDataStore)new MemoryNPCDataStore());
            }
            created = new NPCTag(actualRegistry.createNPC(type.getBukkitEntityType(), name.asString()));
        }
        scriptEntry.addObject("created_npc", created);
        if (created.isSpawned()) {
            if (loc != null) {
                created.getCitizen().teleport((Location)loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                created.getCitizen().despawn();
            }
        } else if (loc != null) {
            created.getCitizen().spawn((Location)loc);
        }
        if (traits != null) {
            for (String trait_name : traits) {
                Trait trait = CitizensAPI.getTraitFactory().getTrait(trait_name);
                if (trait != null) {
                    created.getCitizen().addTrait(trait);
                    continue;
                }
                Debug.echoError(scriptEntry.getResidingQueue(), "Could not add trait to NPC: " + trait_name);
            }
        }
        for (Mechanism mechanism : type.getWaitingMechanisms()) {
            created.safeAdjust(mechanism);
        }
    }
}

