/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.tags.core.EscapeTagBase;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.SQLEscaper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElementTag
implements ObjectTag {
    private final String element;
    private String prefix;
    public boolean isPlainText;
    public boolean isRawInput;
    static final BigDecimal max = new BigDecimal("10E1000");
    public static AsciiMatcher percentageMatcher = new AsciiMatcher("%");
    public static ObjectTagProcessor<ElementTag> tagProcessor = new ObjectTagProcessor();

    @Deprecated
    public static ElementTag valueOf(String string) {
        return ElementTag.valueOf(string, null);
    }

    @Fetchable(value="el")
    public static ElementTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        return new ElementTag(CoreUtilities.toLowerCase(string).startsWith("el@") ? string.substring(3) : string);
    }

    public static boolean matches(String string) {
        return string != null;
    }

    public static <T extends ObjectTag> T handleNull(String tag, T object, String type, boolean has_fallback) {
        if (object == null) {
            if (!has_fallback) {
                Debug.echoError("'" + tag + "' is an invalid " + type + "!");
            }
            return null;
        }
        return object;
    }

    public ElementTag(String string, boolean isPlain) {
        this(string);
        this.isPlainText = isPlain;
    }

    public ElementTag(String string) {
        this.prefix = "element";
        if (string == null) {
            if (Debug.verbose) {
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                    Debug.log("Element - Null construction!");
                }
            }
            this.element = "null";
        } else {
            this.element = string;
        }
    }

    public ElementTag(boolean bool) {
        this.prefix = "boolean";
        this.element = String.valueOf(bool);
        this.isPlainText = true;
    }

    public ElementTag(int integer) {
        this.prefix = "number";
        this.element = String.valueOf(integer);
        this.isPlainText = true;
    }

    public ElementTag(byte byt) {
        this.prefix = "number";
        this.element = String.valueOf(byt);
        this.isPlainText = true;
    }

    public ElementTag(short shrt) {
        this.prefix = "number";
        this.element = String.valueOf(shrt);
        this.isPlainText = true;
    }

    public ElementTag(long lng) {
        this.prefix = "number";
        this.element = String.valueOf(lng);
        this.isPlainText = true;
    }

    public ElementTag(BigDecimal bdl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.bigDecToString(bdl);
        this.isPlainText = true;
    }

    public ElementTag(double dbl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(dbl);
        this.isPlainText = true;
    }

    public ElementTag(float flt) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(flt);
        this.isPlainText = true;
    }

    public ElementTag(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = string;
    }

    private BigDecimal getBD(String text) {
        BigDecimal bd = new BigDecimal(text);
        if (bd.compareTo(max) >= 1) {
            Debug.echoError("Unreasonably large number detected!");
            return max;
        }
        return bd;
    }

    public BigDecimal asBigDecimal() {
        return this.getBD(percentageMatcher.trimToNonMatches(this.element));
    }

    public double asDouble() {
        return Double.parseDouble(percentageMatcher.trimToNonMatches(this.element));
    }

    public float asFloat() {
        return Float.parseFloat(percentageMatcher.trimToNonMatches(this.element));
    }

    public int asInt() {
        return (int)this.asLong();
    }

    public long asLong() {
        try {
            String cleaned = percentageMatcher.trimToNonMatches(this.element);
            int dot = cleaned.indexOf(46);
            if (dot > 0) {
                cleaned = cleaned.substring(0, dot);
            }
            return Long.parseLong(cleaned);
        }
        catch (NumberFormatException ex) {
            Debug.echoError("'" + this.element + "' is not a valid integer!");
            return 0L;
        }
    }

    public boolean asBoolean() {
        return CoreUtilities.equalsIgnoreCase(this.element, "true");
    }

    public String asString() {
        return this.element;
    }

    public boolean isBoolean() {
        return CoreUtilities.equalsIgnoreCase(this.element, "true") || CoreUtilities.equalsIgnoreCase(this.element, "false");
    }

    public boolean isDouble() {
        try {
            if (!Double.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isFloat() {
        try {
            if (!Float.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isInt() {
        try {
            return ArgumentHelper.matchesInteger(this.element);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isString() {
        return this.element != null && !this.element.isEmpty();
    }

    public boolean matchesType(Class<? extends ObjectTag> dClass) {
        return ObjectFetcher.checkMatch(dClass, this.element);
    }

    @Override
    public <T extends ObjectTag> T asType(Class<T> dClass, TagContext context) {
        return ObjectFetcher.getObjectFrom(dClass, this.element, context);
    }

    public boolean matchesEnum(Enum[] values) {
        for (Enum value : values) {
            if (!CoreUtilities.equalsIgnoreCase(value.name(), this.element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getObjectType() {
        return "Element";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String identify() {
        return this.element;
    }

    @Override
    public String savable() {
        if (this.element.indexOf(64) == -1) {
            return this.element;
        }
        return "el@" + this.element;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isTruthy() {
        if (this.element.equals("") || CoreUtilities.equalsIgnoreCase(this.element, "null") || CoreUtilities.equalsIgnoreCase(this.element, "false")) {
            return false;
        }
        if (ArgumentHelper.matchesDouble(this.element)) {
            try {
                if (this.asDouble() == 0.0) {
                    return false;
                }
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        return true;
    }

    public static void registerTags() {
        ElementTag.registerTag("equals", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(CoreUtilities.equalsIgnoreCase(object.asString(), attribute.getContext(1)));
        }, new String[0]);
        ElementTag.registerTag("is_more_than", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.asBigDecimal().compareTo(new ElementTag(attribute.getContext(1)).asBigDecimal()) > 0);
        }, new String[0]);
        ElementTag.registerTag("is_less_than", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.asBigDecimal().compareTo(new ElementTag(attribute.getContext(1)).asBigDecimal()) < 0);
        }, new String[0]);
        ElementTag.registerTag("is_more_than_or_equal_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.asBigDecimal().compareTo(new ElementTag(attribute.getContext(1)).asBigDecimal()) >= 0);
        }, new String[0]);
        ElementTag.registerTag("is_less_than_or_equal_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.asBigDecimal().compareTo(new ElementTag(attribute.getContext(1)).asBigDecimal()) <= 0);
        }, new String[0]);
        ElementTag.registerTag("is_boolean", (attribute, object) -> new ElementTag(object.isBoolean()), new String[0]);
        ElementTag.registerTag("is_integer", (attribute, object) -> {
            if (!ArgumentHelper.matchesInteger(object.element)) {
                return new ElementTag(false);
            }
            try {
                object.asLong();
                return new ElementTag(true);
            }
            catch (NumberFormatException ex) {
                return new ElementTag(false);
            }
        }, new String[0]);
        ElementTag.registerTag("is_decimal", (attribute, object) -> {
            if (!ArgumentHelper.matchesDouble(object.element)) {
                return new ElementTag(false);
            }
            try {
                return new ElementTag(object.asBigDecimal() != null);
            }
            catch (NumberFormatException ex) {
                return new ElementTag(false);
            }
        }, new String[0]);
        ElementTag.registerTag("is_odd", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(ArgumentHelper.matchesDouble(element) && object.asBigDecimal().longValue() % 2L != 0L);
        }, new String[0]);
        ElementTag.registerTag("is_even", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(ArgumentHelper.matchesDouble(element) && object.asBigDecimal().longValue() % 2L == 0L);
        }, new String[0]);
        ElementTag.registerTag("as_element", (attribute, object) -> object, "aselement");
        ElementTag.registerTag("as_boolean", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(element.equalsIgnoreCase("true") || element.equalsIgnoreCase("t") || element.equalsIgnoreCase("1"));
        }, "asboolean");
        ElementTag.registerTag("as_decimal", (attribute, object) -> {
            String element = object.element;
            try {
                return new ElementTag(Double.valueOf(element));
            }
            catch (NumberFormatException e) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("'" + element + "' is not a valid decimal number.");
                }
                return null;
            }
        }, "as_double", "asdouble");
        ElementTag.registerTag("as_int", (attribute, object) -> {
            Deprecations.elementAsIntTag.warn(attribute.context);
            String element = object.element;
            try {
                return new ElementTag(Double.valueOf(element).longValue());
            }
            catch (NumberFormatException e) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("'" + element + "' is not a valid decimal number.");
                }
                return null;
            }
        }, "asint");
        ElementTag.registerTag("truncate", (attribute, object) -> {
            try {
                return new ElementTag(object.asBigDecimal().longValue());
            }
            catch (NumberFormatException e) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("'" + object.element + "' is not a valid decimal number.");
                }
                return null;
            }
        }, new String[0]);
        ElementTag.registerTag("as_money", (attribute, object) -> {
            String element = object.element;
            try {
                DecimalFormat d = new DecimalFormat("0.00", CoreUtilities.decimalFormatSymbols);
                return new ElementTag(d.format(Double.valueOf(element)));
            }
            catch (NumberFormatException e) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("'" + element + "' is not a valid decimal number.");
                }
                return null;
            }
        }, "asmoney");
        ElementTag.registerTag("as_list", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, ListTag.valueOf(element, attribute.context), "ListTag", attribute.hasAlternative());
        }, "aslist");
        ElementTag.registerTag("as_map", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, MapTag.valueOf(element, attribute.context), "MapTag", attribute.hasAlternative());
        }, new String[0]);
        ElementTag.registerTag("as_custom", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, CustomObjectTag.valueOf(element, attribute.context), "Custom", attribute.hasAlternative());
        }, "ascustom");
        ElementTag.registerTag("as_script", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, ScriptTag.valueOf(element, attribute.context), "ScriptTag", attribute.hasAlternative());
        }, "asscript");
        ElementTag.registerTag("as_queue", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, QueueTag.valueOf(element, attribute.context), "QueueTag", attribute.hasAlternative());
        }, "asqueue");
        ElementTag.registerTag("as_duration", (attribute, object) -> {
            String element = object.element;
            return ElementTag.handleNull(element, DurationTag.valueOf(element, attribute.context), "DurationTag", attribute.hasAlternative());
        }, "asduration");
        ElementTag.registerTag("escaped", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(EscapeTagBase.escape(element));
        }, new String[0]);
        ElementTag.registerTag("sql_escaped", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(SQLEscaper.escapeSQL(element));
        }, new String[0]);
        ElementTag.registerTag("unescaped", (attribute, object) -> {
            String element = object.element;
            return new ElementTag(EscapeTagBase.unEscape(element));
        }, new String[0]);
        ElementTag.registerTag("parsed", (attribute, object) -> TagManager.tagObject(object.element, attribute.context), new String[0]);
        ElementTag.registerTag("difference", (attribute, object) -> {
            String element = object.element;
            String two = attribute.getContext(1);
            return new ElementTag(CoreUtilities.getLevenshteinDistance(element, two));
        }, new String[0]);
        ElementTag.registerTag("contains_any_case_sensitive_text", (attribute, object) -> {
            String element = object.element;
            ListTag list = attribute.contextAsType(1, ListTag.class);
            for (String list_element : list) {
                if (!element.contains(list_element)) continue;
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_any_case_sensitive_text", "contains_any_case_sensitive");
        ElementTag.registerTag("contains_any_text", (attribute, object) -> {
            String element = object.element;
            ListTag list = ListTag.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)), attribute.context);
            String ellow = CoreUtilities.toLowerCase(element);
            for (String list_element : list) {
                if (!ellow.contains(list_element)) continue;
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_any_text", "contains_any");
        ElementTag.registerTag("contains_case_sensitive_text", (attribute, object) -> {
            String element = object.element;
            String contains = attribute.getContext(1);
            if (element.contains(contains)) {
                return new ElementTag("true");
            }
            return new ElementTag("false");
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_case_sensitive_text", "contains_case_sensitive");
        ElementTag.registerTag("contains_text", (attribute, object) -> {
            String element = object.element;
            String contains = attribute.getContext(1);
            if (CoreUtilities.toLowerCase(contains).startsWith("regex:")) {
                if (Pattern.compile(contains.substring("regex:".length()), 2).matcher(element).find()) {
                    return new ElementTag("true");
                }
                return new ElementTag("false");
            }
            if (CoreUtilities.toLowerCase(element).contains(CoreUtilities.toLowerCase(contains))) {
                return new ElementTag("true");
            }
            return new ElementTag("false");
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_text", "contains");
        ElementTag.registerTag("contains_all_text", (attribute, object) -> {
            String element = object.element;
            ListTag list = ListTag.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)), attribute.context);
            String ellow = CoreUtilities.toLowerCase(element);
            for (String list_element : list) {
                if (ellow.contains(list_element)) continue;
                return new ElementTag("false");
            }
            return new ElementTag("true");
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_all_text", "contains_all");
        ElementTag.registerTag("contains_all_case_sensitive_text", (attribute, object) -> {
            String element = object.element;
            ListTag list = attribute.contextAsType(1, ListTag.class);
            for (String list_element : list) {
                if (element.contains(list_element)) continue;
                return new ElementTag("false");
            }
            return new ElementTag("true");
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("contains_all_case_sensitive_text", "contains_all_case_sensitive");
        ElementTag.registerTag("ends_with", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.element).endsWith(CoreUtilities.toLowerCase(attribute.getContext(1)))), "endswith");
        ElementTag.registerTag("equals_case_sensitive", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.element.equals(attribute.getContext(1)));
        }, "equals_with_case");
        ElementTag.registerTag("advanced_matches_text", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(ScriptEvent.createMatcher(attribute.getContext(1)).doesMatch(object.element));
        }, "advanced_matches");
        ElementTag.registerTag("regex_matches", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            return new ElementTag(object.element.matches(attribute.getContext(1)));
        }, "matches");
        ElementTag.registerTag("regex", (attribute, object) -> {
            if (!attribute.hasContext(1) || !attribute.hasContext(2)) {
                return null;
            }
            String regex = attribute.getContext(1);
            Matcher m = Pattern.compile(regex).matcher(object.element);
            if (!m.matches()) {
                return null;
            }
            int group = new ElementTag(attribute.getContext(2)).asInt();
            if (group < 0) {
                group = 0;
            }
            if (group > m.groupCount()) {
                group = m.groupCount();
            }
            attribute.fulfill(1);
            return new ElementTag(m.group(group));
        }, new String[0]);
        ElementTag.registerTag("is_in", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                return null;
            }
            ListTag list = attribute.contextAsType(1, ListTag.class);
            for (String element : list) {
                if (!CoreUtilities.equalsIgnoreCase(element, object.asString())) continue;
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        ElementTag.registerTag("length", (attribute, object) -> new ElementTag(object.element.length()), new String[0]);
        ElementTag.registerTag("not", (attribute, object) -> new ElementTag(!object.element.equalsIgnoreCase("true")), new String[0]);
        ElementTag.registerTag("and", (attribute, object) -> new ElementTag(object.element.equalsIgnoreCase("true") && attribute.getContext(1).equalsIgnoreCase("true")), new String[0]);
        ElementTag.registerTag("or", (attribute, object) -> new ElementTag(object.element.equalsIgnoreCase("true") || attribute.getContext(1).equalsIgnoreCase("true")), new String[0]);
        ElementTag.registerTag("xor", (attribute, object) -> new ElementTag(object.element.equalsIgnoreCase("true") != attribute.getContext(1).equalsIgnoreCase("true")), new String[0]);
        ElementTag.registerTag("starts_with", (attribute, object) -> new ElementTag(CoreUtilities.toLowerCase(object.element).startsWith(CoreUtilities.toLowerCase(attribute.getContext(1)))), "startswith");
        ElementTag.registerTag("index_of", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.index_of[...] must have a value.");
                return null;
            }
            return new ElementTag(CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1);
        }, new String[0]);
        ElementTag.registerTag("last_index_of", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.last_index_of[...] must have a value.");
                return null;
            }
            return new ElementTag(CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1);
        }, new String[0]);
        ElementTag.registerTag("char_at", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.char_at[...] must have a value.");
                return null;
            }
            int index = attribute.getIntContext(1) - 1;
            if (index < 0 || index >= object.element.length()) {
                return null;
            }
            return new ElementTag(String.valueOf(object.element.charAt(index)));
        }, new String[0]);
        ElementTag.registerTag("repeat", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.repeat[...] must have a value.");
                return null;
            }
            int repeatTimes = attribute.getIntContext(1);
            StringBuilder result = new StringBuilder(object.element.length() * repeatTimes);
            for (int i = 0; i < repeatTimes; ++i) {
                result.append(object.element);
            }
            return new ElementTag(result.toString());
        }, new String[0]);
        ElementTag.registerTag("repeat_as_list", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.repeat_as_list[...] must have a value.");
                return null;
            }
            int repeatTimes = attribute.getIntContext(1);
            ListTag result = new ListTag();
            for (int i = 0; i < repeatTimes; ++i) {
                result.addObject(object);
            }
            return result;
        }, new String[0]);
        ElementTag.registerTag("after_last", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.after_last[...] must have a value.");
                return null;
            }
            String delimiter = attribute.getContext(1);
            if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                return new ElementTag(object.element.substring(CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length()));
            }
            return new ElementTag("");
        }, new String[0]);
        ElementTag.registerTag("after", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.after[...] must have a value.");
                return null;
            }
            String delimiter = attribute.getContext(1);
            if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                return new ElementTag(object.element.substring(CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length()));
            }
            return new ElementTag("");
        }, new String[0]);
        ElementTag.registerTag("before_last", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.before_last[...] must have a value.");
                return null;
            }
            String delimiter = attribute.getContext(1);
            if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                return new ElementTag(object.element.substring(0, CoreUtilities.toLowerCase(object.element).lastIndexOf(CoreUtilities.toLowerCase(delimiter))));
            }
            return new ElementTag(object.element);
        }, new String[0]);
        ElementTag.registerTag("before", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.before[...] must have a value.");
                return null;
            }
            String delimiter = attribute.getContext(1);
            if (CoreUtilities.toLowerCase(object.element).contains(CoreUtilities.toLowerCase(delimiter))) {
                return new ElementTag(object.element.substring(0, CoreUtilities.toLowerCase(object.element).indexOf(CoreUtilities.toLowerCase(delimiter))));
            }
            return new ElementTag(object.element);
        }, new String[0]);
        ElementTag.registerTag("replace_text", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.replace[...] must have a value.");
                return null;
            }
            String replace = attribute.getContext(1);
            String replacement = "";
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                replacement = attribute.getContext(2);
                if (replacement == null) {
                    attribute.echoError("The tag ElementTag.replace[...].with[...] must have a value.");
                    return null;
                }
                attribute.fulfill(1);
            }
            if (replace.startsWith("regex:")) {
                return new ElementTag(object.element.replaceAll(replace.substring("regex:".length()), replacement));
            }
            if (replace.startsWith("firstregex:")) {
                return new ElementTag(object.element.replaceFirst(replace.substring("firstregex:".length()), replacement));
            }
            return new ElementTag(object.element.replaceAll("(?i)" + Pattern.quote(replace), Matcher.quoteReplacement(replacement)));
        }, new String[0]);
        tagProcessor.registerFutureTagDeprecation("replace_text", "replace");
        ElementTag.registerTag("format_number", (attribute, object) -> {
            try {
                String afterdecimal;
                String shortelement;
                if (attribute.hasContext(1)) {
                    DecimalFormat format = new DecimalFormat(attribute.getContext(1), CoreUtilities.decimalFormatSymbols);
                    return new ElementTag(format.format(object.asBigDecimal()));
                }
                int decimal = object.element.indexOf(46);
                if (decimal != -1) {
                    shortelement = object.element.substring(0, decimal);
                    afterdecimal = object.element.substring(decimal);
                } else {
                    shortelement = object.element;
                    afterdecimal = "";
                }
                String intform = Long.valueOf(shortelement.replace("%", "")).toString();
                String negative = "";
                if (intform.startsWith("-")) {
                    negative = "-";
                    intform = intform.substring(1);
                }
                for (int i = intform.length() - 3; i > 0; i -= 3) {
                    intform = intform.substring(0, i) + "," + intform.substring(i);
                }
                return new ElementTag(negative + intform + afterdecimal);
            }
            catch (Exception ex) {
                attribute.echoError(ex);
                return null;
            }
        }, new String[0]);
        ElementTag.registerTag("to_list", (attribute, object) -> {
            ListTag list = new ListTag();
            for (int i = 0; i < object.element.length(); ++i) {
                list.add(String.valueOf(object.element.charAt(i)));
            }
            return list;
        }, new String[0]);
        ElementTag.registerTag("trim", (attribute, object) -> new ElementTag(object.element.trim()), new String[0]);
        ElementTag.registerTag("split_lines", (attribute, object) -> {
            int characterCount = attribute.getIntContext(1);
            return new ElementTag(CoreUtilities.splitLinesByCharacterCount(object.element, characterCount));
        }, new String[0]);
        ElementTag.registerTag("is_uppercase", (attribute, object) -> {
            for (char c : object.element.toCharArray()) {
                if (Character.isUpperCase(c)) continue;
                return new ElementTag(false);
            }
            return new ElementTag(true);
        }, new String[0]);
        ElementTag.registerTag("is_lowercase", (attribute, object) -> {
            for (char c : object.element.toCharArray()) {
                if (Character.isLowerCase(c)) continue;
                return new ElementTag(false);
            }
            return new ElementTag(true);
        }, new String[0]);
        ElementTag.registerTag("to_uppercase", (attribute, object) -> new ElementTag(object.element.toUpperCase()), "upper");
        ElementTag.registerTag("to_lowercase", (attribute, object) -> new ElementTag(object.element.toLowerCase()), "lower");
        ElementTag.registerTag("to_titlecase", (attribute, object) -> {
            if (object.element.length() == 0) {
                return new ElementTag("");
            }
            StringBuilder TitleCase = new StringBuilder(object.element.length());
            String Upper = object.element.toUpperCase();
            String Lower = object.element.toLowerCase();
            TitleCase.append(Upper.charAt(0));
            for (int i = 1; i < object.element.length(); ++i) {
                if (object.element.charAt(i - 1) == ' ') {
                    TitleCase.append(Upper.charAt(i));
                    continue;
                }
                TitleCase.append(Lower.charAt(i));
            }
            return new ElementTag(TitleCase.toString());
        }, "totitlecase");
        ElementTag.registerTag("to_sentence_case", (attribute, object) -> {
            if (object.element.length() == 0) {
                return new ElementTag("");
            }
            return new ElementTag(Character.toUpperCase(object.element.charAt(0)) + object.element.substring(1).toLowerCase());
        }, new String[0]);
        ElementTag.registerTag("substring", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.substring[...] must have a value.");
                return null;
            }
            int beginning_index = new ElementTag(attribute.getContext(1).split(",")[0]).asInt() - 1;
            int ending_index = attribute.getContext(1).split(",").length > 1 ? new ElementTag(attribute.getContext(1).split(",")[1]).asInt() : object.element.length();
            if (beginning_index < 0) {
                beginning_index = 0;
            }
            if (beginning_index > object.element.length()) {
                beginning_index = object.element.length();
            }
            if (ending_index > object.element.length()) {
                ending_index = object.element.length();
            }
            if (ending_index < beginning_index) {
                ending_index = beginning_index;
            }
            return new ElementTag(object.element.substring(beginning_index, ending_index));
        }, "substr");
        ElementTag.registerTag("split_args", (attribute, object) -> new ListTag(Arrays.asList(ArgumentHelper.buildArgs(object.element))), new String[0]);
        ElementTag.registerTag("split", (attribute, object) -> {
            String[] split;
            String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            if ((split_string = CoreUtilities.toLowerCase(split_string).startsWith("regex:") ? split_string.split(":", 2)[1] : "(?i)" + Pattern.quote(split_string)).isEmpty()) {
                attribute.echoError("Cannot split over empty value. Did you mean to use 'to_list'?");
            }
            if (attribute.startsWith("limit", 2)) {
                int limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
                attribute.fulfill(1);
                split = object.element.split(split_string, limit);
            } else {
                split = object.element.split(split_string);
            }
            return new ListTag(Arrays.asList(split));
        }, new String[0]);
        ElementTag.registerTag("pad_left", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.pad_left[...] must have a value.");
                return null;
            }
            String with = CoreUtilities.NBSP;
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = String.valueOf(attribute.getContext(2).charAt(0));
                attribute.fulfill(1);
            }
            StringBuilder padded = new StringBuilder();
            length -= object.element.length();
            while (padded.length() < length) {
                padded.append(with);
            }
            padded.append(object.element);
            return new ElementTag(padded.toString());
        }, new String[0]);
        ElementTag.registerTag("pad_right", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.pad_right[...] must have a value.");
                return null;
            }
            String with = CoreUtilities.NBSP;
            int length = attribute.getIntContext(1);
            if (attribute.startsWith("with", 2) && attribute.hasContext(2)) {
                with = String.valueOf(attribute.getContext(2).charAt(0));
                attribute.fulfill(1);
            }
            StringBuilder padded = new StringBuilder(object.element);
            while (padded.length() < length) {
                padded.append(with);
            }
            return new ElementTag(padded.toString());
        }, new String[0]);
        ElementTag.registerTag("abs", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.abs(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("max", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.max(ele.asDouble(), new ElementTag(attribute.getContext(1)).asDouble()));
        }, new String[0]);
        ElementTag.registerTag("min", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.min(ele.asDouble(), new ElementTag(attribute.getContext(1)).asDouble()));
        }, new String[0]);
        ElementTag.registerTag("add_int", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(ele.asLong() + attribute.getLongContext(1));
        }, new String[0]);
        ElementTag.registerTag("div_int", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(ele.asLong() / attribute.getLongContext(1));
        }, new String[0]);
        ElementTag.registerTag("mul_int", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(ele.asLong() * attribute.getLongContext(1));
        }, new String[0]);
        ElementTag.registerTag("sub_int", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(ele.asLong() - attribute.getLongContext(1));
        }, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> addRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.add[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new ElementTag(object.asBigDecimal().add(object.getBD(attribute.getContext(1))));
            }
            catch (Throwable e) {
                return new ElementTag(object.asDouble() + attribute.getDoubleContext(1));
            }
        };
        ElementTag.registerTag("add", addRunnable, new String[0]);
        ElementTag.registerTag("+", addRunnable, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> divRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.div[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new ElementTag(object.asBigDecimal().divide(object.getBD(attribute.getContext(1)), 64, RoundingMode.HALF_UP));
            }
            catch (Throwable e) {
                return new ElementTag(object.asDouble() / attribute.getDoubleContext(1));
            }
        };
        ElementTag.registerTag("div", divRunnable, new String[0]);
        ElementTag.registerTag("/", divRunnable, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> modRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.mod[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new ElementTag(object.asBigDecimal().remainder(object.getBD(attribute.getContext(1))));
            }
            catch (Throwable e) {
                return new ElementTag(object.asDouble() % attribute.getDoubleContext(1));
            }
        };
        ElementTag.registerTag("mod", modRunnable, new String[0]);
        ElementTag.registerTag("%", modRunnable, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> mulRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.mul[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new ElementTag(object.asBigDecimal().multiply(object.getBD(attribute.getContext(1))));
            }
            catch (Throwable e) {
                return new ElementTag(object.asDouble() * attribute.getDoubleContext(1));
            }
        };
        ElementTag.registerTag("mul", mulRunnable, new String[0]);
        ElementTag.registerTag("*", mulRunnable, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> subRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.sub[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            try {
                return new ElementTag(object.asBigDecimal().subtract(object.getBD(attribute.getContext(1))));
            }
            catch (Throwable e) {
                return new ElementTag(object.asDouble() - attribute.getDoubleContext(1));
            }
        };
        ElementTag.registerTag("sub", subRunnable, new String[0]);
        ElementTag.registerTag("-", subRunnable, new String[0]);
        ElementTag.registerTag("sqrt", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            if (ele.asDouble() < 0.0) {
                return null;
            }
            return new ElementTag(Math.sqrt(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("log", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.log[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.log(object.asDouble()) / Math.log(attribute.getDoubleContext(1)));
        }, new String[0]);
        ElementTag.registerTag("ln", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.log(ele.asDouble()));
        }, new String[0]);
        TagRunnable.ObjectInterface<ElementTag> powerRunnable = (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.power[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.pow(object.asDouble(), attribute.getDoubleContext(1)));
        };
        ElementTag.registerTag("power", powerRunnable, new String[0]);
        ElementTag.registerTag("^", powerRunnable, new String[0]);
        ElementTag.registerTag("asin", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.asin(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("acos", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.acos(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("atan", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.atan(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("atan2", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.atan2[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.atan2(object.asDouble(), attribute.getDoubleContext(1)));
        }, new String[0]);
        ElementTag.registerTag("cos", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.cos(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("sin", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.sin(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("tan", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.tan(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("factorial", (attribute, ele) -> {
            if (!ele.isInt()) {
                attribute.echoError("Element '" + ele + "' is not a valid number!");
                return null;
            }
            int count = ele.asInt();
            BigInteger result = BigInteger.ONE;
            for (int i = 2; i <= count; ++i) {
                result = result.multiply(BigInteger.valueOf(i));
            }
            return new ElementTag(result.toString());
        }, new String[0]);
        ElementTag.registerTag("to_degrees", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.toDegrees(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("to_radians", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.toRadians(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("round_up", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag((long)Math.ceil(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("round_down", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag((long)Math.floor(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("round_to", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.round_to[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            int ten = (int)Math.pow(10.0, attribute.getIntContext(1));
            return new ElementTag((double)Math.round(object.asDouble() * (double)ten) / (double)ten);
        }, new String[0]);
        ElementTag.registerTag("round_to_precision", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.round_to_precision[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            double precision = attribute.getDoubleContext(1);
            return new ElementTag((double)Math.round(object.asDouble() / precision) * precision);
        }, new String[0]);
        ElementTag.registerTag("round_down_to_precision", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.round_down_to_precision[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            double precision = attribute.getDoubleContext(1);
            return new ElementTag(Math.floor(object.asDouble() / precision) * precision);
        }, new String[0]);
        ElementTag.registerTag("round_up_to_precision", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.round_up_to_precision[...] must have a value.");
                return null;
            }
            if (!object.isDouble()) {
                attribute.echoError("Element '" + object + "' is not a valid decimal number!");
                return null;
            }
            double precision = attribute.getDoubleContext(1);
            return new ElementTag(Math.ceil(object.asDouble() / precision) * precision);
        }, new String[0]);
        ElementTag.registerTag("round", (attribute, ele) -> {
            if (!ele.isDouble()) {
                attribute.echoError("Element '" + ele + "' is not a valid decimal number!");
                return null;
            }
            return new ElementTag(Math.round(ele.asDouble()));
        }, new String[0]);
        ElementTag.registerTag("number_to_hex", (attribute, object) -> {
            if (!object.isInt()) {
                attribute.echoError("Element '" + object + "' is not a valid number!");
                return null;
            }
            return new ElementTag(Long.toHexString(object.asLong()));
        }, new String[0]);
        ElementTag.registerTag("hex_to_number", (attribute, object) -> {
            if (!ArgumentHelper.HEX_MATCHER.isOnlyMatches(object.element)) {
                attribute.echoError("Element '" + object + "' is not a valid hexadecimal number!");
                return null;
            }
            return new ElementTag(Long.parseLong(object.element, 16));
        }, new String[0]);
        ElementTag.registerTag("base64_encode", (attribute, object) -> {
            String encoded = Base64.getEncoder().encodeToString(object.element.getBytes(StandardCharsets.UTF_8));
            return new ElementTag(encoded);
        }, new String[0]);
        ElementTag.registerTag("base64_decode", (attribute, object) -> {
            String decoded = new String(Base64.getDecoder().decode(object.element));
            return new ElementTag(decoded);
        }, new String[0]);
        ElementTag.registerTag("hex_encode", (attribute, object) -> {
            String encoded = CoreUtilities.hexEncode(object.element.getBytes());
            return new ElementTag(encoded);
        }, new String[0]);
        ElementTag.registerTag("hex_decode", (attribute, object) -> {
            String decoded = new String(CoreUtilities.hexDecode(object.element));
            return new ElementTag(decoded);
        }, new String[0]);
        ElementTag.registerTag("url_encode", (attribute, object) -> {
            try {
                String encoded = URLEncoder.encode(object.element, "UTF-8");
                return new ElementTag(encoded);
            }
            catch (Exception e) {
                attribute.echoError(e);
                return null;
            }
        }, new String[0]);
        ElementTag.registerTag("url_decode", (attribute, object) -> {
            try {
                String decoded = URLDecoder.decode(object.element, "UTF-8");
                return new ElementTag(decoded);
            }
            catch (Exception e) {
                attribute.echoError(e);
                return null;
            }
        }, new String[0]);
        ElementTag.registerTag("matches_character_set", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.matches_character_set[...] must have a value.");
                return null;
            }
            return new ElementTag(new AsciiMatcher(attribute.getContext(1)).isOnlyMatches(object.element));
        }, new String[0]);
        ElementTag.registerTag("trim_to_character_set", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag ElementTag.trim_to_character_set[...] must have a value.");
                return null;
            }
            return new ElementTag(new AsciiMatcher(attribute.getContext(1)).trimToMatches(object.element));
        }, new String[0]);
        ElementTag.registerTag("if_true", (attribute, object) -> {
            if (!(attribute.hasContext(1) && attribute.startsWith("if_false", 2) && attribute.hasContext(2))) {
                attribute.echoError("ElementTag.if_true[...].if_false[...] malformed and missing at least one required part.");
                return null;
            }
            ObjectTag result = attribute.getContextObject(object.asBoolean() ? 1 : 2);
            attribute.fulfill(1);
            return result;
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<ElementTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ElementTag)) {
            return false;
        }
        ElementTag other = (ElementTag)o;
        return this.element.equals(other.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public ObjectTag getNextObjectTypeDown() {
        return new FailedObjectTag();
    }

    public static class FailedObjectTag
    implements ObjectTag {
        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public boolean isUnique() {
            return false;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public String identify() {
            return null;
        }

        @Override
        public String identifySimple() {
            return null;
        }

        @Override
        public ObjectTag setPrefix(String prefix) {
            return null;
        }

        @Override
        public ObjectTag getObjectAttribute(Attribute attribute) {
            if (Debug.verbose) {
                Debug.log("Element - Unfilled! Null!");
            }
            return null;
        }
    }
}

