/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ItemColor
extends ItemProperty<ColorTag> {
    public static boolean describes(ItemTag item) {
        return item.getItemMeta() instanceof LeatherArmorMeta || item.getItemMeta() instanceof MapMeta || item.getItemMeta() instanceof PotionMeta;
    }

    @Override
    public ColorTag getPropertyValue() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            return BukkitColorExtensions.fromColor(leatherArmorMeta.getColor());
        }
        itemMeta = this.getItemMeta();
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            if (!mapMeta.hasColor()) {
                return null;
            }
            return BukkitColorExtensions.fromColor(mapMeta.getColor());
        }
        itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            if (!potionMeta.hasColor()) {
                return null;
            }
            return BukkitColorExtensions.fromColor(potionMeta.getColor());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ColorTag color, Mechanism mechanism) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            leatherArmorMeta.setColor(BukkitColorExtensions.getColor(color));
            this.setItemMeta((ItemMeta)leatherArmorMeta);
            return;
        }
        itemMeta = this.getItemMeta();
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            mapMeta.setColor(BukkitColorExtensions.getColor(color));
            this.setItemMeta((ItemMeta)mapMeta);
            return;
        }
        this.editMeta(PotionMeta.class, meta -> meta.setColor(BukkitColorExtensions.getColor(color)));
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    public static void register() {
        PropertyParser.registerTag(ItemColor.class, ColorTag.class, "color", (attribute, item) -> {
            PotionMeta potionMeta;
            ItemMeta patt2790$temp = item.getItemMeta();
            if (patt2790$temp instanceof PotionMeta && !(potionMeta = (PotionMeta)patt2790$temp).hasColor()) {
                return BukkitColorExtensions.fromColor(Color.WHITE);
            }
            return item.getPropertyValue();
        }, "dye_color");
        PropertyParser.registerMechanism(ItemColor.class, ColorTag.class, "color", (item, mechanism, color) -> item.setPropertyValue((ColorTag)color, mechanism), "dye", "dye_color");
    }
}

