/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerEquipsArmorScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HashMap<String, PlayerArmorChangeEvent.SlotType> slotsByName = new HashMap();
    public static HashMap<PlayerArmorChangeEvent.SlotType, String> namesBySlot = new HashMap();
    public static PlayerEquipsArmorScriptEvent instance;
    public ItemTag oldItem;
    public ItemTag newItem;
    public PlayerArmorChangeEvent.SlotType slot;
    public PlayerTag player;

    public static void registerSlot(String name, PlayerArmorChangeEvent.SlotType slot) {
        slotsByName.put(name, slot);
        namesBySlot.put(slot, name);
    }

    public PlayerEquipsArmorScriptEvent() {
        instance = this;
        PlayerEquipsArmorScriptEvent.registerSlot("helmet", PlayerArmorChangeEvent.SlotType.HEAD);
        PlayerEquipsArmorScriptEvent.registerSlot("chestplate", PlayerArmorChangeEvent.SlotType.CHEST);
        PlayerEquipsArmorScriptEvent.registerSlot("leggings", PlayerArmorChangeEvent.SlotType.LEGS);
        PlayerEquipsArmorScriptEvent.registerSlot("boots", PlayerArmorChangeEvent.SlotType.FEET);
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player equips ") || path.eventLower.startsWith("player unequips ");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String type = path.eventArgLowerAt(1);
        String itemCompare = path.eventArgLowerAt(2);
        PlayerArmorChangeEvent.SlotType slotType = slotsByName.get(itemCompare);
        if (slotType != null && this.slot != slotType) {
            return false;
        }
        return !(type.equals("equips") ? (slotType != null ? this.newItem.getMaterial().getMaterial() == Material.AIR : !itemCompare.equals("armor") && !this.tryItem(this.newItem, itemCompare)) : (slotType != null ? this.oldItem.getMaterial().getMaterial() == Material.AIR : !itemCompare.equals("armor") && !this.tryItem(this.oldItem, itemCompare)));
    }

    public String getName() {
        return "PlayerEquipsArmor";
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        if (name.equals("new_item")) {
            return this.newItem;
        }
        if (name.equals("old_item")) {
            return this.oldItem;
        }
        if (name.equals("slot")) {
            return new ElementTag(namesBySlot.get(this.slot));
        }
        return super.getContext(name);
    }

    @EventHandler
    public void armorChangeEvent(PlayerArmorChangeEvent event) {
        this.newItem = new ItemTag(event.getNewItem());
        this.oldItem = new ItemTag(event.getOldItem());
        this.slot = event.getSlotType();
        this.player = new PlayerTag(event.getPlayer());
        this.fire((Event)event);
    }
}

