/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_12.impl.blocks;

import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_12.impl.jnbt.CompoundTagImpl;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;

public class BlockDataImpl
implements BlockData {
    private Material material;
    private byte data;
    CompoundTagImpl ctag = null;

    public BlockDataImpl() {
    }

    public BlockDataImpl(Material mat, byte dat) {
        this.material = mat;
        this.data = dat;
    }

    public BlockDataImpl(Block block) {
        this.material = block.getType();
        this.data = block.getData();
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
        if (te != null) {
            NBTTagCompound compound = new NBTTagCompound();
            te.save(compound);
            this.ctag = (CompoundTagImpl)CompoundTagImpl.fromNMSTag(compound);
        }
    }

    public void setBlock(Block block, boolean physics) {
        block.setTypeIdAndData(this.material.getId(), this.data, physics);
        if (this.ctag != null) {
            CompoundTagBuilder builder = this.ctag.createBuilder();
            builder.putInt("x", block.getX());
            builder.putInt("y", block.getY());
            builder.putInt("z", block.getZ());
            this.ctag = (CompoundTagImpl)builder.build();
            BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
            TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos);
            te.load(this.ctag.toNMSTag());
        }
    }

    public String toCompressedFormat() {
        return "{" + this.material.getId() + ":" + this.data + "}";
    }

    public static BlockData fromCompressedString(String str) {
        BlockDataImpl data = new BlockDataImpl();
        String inner = str.substring(1, str.length() - 1);
        String[] datas = inner.split(":");
        data.setMaterial(Material.getMaterial((int)Integer.parseInt(datas[0])));
        data.setData(Byte.parseByte(datas[1]));
        if (data.getMaterial() == null) {
            throw new RuntimeException("Null material: " + datas[0]);
        }
        return data;
    }

    public CompoundTag getCompoundTag() {
        return this.ctag;
    }

    public void setCompoundTag(CompoundTag tag) {
        this.ctag = (CompoundTagImpl)tag;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public byte getData() {
        return this.data;
    }

    public void setData(byte data) {
        this.data = data;
    }
}

