/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.impl.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.EnumSkyBlock;
import net.minecraft.server.v1_13_R2.IBlockAccess;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.IWorldAccess;
import net.minecraft.server.v1_13_R2.ParticleParam;
import net.minecraft.server.v1_13_R2.PlayerChunkMap;
import net.minecraft.server.v1_13_R2.SoundCategory;
import net.minecraft.server.v1_13_R2.SoundEffect;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BlockLightImpl
extends BlockLight {
    private static final Method playerChunkMethod;
    private static final Field dirtyCountField;
    private static final BukkitTask bukkitTask;
    private static final Set<UUID> worlds;
    private final CraftWorld craftWorld;
    private final WorldServer worldServer;
    private final BlockPosition position;

    private BlockLightImpl(Location location, long ticks) {
        super(location, ticks);
        this.craftWorld = (CraftWorld)location.getWorld();
        this.worldServer = this.craftWorld.getHandle();
        if (!worlds.contains(this.craftWorld.getUID())) {
            IWorldAccess access = BlockLightImpl.getIWorldAccess((World)this.craftWorld);
            this.worldServer.addIWorldAccess(access);
            worlds.add(this.craftWorld.getUID());
        }
        this.position = new BlockPosition(this.block.getX(), this.block.getY(), this.block.getZ());
    }

    public static BlockLight createLight(Location location, int lightLevel, long ticks) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = (BlockLight)lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            blockLight.reset(true);
            blockLight.removeLater(ticks);
        } else {
            blockLight = new BlockLightImpl(location, ticks);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunk)) {
                lightsByChunk.put(blockLight.chunk, new ArrayList());
            }
            ((List)lightsByChunk.get(blockLight.chunk)).add(blockLight);
        }
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    public void update(int lightLevel, boolean updateChunk) {
        if (this.currentLight == lightLevel) {
            return;
        }
        if (this.originalLight == lightLevel) {
            this.worldServer.c(EnumSkyBlock.BLOCK, this.position);
        } else {
            this.worldServer.a(EnumSkyBlock.BLOCK, this.position, lightLevel);
            Block adjacentAir = null;
            for (BlockFace face : adjacentFaces) {
                Block possible;
                if (this.position.getY() == 0 && face == BlockFace.DOWN || this.position.getY() == this.craftWorld.getMaxHeight() - 1 && face == BlockFace.UP || (possible = this.block.getRelative(face)).getType() != Material.AIR) continue;
                adjacentAir = possible;
                break;
            }
            if (adjacentAir != null) {
                this.worldServer.r(new BlockPosition(adjacentAir.getX(), adjacentAir.getY(), adjacentAir.getZ()));
            }
            this.cachedLight = lightLevel;
        }
        if (updateChunk) {
            BlockLightImpl.updateChunk(this.chunk, this.worldServer.getPlayerChunkMap());
        }
        this.currentLight = lightLevel;
    }

    private static void updateChunk(Chunk chunk, PlayerChunkMap playerChunkMap) {
        int cX = chunk.getX();
        int cZ = chunk.getZ();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Object pChunk = BlockLightImpl.getPlayerChunk(playerChunkMap, cX + x, cZ + z);
                if (pChunk == null) continue;
                BlockLightImpl.setDirtyCount(pChunk);
            }
        }
    }

    private static Object getPlayerChunk(PlayerChunkMap map, int x, int z) {
        try {
            return playerChunkMethod.invoke((Object)map, x, z);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    private static void setDirtyCount(Object playerChunk) {
        try {
            int dirtyCount = dirtyCountField.getInt(playerChunk);
            if (dirtyCount > 0 && dirtyCount < 64) {
                dirtyCountField.set(playerChunk, 64);
            }
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
    }

    private static IWorldAccess getIWorldAccess(World world) {
        final PlayerChunkMap map = ((CraftWorld)world).getHandle().getPlayerChunkMap();
        return new IWorldAccess(){

            public void a(IBlockAccess iBlockAccess, BlockPosition blockPosition, IBlockData iBlockData, IBlockData iBlockData1, int i) {
            }

            public void a(BlockPosition position) {
                map.flagDirty(position);
            }

            public void a(int i, int i1, int i2, int i3, int i4, int i5) {
            }

            public void a(@Nullable EntityHuman entityHuman, SoundEffect soundEffect, SoundCategory soundCategory, double v, double v1, double v2, float v3, float v4) {
            }

            public void a(SoundEffect soundEffect, BlockPosition blockPosition) {
            }

            public void a(ParticleParam particleParam, boolean b, double v, double v1, double v2, double v3, double v4, double v5) {
            }

            public void a(ParticleParam particleParam, boolean b, boolean b1, double v, double v1, double v2, double v3, double v4, double v5) {
            }

            public void a(Entity entity) {
            }

            public void b(Entity entity) {
            }

            public void a(int i, BlockPosition blockPosition, int i1) {
            }

            public void a(EntityHuman entityHuman, int i, BlockPosition blockPosition, int i1) {
            }

            public void b(int i, BlockPosition blockPosition, int i1) {
            }
        };
    }

    static {
        worlds = new HashSet<UUID>();
        Method pcm = null;
        Field dcf = null;
        try {
            pcm = PlayerChunkMap.class.getDeclaredMethod("c", Integer.TYPE, Integer.TYPE);
            pcm.setAccessible(true);
            dcf = pcm.getReturnType().getDeclaredField("dirtyCount");
            dcf.setAccessible(true);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
        playerChunkMethod = pcm;
        dirtyCountField = dcf;
        bukkitTask = new BukkitRunnable(){

            public void run() {
                for (Map.Entry entry : lightsByChunk.entrySet()) {
                    List blockLights;
                    Chunk chunk = (Chunk)entry.getKey();
                    if (!chunk.isLoaded() || (blockLights = (List)entry.getValue()).isEmpty()) continue;
                    PlayerChunkMap playerChunkMap = ((BlockLightImpl)((Object)blockLights.get(0))).worldServer.getPlayerChunkMap();
                    for (BlockLight light : blockLights) {
                        light.reset(false);
                    }
                    BlockLightImpl.updateChunk(chunk, playerChunkMap);
                    for (BlockLight light : blockLights) {
                        light.update(light.cachedLight, false);
                    }
                    BlockLightImpl.updateChunk(chunk, playerChunkMap);
                }
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 5L, 5L);
    }
}

