/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_13.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.HashMap;
import net.minecraft.server.v1_13_R2.GameProfileSerializer;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ItemHelperImpl
extends ItemHelper {
    public String getInternalNameFromMaterial(Material material) {
        return "minecraft:" + CoreUtilities.toLowerCase((String)material.name());
    }

    public Material getMaterialFromInternalName(String internalName) {
        return Material.matchMaterial((String)internalName);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).A().getChatModifier().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        NBTTagCompound tag;
        net.minecraft.server.v1_13_R2.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10) && (profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        NBTTagCompound tag = (nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack)).hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
        nmsItemStack.setTag(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.setTag(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.hasTag()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.getTag());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.server.v1_13_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.setTag(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)nmsItemStack);
    }

    public PotionEffect getPotionEffect(PotionEffectType type, int duration, int amplifier, boolean ambient, boolean particles, Color color, boolean icon) {
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }
}

