/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.BlockData;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.BoundingBox;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_13.impl.blocks.BlockDataImpl;
import com.denizenscript.denizen.nms.v1_13.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.utilities.DenizenAPI;
import com.denizenscript.denizen.utilities.Utilities;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.v1_13_R2.AxisAlignedBB;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.ChatHoverable;
import net.minecraft.server.v1_13_R2.CombatMath;
import net.minecraft.server.v1_13_R2.DamageSource;
import net.minecraft.server.v1_13_R2.DataWatcherRegistry;
import net.minecraft.server.v1_13_R2.EnchantmentManager;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.EntityInsentient;
import net.minecraft.server.v1_13_R2.EntityLiving;
import net.minecraft.server.v1_13_R2.EntityPlayer;
import net.minecraft.server.v1_13_R2.EntityTracker;
import net.minecraft.server.v1_13_R2.EntityTrackerEntry;
import net.minecraft.server.v1_13_R2.EnumHand;
import net.minecraft.server.v1_13_R2.EnumMonsterType;
import net.minecraft.server.v1_13_R2.EnumMoveType;
import net.minecraft.server.v1_13_R2.GenericAttributes;
import net.minecraft.server.v1_13_R2.ItemStack;
import net.minecraft.server.v1_13_R2.MovingObjectPosition;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NavigationAbstract;
import net.minecraft.server.v1_13_R2.PathEntity;
import net.minecraft.server.v1_13_R2.Vec3D;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_HOVER_TEXT_GETTER = ReflectionHelper.getMethodHandle(Entity.class, (String)"bC", (Class[])new Class[0]);
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();

    public double getAbsorption(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().getAbsorptionHearts();
    }

    public void setAbsorption(LivingEntity entity, double value) {
        ((CraftLivingEntity)entity).getHandle().setAbsorptionHearts((float)value);
    }

    public double getDamageTo(LivingEntity attacker, org.bukkit.entity.Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().getMonsterType() : EnumMonsterType.UNDEFINED;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((ItemStack)CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source = attacker instanceof Player ? DamageSource.playerAttack((EntityHuman)((CraftPlayer)attacker).getHandle()) : DamageSource.mobAttack((EntityLiving)((CraftLivingEntity)attacker).getHandle());
            Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.isInvulnerable(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.getArmorStrength(), (float)((float)livingTarget.getAttributeInstance(GenericAttributes.h).getValue()));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.getArmorItems(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public String getRawHoverText(org.bukkit.entity.Entity entity) {
        try {
            ChatHoverable hoverable = ENTITY_HOVER_TEXT_GETTER.invoke(((CraftEntity)entity).getHandle());
            return hoverable.b().getText();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getArrowPickupStatus(org.bukkit.entity.Entity entity) {
        return ((Arrow)entity).getPickupStatus().name();
    }

    public void setArrowPickupStatus(org.bukkit.entity.Entity entity, String status) {
        ((Arrow)entity).setPickupStatus(Arrow.PickupStatus.valueOf((String)status));
    }

    public double getArrowDamage(org.bukkit.entity.Entity arrow) {
        return ((Arrow)arrow).getDamage();
    }

    public void setArrowDamage(org.bukkit.entity.Entity arrow, double damage) {
        ((Arrow)arrow).setDamage(damage);
    }

    public void setCarriedItem(Enderman entity, org.bukkit.inventory.ItemStack item) {
        entity.setCarriedBlock(Bukkit.createBlockData((Material)item.getType()));
    }

    public void setRiptide(org.bukkit.entity.Entity entity, boolean state) {
        ((CraftEntity)entity).getHandle().getDataWatcher().set(DataWatcherRegistry.a.a(6), (Object)((byte)(state ? 4 : 0)));
    }

    public int getBodyArrows(org.bukkit.entity.Entity entity) {
        return (Integer)((CraftEntity)entity).getHandle().getDataWatcher().get(DataWatcherRegistry.b.a(10));
    }

    public void setBodyArrows(org.bukkit.entity.Entity entity, int numArrows) {
        ((CraftEntity)entity).getHandle().getDataWatcher().set(DataWatcherRegistry.b.a(10), (Object)numArrows);
    }

    public org.bukkit.entity.Entity getFishHook(PlayerFishEvent event) {
        return event.getHook();
    }

    public org.bukkit.inventory.ItemStack getItemFromTrident(org.bukkit.entity.Entity entity) {
        return CraftItemStack.asBukkitCopy((ItemStack)((CraftTrident)entity).getHandle().trident);
    }

    public void setItemForTrident(org.bukkit.entity.Entity entity, org.bukkit.inventory.ItemStack item) {
        ((CraftTrident)entity).getHandle().trident = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item);
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().interact((World)((CraftWorld)location.getWorld()).getHandle(), pos, (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.MAIN_HAND, null, 0.0f, 0.0f, 0.0f);
    }

    public org.bukkit.entity.Entity getEntity(org.bukkit.World world, UUID uuid) {
        Entity entity = ((CraftWorld)world).getHandle().getEntity(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void setTarget(Creature entity, LivingEntity target) {
        EntityLiving nmsTarget = target != null ? ((CraftLivingEntity)target).getHandle() : null;
        ((CraftCreature)entity).getHandle().setGoalTarget(nmsTarget, EntityTargetEvent.TargetReason.CUSTOM, true);
        entity.setTarget(target);
    }

    public CompoundTag getNbtData(org.bukkit.entity.Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().c(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(org.bukkit.entity.Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().f(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(org.bukkit.entity.Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        ((EntityInsentient)nmsEntity).getNavigation().q();
    }

    public double getSpeed(org.bukkit.entity.Entity entity) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
    }

    public void setSpeed(org.bukkit.entity.Entity entity, double speed) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
    }

    public void follow(final org.bukkit.entity.Entity target, final org.bukkit.entity.Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.q();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract entityNavigation = nmsEntity.getNavigation();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            nmsEntity.onGround = true;
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ())) != null) {
            entityNavigation.a(path, 1.0);
            entityNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).b();
            nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (entityNavigation.p() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(oldSpeed);
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public void sendHidePacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            this.ensurePlayerHiding();
            pl.hidePlayer((Plugin)DenizenAPI.getCurrentInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
            Entity other = ((CraftEntity)entity).getHandle();
            EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
            }
        }
    }

    public void sendShowPacket(Player pl, org.bukkit.entity.Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)DenizenAPI.getCurrentInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.playerConnection != null && !craftPlayer.equals((Object)entity)) {
            EntityTracker tracker = ((WorldServer)craftPlayer.getHandle().world).tracker;
            Entity other = ((CraftEntity)entity).getHandle();
            EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(other.getId());
            if (entry != null) {
                entry.clear(entityPlayer);
                entry.updatePlayer(entityPlayer);
            }
        }
    }

    public void rotate(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            Location location = entity.getLocation();
            location.setYaw(yaw);
            location.setPitch(pitch);
            entity.teleport(location);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = this.normalizeYaw(yaw - 180.0f);
            }
            this.look(entity, yaw, pitch);
        } else {
            Entity handle = ((CraftEntity)entity).getHandle();
            handle.yaw = yaw;
            handle.pitch = pitch;
        }
    }

    public float getBaseYaw(org.bukkit.entity.Entity entity) {
        Entity handle = ((CraftEntity)entity).getHandle();
        return ((EntityLiving)handle).aR;
    }

    public void look(org.bukkit.entity.Entity entity, float yaw, float pitch) {
        Entity handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.yaw = yaw;
            if (handle instanceof EntityLiving) {
                EntityLiving livingHandle = (EntityLiving)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aR = yaw;
                if (!(handle instanceof EntityHuman)) {
                    livingHandle.aQ = yaw;
                }
                livingHandle.aS = yaw;
            }
            handle.pitch = pitch;
        }
    }

    private static MovingObjectPosition rayTrace(org.bukkit.World world, Vector start, Vector end) {
        return ((CraftWorld)world).getHandle().rayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()));
    }

    public boolean canTrace(org.bukkit.World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.type == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public EntityHelper.MapTraceResult mapTrace(LivingEntity from, double range) {
        Location start = from.getEyeLocation();
        Vector startVec = start.toVector();
        double xzLen = Math.cos((double)(start.getPitch() % 360.0f) * (Math.PI / 180));
        double nx = xzLen * Math.sin((double)(-start.getYaw()) * (Math.PI / 180));
        double ny = Math.sin((double)start.getPitch() * (Math.PI / 180));
        double nz = xzLen * Math.cos((double)start.getYaw() * (Math.PI / 180));
        Vector endVec = startVec.clone().add(new Vector(nx, -ny, nz).multiply(range));
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, endVec);
        if (l == null || l.pos == null) {
            return null;
        }
        Vector finalVec = new Vector(l.pos.x, l.pos.y, l.pos.z);
        EntityHelper.MapTraceResult mtr = new EntityHelper.MapTraceResult();
        switch (l.direction) {
            case NORTH: {
                mtr.angle = BlockFace.NORTH;
                break;
            }
            case SOUTH: {
                mtr.angle = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                mtr.angle = BlockFace.EAST;
                break;
            }
            case WEST: {
                mtr.angle = BlockFace.WEST;
            }
        }
        Vector hit = finalVec.clone().subtract(endVec.clone().subtract(startVec).normalize().multiply(0.072));
        mtr.hitLocation = new Location(start.getWorld(), hit.getX(), hit.getY(), hit.getZ());
        return mtr;
    }

    public Location rayTraceBlock(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.pos != null) {
            return new Location(start.getWorld(), l.pos.x - (double)l.direction.getAdjacentX() * 0.05, l.pos.y - (double)l.direction.getAdjacentY() * 0.05, l.pos.z - (double)l.direction.getAdjacentZ() * 0.05);
        }
        return null;
    }

    public Location rayTrace(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.pos != null) {
            return new Location(start.getWorld(), l.pos.x, l.pos.y, l.pos.z);
        }
        return null;
    }

    public Location getImpactNormal(Location start, Vector direction, double range) {
        Vector startVec = start.toVector();
        MovingObjectPosition l = EntityHelperImpl.rayTrace(start.getWorld(), startVec, startVec.clone().add(direction.multiply(range)));
        if (l != null && l.direction != null) {
            return new Location(start.getWorld(), (double)l.direction.getAdjacentX(), (double)l.direction.getAdjacentY(), (double)l.direction.getAdjacentZ());
        }
        return null;
    }

    public void move(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().move(EnumMoveType.SELF, vector.getX(), vector.getY(), vector.getZ());
    }

    public void teleport(org.bukkit.entity.Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().setPosition(vector.getX(), vector.getY(), vector.getZ());
    }

    public BoundingBox getBoundingBox(org.bukkit.entity.Entity entity) {
        AxisAlignedBB boundingBox = ((CraftEntity)entity).getHandle().getBoundingBox();
        Vector position = new Vector(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        Vector size = new Vector(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        return new BoundingBox(position, size);
    }

    public void setBoundingBox(org.bukkit.entity.Entity entity, BoundingBox boundingBox) {
        Vector low = boundingBox.getLow();
        Vector high = boundingBox.getHigh();
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(low.getX(), low.getY(), low.getZ(), high.getX(), high.getY(), high.getZ()));
    }

    public boolean isChestedHorse(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse;
    }

    public boolean isCarryingChest(org.bukkit.entity.Entity horse) {
        return horse instanceof ChestedHorse && ((ChestedHorse)horse).isCarryingChest();
    }

    public void setCarryingChest(org.bukkit.entity.Entity horse, boolean carrying) {
        if (horse instanceof ChestedHorse) {
            ((ChestedHorse)horse).setCarryingChest(carrying);
        }
    }

    public BlockData getBlockDataFor(FallingBlock entity) {
        return new BlockDataImpl(entity.getBlockData());
    }
}

