/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import java.util.List;
import net.minecraft.server.v1_13_R2.Enchantment;
import net.minecraft.server.v1_13_R2.EnchantmentManager;
import net.minecraft.server.v1_13_R2.Enchantments;
import net.minecraft.server.v1_13_R2.Entity;
import net.minecraft.server.v1_13_R2.EntityFishingHook;
import net.minecraft.server.v1_13_R2.EntityHuman;
import net.minecraft.server.v1_13_R2.EntityLiving;
import net.minecraft.server.v1_13_R2.LootTableInfo;
import net.minecraft.server.v1_13_R2.LootTables;
import net.minecraft.server.v1_13_R2.MathHelper;
import net.minecraft.server.v1_13_R2.StatisticList;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_13_R2.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        net.minecraft.server.v1_13_R2.ItemStack result = null;
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        if (catchType == FishingHelper.CatchType.DEFAULT) {
            float f = ((CraftWorld)fishHook.getWorld()).getHandle().random.nextFloat();
            int i = EnchantmentManager.g((EntityLiving)nmsHook.owner);
            int j = EnchantmentManager.a((Enchantment)Enchantments.LURE, (EntityLiving)nmsHook.owner);
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            result = f < f1 ? this.catchRandomJunk(nmsHook) : ((f -= f1) < f2 ? this.catchRandomTreasure(nmsHook) : this.catchRandomFish(nmsHook));
        } else if (catchType == FishingHelper.CatchType.JUNK) {
            result = this.catchRandomJunk(nmsHook);
        } else if (catchType == FishingHelper.CatchType.TREASURE) {
            result = this.catchRandomTreasure(nmsHook);
        } else if (catchType == FishingHelper.CatchType.FISH) {
            result = this.catchRandomFish(nmsHook);
        }
        if (result != null) {
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_13_R2.ItemStack)result);
        }
        return null;
    }

    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((World)nmsWorld, (EntityHuman)((CraftPlayer)player).getHandle());
        nmsWorld.addEntity((Entity)hook);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.server.v1_13_R2.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder(worldServer);
        playerFishEvent2.luck((float)EnchantmentManager.a((Enchantment)Enchantments.LUCK, (EntityLiving)fishHook.owner) + fishHook.owner.dJ());
        List itemStacks = fishHook.getWorld().getMinecraftServer().getLootTableRegistry().getLootTable(LootTables.aP).populateLoot(worldServer.random, playerFishEvent2.build());
        return (net.minecraft.server.v1_13_R2.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }

    private net.minecraft.server.v1_13_R2.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder((WorldServer)fishHook.getWorld());
        playerFishEvent2.luck((float)EnchantmentManager.a((Enchantment)Enchantments.LUCK, (EntityLiving)fishHook.owner) + fishHook.owner.dJ());
        List itemStacks = fishHook.getWorld().getMinecraftServer().getLootTableRegistry().getLootTable(LootTables.aQ).populateLoot(worldServer.random, playerFishEvent2.build());
        return (net.minecraft.server.v1_13_R2.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }

    private net.minecraft.server.v1_13_R2.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        fishHook.owner.a(StatisticList.FISH_CAUGHT, 1);
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder((WorldServer)fishHook.getWorld());
        playerFishEvent2.luck((float)EnchantmentManager.a((Enchantment)Enchantments.LUCK, (EntityLiving)fishHook.owner) + fishHook.owner.dJ());
        List itemStacks = fishHook.getWorld().getMinecraftServer().getLootTableRegistry().getLootTable(LootTables.aR).populateLoot(worldServer.random, playerFishEvent2.build());
        return (net.minecraft.server.v1_13_R2.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }
}

