/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_13.impl;

import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.EnumCreatureType;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlock;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    private final BiomeBase biomeBase;

    public BiomeNMSImpl(Biome biome) {
        super(biome);
        this.biomeBase = CraftBlock.biomeToBiomeBase((Biome)biome);
    }

    public float getHumidity() {
        return this.biomeBase.getHumidity();
    }

    public float getTemperature() {
        return this.biomeBase.getTemperature();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.AMBIENT);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.CREATURE);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.MONSTER);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.WATER_CREATURE);
    }

    public void setHumidity(float humidity) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"aO", (Object)this.biomeBase, (Object)Float.valueOf(humidity));
    }

    public void setTemperature(float temperature) {
        ReflectionHelper.setFieldValue(BiomeBase.class, (String)"aN", (Object)this.biomeBase, (Object)Float.valueOf(temperature));
    }

    protected boolean getDoesRain() {
        return this.biomeBase.c() == BiomeBase.Precipitation.RAIN;
    }

    protected boolean getDoesSnow() {
        return this.biomeBase.c() == BiomeBase.Precipitation.SNOW;
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        for (BiomeBase.BiomeMeta meta : this.biomeBase.getMobs(creatureType)) {
            try {
                String n = EntityTypes.getName((EntityTypes)meta.b).getKey();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }
}

