/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.helpers;

import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import net.minecraft.server.v1_14_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_14_R1.ChunkProviderServer;
import net.minecraft.server.v1_14_R1.HeightMap;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutMapChunk;
import net.minecraft.server.v1_14_R1.PlayerChunk;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_14_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;

public class ChunkHelper_v1_14_R1
implements ChunkHelper {
    public static final Field chunkProviderServerThreadField = (Field)ReflectionHelper.getFields(ChunkProviderServer.class).get("serverThread");
    public static final MethodHandle chunkProviderServerThreadFieldSetter = ReflectionHelper.getFinalSetter(ChunkProviderServer.class, (String)"serverThread");
    Thread resetServerThread;

    public void changeChunkServerThread(World world) {
        if (this.resetServerThread != null) {
            return;
        }
        ChunkProviderServer provider = ((CraftWorld)world).getHandle().getChunkProvider();
        try {
            this.resetServerThread = (Thread)chunkProviderServerThreadField.get(provider);
            chunkProviderServerThreadFieldSetter.invoke(provider, Thread.currentThread());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreServerThread(World world) {
        if (this.resetServerThread == null) {
            return;
        }
        ChunkProviderServer provider = ((CraftWorld)world).getHandle().getChunkProvider();
        try {
            chunkProviderServerThreadFieldSetter.invoke(provider, this.resetServerThread);
            this.resetServerThread = null;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void refreshChunkSections(Chunk chunk) {
        PacketPlayOutMapChunk lowPacket = new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 255);
        PacketPlayOutMapChunk highPacket = new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 65280);
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunk.getX(), chunk.getZ());
        PlayerChunk playerChunk = (PlayerChunk)((CraftWorld)chunk.getWorld()).getHandle().getChunkProvider().playerChunkMap.visibleChunks.get(pos.pair());
        if (playerChunk == null) {
            return;
        }
        playerChunk.players.a(pos, false).forEach(player -> {
            player.playerConnection.sendPacket((Packet)lowPacket);
            player.playerConnection.sendPacket((Packet)highPacket);
        });
    }

    public int[] getHeightMap(Chunk chunk) {
        long[] lightBlocking = ((HeightMap)((CraftChunk)chunk).getHandle().heightMap.get(HeightMap.Type.MOTION_BLOCKING)).a();
        int[] heightmap = new int[lightBlocking.length];
        for (int i = 0; i < lightBlocking.length; ++i) {
            heightmap[i] = (int)lightBlocking[i];
        }
        return heightmap;
    }
}

