/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.impl.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.util.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_14_R1.EnumSkyBlock;
import net.minecraft.server.v1_14_R1.LightEngine;
import net.minecraft.server.v1_14_R1.LightEngineBlock;
import net.minecraft.server.v1_14_R1.NibbleArray;
import net.minecraft.server.v1_14_R1.Packet;
import net.minecraft.server.v1_14_R1.PacketPlayOutBlockChange;
import net.minecraft.server.v1_14_R1.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlock;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BlockLight_v1_14_R1
extends BlockLight {
    private static final Field PACKETPLAYOUTLIGHTUPDATE_CHUNKX = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("a");
    private static final Field PACKETPLAYOUTLIGHTUPDATE_CHUNKZ = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("b");
    private static final Field PACKETPLAYOUTLIGHTUPDATE_BLOCKIGHT_BITMASK = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("d");
    private static final Field PACKETPLAYOUTLIGHTUPDATE_BLOCKIGHT_DATA = (Field)ReflectionHelper.getFields(PacketPlayOutLightUpdate.class).get("h");
    public static final Field PACKETPLAYOUTBLOCKCHANGE_POSITION = (Field)ReflectionHelper.getFields(PacketPlayOutBlockChange.class).get("a");
    public static boolean doNotCheck = false;
    public static final Vector[] RELATIVE_CHUNKS = new Vector[]{new Vector(0, 0, 0), new Vector(-1, 0, 0), new Vector(1, 0, 0), new Vector(0, 0, -1), new Vector(0, 0, 1), new Vector(-1, 0, -1), new Vector(-1, 0, 1), new Vector(1, 0, -1), new Vector(1, 0, 1)};

    private BlockLight_v1_14_R1(Location location, long ticks) {
        super(location, ticks);
    }

    public static BlockLight createLight(Location location, int lightLevel, long ticks) {
        BlockLight blockLight;
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            blockLight = (BlockLight)lightsByLocation.get(location);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
                blockLight.removeTask = null;
            }
            if (blockLight.updateTask != null) {
                blockLight.updateTask.cancel();
                blockLight.updateTask = null;
            }
            blockLight.removeLater(ticks);
        } else {
            blockLight = new BlockLight_v1_14_R1(location, ticks);
            lightsByLocation.put(location, blockLight);
            if (!lightsByChunk.containsKey(blockLight.chunk)) {
                lightsByChunk.put(blockLight.chunk, new ArrayList());
            }
            ((List)lightsByChunk.get(blockLight.chunk)).add(blockLight);
        }
        blockLight.intendedLevel = lightLevel;
        blockLight.update(lightLevel, true);
        return blockLight;
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutBlockChange packet, World world) {
        try {
            BlockPosition pos = (BlockPosition)PACKETPLAYOUTBLOCKCHANGE_POSITION.get(packet);
            int chunkX = pos.getX() >> 4;
            int chunkZ = pos.getZ() >> 4;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                Chunk chunk = world.getChunkAt(chunkX, chunkZ);
                boolean any = false;
                for (Vector vec : RELATIVE_CHUNKS) {
                    List lights;
                    Chunk other = world.getChunkIfLoaded(chunkX + vec.getBlockX(), chunkZ + vec.getBlockZ());
                    if (other == null || (lights = (List)lightsByChunk.get(other.bukkitChunk)) == null) continue;
                    any = true;
                    for (BlockLight light : lights) {
                        light.update(light.intendedLevel, false);
                    }
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLight_v1_14_R1.sendNearbyChunkUpdates(chunk), 1L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static void checkIfLightsBrokenByPacket(PacketPlayOutLightUpdate packet, World world) {
        if (doNotCheck) {
            return;
        }
        try {
            int cX = PACKETPLAYOUTLIGHTUPDATE_CHUNKX.getInt(packet);
            int cZ = PACKETPLAYOUTLIGHTUPDATE_CHUNKZ.getInt(packet);
            int bitMask = PACKETPLAYOUTLIGHTUPDATE_BLOCKIGHT_BITMASK.getInt(packet);
            List blockData = (List)PACKETPLAYOUTLIGHTUPDATE_BLOCKIGHT_DATA.get(packet);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> {
                Chunk chk = world.getChunkIfLoaded(cX, cZ);
                if (chk == null) {
                    return;
                }
                List lights = (List)lightsByChunk.get(chk.bukkitChunk);
                if (lights == null) {
                    return;
                }
                boolean any = false;
                for (BlockLight light : lights) {
                    if (!((BlockLight_v1_14_R1)light).checkIfChangedBy(bitMask, blockData)) continue;
                    light.update(light.intendedLevel, false);
                    any = true;
                }
                if (any) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)NMSHandler.getJavaPlugin(), () -> BlockLight_v1_14_R1.sendNearbyChunkUpdates(chk), 1L);
                }
            }, 1L);
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean checkIfChangedBy(int bitmask, List<byte[]> data) {
        Location blockLoc = this.block.getLocation();
        int layer = (blockLoc.getBlockY() >> 4) + 1;
        if ((bitmask & 1 << layer) == 0) {
            return false;
        }
        int found = 0;
        for (int i = 0; i < 16; ++i) {
            if ((bitmask & 1 << i) == 0) continue;
            if (i == layer) {
                int z;
                int y;
                int x;
                byte[] blocks = data.get(found);
                NibbleArray arr = new NibbleArray(blocks);
                int level = arr.a(x = blockLoc.getBlockX() - (this.chunk.getX() << 4), y = blockLoc.getBlockY() % 16, z = blockLoc.getBlockZ() - (this.chunk.getZ() << 4));
                return this.intendedLevel != level;
            }
            ++found;
        }
        return false;
    }

    public void reset(boolean updateChunk) {
        LightEngine lightEngine = ((CraftChunk)this.chunk).getHandle().e();
        LightEngineBlock engineBlock = (LightEngineBlock)lightEngine.a(EnumSkyBlock.BLOCK);
        engineBlock.a(((CraftBlock)this.block).getPosition());
        if (updateChunk) {
            this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
        }
    }

    public void update(int lightLevel, boolean updateChunk) {
        LightEngine lightEngine = ((CraftChunk)this.chunk).getHandle().e();
        LightEngineBlock engineBlock = (LightEngineBlock)lightEngine.a(EnumSkyBlock.BLOCK);
        engineBlock.a(((CraftBlock)this.block).getPosition());
        this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> {
            this.updateTask = null;
            engineBlock.a(((CraftBlock)this.block).getPosition(), lightLevel);
            if (updateChunk) {
                this.updateTask = Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), this::sendNearbyChunkUpdates, 1L);
            }
        }, 1L);
    }

    public void sendNearbyChunkUpdates() {
        BlockLight_v1_14_R1.sendNearbyChunkUpdates(((CraftChunk)this.chunk).getHandle());
    }

    public static void sendNearbyChunkUpdates(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.getPos();
        for (Vector vec : RELATIVE_CHUNKS) {
            Chunk other = chunk.getWorld().getChunkIfLoaded(pos.x + vec.getBlockX(), pos.z + vec.getBlockZ());
            if (other == null) continue;
            BlockLight_v1_14_R1.sendSingleChunkUpdate(other);
        }
    }

    public static void sendSingleChunkUpdate(Chunk chunk) {
        doNotCheck = true;
        LightEngine lightEngine = chunk.e();
        ChunkCoordIntPair pos = chunk.getPos();
        PacketPlayOutLightUpdate packet = new PacketPlayOutLightUpdate(pos, lightEngine);
        ((WorldServer)chunk.world).getChunkProvider().playerChunkMap.a(pos, false).forEach(player -> player.playerConnection.sendPacket((Packet)packet));
        doNotCheck = false;
    }
}

