/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_16.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ProfileEditorImpl
extends ProfileEditor {
    public static Field PLAYER_INFO_PLAYERDATA_LIST = (Field)ReflectionHelper.getFields(PacketPlayOutPlayerInfo.class).get("b");
    public static final Class playerInfoData;
    public static final Field playerInfoData_latency;
    public static final Field playerInfoData_gamemode;
    public static final Field playerInfoData_gameProfile;
    public static final Field playerInfoData_displayName;
    public static final MethodHandle playerInfoData_gameProfile_Setter;
    public static final Constructor playerInfoData_construct;

    protected void updatePlayer(Player player, final boolean isSkinChanging) {
        final EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        final UUID uuid = player.getUniqueId();
        PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(new int[]{entityPlayer.getId()});
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (p.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.sendPacket(p, (Packet)destroyPacket);
        }
        new BukkitRunnable(){

            public void run() {
                PacketPlayOutPlayerInfo playerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer});
                PacketPlayOutNamedEntitySpawn spawnPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    PacketHelperImpl.sendPacket(player, (Packet)playerInfo);
                    if (!player.getUniqueId().equals(uuid)) {
                        PacketHelperImpl.sendPacket(player, (Packet)spawnPacket);
                        continue;
                    }
                    if (isSkinChanging) {
                        ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(entityPlayer, (WorldServer)entityPlayer.world, true, player.getLocation(), false);
                    }
                    player.updateInventory();
                }
            }
        }.runTaskLater((Plugin)NMSHandler.getJavaPlugin(), 5L);
    }

    public static boolean handleAlteredProfiles(PacketPlayOutPlayerInfo packet, DenizenNetworkManagerImpl manager) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames()) {
            return true;
        }
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = (PacketPlayOutPlayerInfo.EnumPlayerInfoAction)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"a", (Object)packet);
        if (action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return true;
        }
        List dataList = (List)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"b", (Object)packet);
        if (dataList == null) {
            return true;
        }
        try {
            boolean any = false;
            for (Object data : dataList) {
                GameProfile gameProfile = (GameProfile)playerInfoData_gameProfile.get(data);
                if (!ProfileEditor.mirrorUUIDs.contains(gameProfile.getId()) && !RenameCommand.customNames.containsKey(gameProfile.getId())) continue;
                any = true;
            }
            if (!any) {
                return true;
            }
            GameProfile ownProfile = manager.player.getProfile();
            for (Object data : dataList) {
                GameProfile gameProfile = (GameProfile)playerInfoData_gameProfile.get(data);
                if (!ProfileEditor.mirrorUUIDs.contains(gameProfile.getId()) && !RenameCommand.customNames.containsKey(gameProfile.getId())) {
                    PacketPlayOutPlayerInfo newPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[0]);
                    List newPacketDataList = (List)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"b", (Object)newPacket);
                    newPacketDataList.add(data);
                    manager.oldManager.sendPacket((Packet)newPacket);
                    continue;
                }
                String rename = RenameCommand.getCustomNameFor((UUID)gameProfile.getId(), (Player)manager.player.getBukkitEntity());
                PacketPlayOutPlayerInfo newPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[0]);
                List newPacketDataList = (List)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"b", (Object)newPacket);
                GameProfile patchedProfile = new GameProfile(gameProfile.getId(), rename != null ? rename : gameProfile.getName());
                if (ProfileEditor.mirrorUUIDs.contains(gameProfile.getId())) {
                    patchedProfile.getProperties().putAll((Multimap)ownProfile.getProperties());
                } else {
                    patchedProfile.getProperties().putAll((Multimap)gameProfile.getProperties());
                }
                Object newData = playerInfoData_construct.newInstance(newPacket, patchedProfile, playerInfoData_latency.getInt(data), playerInfoData_gamemode.get(data), playerInfoData_displayName.get(data));
                newPacketDataList.add(newData);
                manager.oldManager.sendPacket((Packet)newPacket);
            }
            return false;
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
            return true;
        }
    }

    public static void updatePlayerProfiles(PacketPlayOutPlayerInfo packet) {
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = (PacketPlayOutPlayerInfo.EnumPlayerInfoAction)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"a", (Object)packet);
        if (action != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        List dataList = (List)ReflectionHelper.getFieldValue(PacketPlayOutPlayerInfo.class, (String)"b", (Object)packet);
        if (dataList != null) {
            try {
                for (Object data : dataList) {
                    GameProfile gameProfile = (GameProfile)playerInfoData_gameProfile.get(data);
                    if (!fakeProfiles.containsKey(gameProfile.getId())) continue;
                    playerInfoData_gameProfile_Setter.invoke(data, ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(gameProfile.getId())));
                }
            }
            catch (Throwable e) {
                Debug.echoError((Throwable)e);
            }
        }
    }

    private static GameProfile getGameProfile(PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        return gameProfile;
    }

    static {
        Class<?> pid = null;
        Field pidLatency = null;
        Field pidGamemode = null;
        Field pidGameProfile = null;
        Field pidDisplayName = null;
        Constructor<?> pidConstruct = null;
        try {
            for (Class<?> clzz : PacketPlayOutPlayerInfo.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase((String)clzz.getName()).contains("infodata")) continue;
                pid = clzz;
                pidLatency = clzz.getDeclaredField("b");
                pidLatency.setAccessible(true);
                pidGamemode = clzz.getDeclaredField("c");
                pidGamemode.setAccessible(true);
                pidGameProfile = clzz.getDeclaredField("d");
                pidGameProfile.setAccessible(true);
                pidDisplayName = clzz.getDeclaredField("e");
                pidDisplayName.setAccessible(true);
                pidConstruct = pid.getDeclaredConstructors()[0];
                pidConstruct.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        playerInfoData = pid;
        playerInfoData_latency = pidLatency;
        playerInfoData_gamemode = pidGamemode;
        playerInfoData_gameProfile = pidGameProfile;
        playerInfoData_displayName = pidDisplayName;
        playerInfoData_construct = pidConstruct;
        playerInfoData_gameProfile_Setter = ReflectionHelper.getFinalSetter(pid, (String)"d");
    }
}

