/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.impl.network.handlers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutEntityMetadata;
import com.denizenscript.denizen.nms.v1_16.Handler;
import com.denizenscript.denizen.nms.v1_16.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_16.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_16.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.handlers.FakeBlockHelper;
import com.denizenscript.denizen.nms.v1_16.impl.network.packets.PacketOutChatImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.packets.PacketOutEntityMetadataImpl;
import com.denizenscript.denizen.nms.v1_16.impl.network.packets.PacketOutSpawnEntityImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.scripts.commands.entity.SneakCommand;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.crypto.Cipher;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherObject;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumProtocol;
import net.minecraft.server.v1_16_R3.EnumProtocolDirection;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IChatMutableComponent;
import net.minecraft.server.v1_16_R3.MathHelper;
import net.minecraft.server.v1_16_R3.NetworkManager;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketDataSerializer;
import net.minecraft.server.v1_16_R3.PacketListener;
import net.minecraft.server.v1_16_R3.PacketPlayOutBlockBreak;
import net.minecraft.server.v1_16_R3.PacketPlayOutBlockChange;
import net.minecraft.server.v1_16_R3.PacketPlayOutChat;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R3.PacketPlayOutLightUpdate;
import net.minecraft.server.v1_16_R3.PacketPlayOutMapChunk;
import net.minecraft.server.v1_16_R3.PacketPlayOutMultiBlockChange;
import net.minecraft.server.v1_16_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_16_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityPainting;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.SectionPosition;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public final DenizenPacketHandler packetHandler;
    public static Field ENTITY_ID_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("a");
    public static Field ENTITY_ID_PACKVELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get("a");
    public static Field ENTITY_ID_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("a");
    public static Field ENTITY_ID_NAMEDENTSPAWN = (Field)ReflectionHelper.getFields(PacketPlayOutNamedEntitySpawn.class).get("a");
    public static Field ENTITY_ID_SPAWNENT = (Field)ReflectionHelper.getFields(PacketPlayOutSpawnEntity.class).get("a");
    public static Field ENTITY_ID_SPAWNENTLIVING = (Field)ReflectionHelper.getFields(PacketPlayOutSpawnEntityLiving.class).get("a");
    public static Field POS_X_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("b");
    public static Field POS_Y_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("c");
    public static Field POS_Z_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("d");
    public static Field YAW_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("e");
    public static Field PITCH_PACKTELENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get("f");
    public static Field POS_X_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("b");
    public static Field POS_Y_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("c");
    public static Field POS_Z_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("d");
    public static Field YAW_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("e");
    public static Field PITCH_PACKENT = (Field)ReflectionHelper.getFields(PacketPlayOutEntity.class).get("f");
    public static Field BLOCKPOS_BLOCKCHANGE = (Field)ReflectionHelper.getFields(PacketPlayOutBlockChange.class).get("a");
    public static Field SECTIONPOS_MULTIBLOCKCHANGE = (Field)ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get("a");
    public static Field OFFSETARRAY_MULTIBLOCKCHANGE = (Field)ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get("b");
    public static Field BLOCKARRAY_MULTIBLOCKCHANGE = (Field)ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get("c");
    public static Field CHUNKX_MAPCHUNK = (Field)ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get("a");
    public static Field CHUNKZ_MAPCHUNK = (Field)ReflectionHelper.getFields(PacketPlayOutMapChunk.class).get("b");
    public static Field BLOCKPOS_BLOCKBREAK = (Field)ReflectionHelper.getFields(PacketPlayOutBlockBreak.class).get("c");
    public static Field BLOCKDATA_BLOCKBREAK = (Field)ReflectionHelper.getFields(PacketPlayOutBlockBreak.class).get("d");
    public static Field ENTITY_METADATA_EID = (Field)ReflectionHelper.getFields(PacketPlayOutEntityMetadata.class).get("a");
    public static Field ENTITY_METADATA_LIST = (Field)ReflectionHelper.getFields(PacketPlayOutEntityMetadata.class).get("b");
    private boolean antiDuplicate = false;
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);
    private static final Field protocolDirectionField;
    private static final MethodHandle networkManagerField;

    public static void copyPacket(Packet<?> original, Packet<?> newPacket) {
        try {
            PacketDataSerializer copier = new PacketDataSerializer(Unpooled.buffer());
            original.b(copier);
            newPacket.a(copier);
        }
        catch (IOException ex) {
            com.denizenscript.denizen.utilities.debugging.Debug.echoError((Throwable)ex);
        }
    }

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager, DenizenPacketHandler packetHandler) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.channel = oldManager.channel;
        this.packetListener = new DenizenPacketListenerImpl(this, entityPlayer);
        oldManager.setPacketListener((PacketListener)this.packetListener);
        this.player = this.packetListener.player;
        this.packetHandler = packetHandler;
    }

    public static void setNetworkManager(Player player, DenizenPacketHandler packetHandler) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.playerConnection;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, playerConnection.networkManager, packetHandler));
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void setProtocol(EnumProtocol enumprotocol) {
        this.oldManager.setProtocol(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet packet) throws Exception {
        if (this.oldManager.channel.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPacketListener(PacketListener packetlistener) {
        this.oldManager.setPacketListener(packetlistener);
    }

    public static Object duplo(Object a) {
        try {
            Class<?> clazz = a.getClass();
            Object reter = clazz.newInstance();
            for (Field f : clazz.getDeclaredFields()) {
                f.setAccessible(true);
                f.set(reter, f.get(a));
            }
            Class<?> subc = clazz;
            while (subc.getSuperclass() != null) {
                subc = subc.getSuperclass();
                for (Field f : subc.getDeclaredFields()) {
                    f.setAccessible(true);
                    f.set(reter, f.get(a));
                }
            }
            return reter;
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public void sendPacket(Packet<?> packet) {
        this.sendPacket(packet, null);
    }

    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (NMSHandler.debugPackets) {
            Debug.log((String)("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.getName()));
        }
        if (this.processAttachToForPacket(packet) || this.processHiddenEntitiesForPacket(packet) || this.processPacketHandlerForPacket(packet) || this.processMirrorForPacket(packet) || this.processDisguiseForPacket(packet, genericfuturelistener) || this.processMetadataChangesForPacket(packet, genericfuturelistener) || this.processShowFakeForPacket(packet, genericfuturelistener)) {
            return;
        }
        this.processBlockLightForPacket(packet);
        this.oldManager.sendPacket(packet, genericfuturelistener);
    }

    public boolean processDisguiseForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (DisguiseCommand.disguises.isEmpty() || this.antiDuplicate) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntityMetadata) {
                PacketPlayOutEntityMetadata metadataPacket = (PacketPlayOutEntityMetadata)packet;
                int eid = ENTITY_METADATA_EID.getInt(metadataPacket);
                Entity ent = this.player.world.getEntity(eid);
                if (ent == null) {
                    return false;
                }
                HashMap playerMap = (HashMap)DisguiseCommand.disguises.get(ent.getUniqueID());
                if (playerMap == null) {
                    return false;
                }
                DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(this.player.getUniqueID());
                if (disguise == null && (disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null)) == null) {
                    return false;
                }
                if (ent.getId() == this.player.getId()) {
                    if (!disguise.shouldFake) {
                        return false;
                    }
                    ArrayList<DataWatcher.Item> data = (ArrayList<DataWatcher.Item>)ENTITY_METADATA_LIST.get(metadataPacket);
                    for (DataWatcher.Item item : data) {
                        DataWatcherObject watcherObject = item.a();
                        int watcherId = watcherObject.a();
                        if (watcherId != 0) continue;
                        PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata();
                        DenizenNetworkManagerImpl.copyPacket(metadataPacket, altPacket);
                        data = new ArrayList<DataWatcher.Item>(data);
                        ENTITY_METADATA_LIST.set(altPacket, data);
                        data.remove(item);
                        byte flags = (Byte)item.b();
                        flags = (byte)(flags | 0x20);
                        data.add(new DataWatcher.Item(watcherObject, (Object)flags));
                        PacketPlayOutEntityMetadata updatedPacket = this.getModifiedMetadataFor(altPacket);
                        this.oldManager.sendPacket((Packet)(updatedPacket == null ? altPacket : updatedPacket), genericfuturelistener);
                        return true;
                    }
                } else {
                    PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(ent.getId(), ((CraftEntity)disguise.toOthers.entity.entity).getHandle().getDataWatcher(), true);
                    this.oldManager.sendPacket((Packet)altPacket, genericfuturelistener);
                    return true;
                }
                return false;
            }
            int ider = -1;
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                ider = ENTITY_ID_NAMEDENTSPAWN.getInt(packet);
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                ider = ENTITY_ID_SPAWNENT.getInt(packet);
            } else if (packet instanceof PacketPlayOutSpawnEntityLiving) {
                ider = ENTITY_ID_SPAWNENTLIVING.getInt(packet);
            }
            if (ider != -1) {
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                HashMap playerMap = (HashMap)DisguiseCommand.disguises.get(e.getUniqueID());
                if (playerMap == null) {
                    return false;
                }
                DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(this.player.getUniqueID());
                if (disguise == null && (disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null)) == null) {
                    return false;
                }
                this.antiDuplicate = true;
                disguise.sendTo(Collections.singletonList(new PlayerTag((Player)this.player.getBukkitEntity())));
                this.antiDuplicate = false;
                return true;
            }
        }
        catch (Throwable ex) {
            this.antiDuplicate = false;
            Debug.echoError((Throwable)ex);
        }
        return false;
    }

    public PacketPlayOutEntityMetadata getModifiedMetadataFor(PacketPlayOutEntityMetadata metadataPacket) {
        if (!RenameCommand.hasAnyDynamicRenames() && SneakCommand.forceSetSneak.isEmpty()) {
            return null;
        }
        try {
            int eid = ENTITY_METADATA_EID.getInt(metadataPacket);
            Entity ent = this.player.world.getEntity(eid);
            if (ent == null) {
                return null;
            }
            String nameToApply = RenameCommand.getCustomNameFor((UUID)ent.getUniqueID(), (Player)this.player.getBukkitEntity(), (boolean)false);
            Boolean forceSneak = SneakCommand.shouldSneak((UUID)ent.getUniqueID(), (UUID)this.player.getUniqueID());
            if (nameToApply == null && forceSneak == null) {
                return null;
            }
            ArrayList<DataWatcher.Item> data = new ArrayList<DataWatcher.Item>((List)ENTITY_METADATA_LIST.get(metadataPacket));
            boolean any = false;
            for (int i = 0; i < data.size(); ++i) {
                DataWatcher.Item item = (DataWatcher.Item)data.get(i);
                DataWatcherObject watcherObject = item.a();
                int watcherId = watcherObject.a();
                if (watcherId == 0 && forceSneak != null) {
                    byte val = (Byte)item.b();
                    val = forceSneak != false ? (byte)(val | 2) : (byte)(val & 0xFFFFFFFD);
                    data.set(i, new DataWatcher.Item(watcherObject, (Object)val));
                    any = true;
                    continue;
                }
                if (watcherId == 2 && nameToApply != null) {
                    Optional<IChatMutableComponent> name = Optional.of(Handler.componentToNMS(FormattedTextHelper.parse((String)nameToApply, (ChatColor)ChatColor.WHITE)));
                    data.set(i, new DataWatcher.Item(watcherObject, name));
                    any = true;
                    continue;
                }
                if (watcherId != 3 || nameToApply == null) continue;
                data.set(i, new DataWatcher.Item(watcherObject, (Object)true));
                any = true;
            }
            if (!any) {
                return null;
            }
            PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata();
            DenizenNetworkManagerImpl.copyPacket(metadataPacket, altPacket);
            ENTITY_METADATA_LIST.set(altPacket, data);
            return altPacket;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public boolean processMetadataChangesForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (!(packet instanceof PacketPlayOutEntityMetadata)) {
            return false;
        }
        PacketPlayOutEntityMetadata altPacket = this.getModifiedMetadataFor((PacketPlayOutEntityMetadata)packet);
        if (altPacket == null) {
            return false;
        }
        this.oldManager.sendPacket((Packet)altPacket, genericfuturelistener);
        return true;
    }

    public void tryProcessMovePacketForAttach(Packet<?> packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.getUniqueID());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.getUniqueID());
                if (!attMap.attached.isValid() || att == null) continue;
                Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                ENTITY_ID_PACKENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (att.positionalOffset != null && (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove || packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook)) {
                    byte pitch;
                    byte yaw;
                    boolean isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook;
                    if (att.noRotate) {
                        Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle((float)attachedEntity.yaw);
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.pitch);
                    } else if (isRotate) {
                        yaw = YAW_PACKENT.getByte(packet);
                        pitch = PITCH_PACKENT.getByte(packet);
                    } else {
                        yaw = EntityAttachmentHelper.compressAngle((float)e.yaw);
                        pitch = EntityAttachmentHelper.compressAngle((float)e.pitch);
                    }
                    if (isRotate) {
                        yaw = EntityAttachmentHelper.adaptedCompressedAngle((byte)yaw, (float)att.positionalOffset.getYaw());
                        pitch = EntityAttachmentHelper.adaptedCompressedAngle((byte)pitch, (float)att.positionalOffset.getPitch());
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e.locX(), e.locY(), e.locZ()), e.yaw, e.pitch);
                    Vector oldPos = (Vector)att.visiblePositions.get(this.player.getUniqueID());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(this.player.getUniqueID(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e);
                        ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, att.attached.getBukkitEntity().getEntityId());
                        POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                        POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                        POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                        YAW_PACKTELENT.setByte(newTeleportPacket, yaw);
                        PITCH_PACKTELENT.setByte(newTeleportPacket, pitch);
                        this.oldManager.sendPacket((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.clamp((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, yaw);
                        PITCH_PACKENT.setByte(pNew, pitch);
                    }
                    this.oldManager.sendPacket(pNew);
                    continue;
                }
                this.oldManager.sendPacket(pNew);
            }
        }
        if (e.passengers != null && !e.passengers.isEmpty()) {
            for (Entity ent : e.passengers) {
                this.tryProcessMovePacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessVelocityPacketForAttach(Packet<?> packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.getUniqueID());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.getUniqueID());
                if (!attMap.attached.isValid() || att == null) continue;
                Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                this.oldManager.sendPacket(pNew);
            }
        }
        if (e.passengers != null && !e.passengers.isEmpty()) {
            for (Entity ent : e.passengers) {
                this.tryProcessVelocityPacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessTeleportPacketForAttach(Packet<?> packet, Entity e, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.getUniqueID());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.getUniqueID());
                if (!attMap.attached.isValid() || att == null) continue;
                Packet pNew = (Packet)DenizenNetworkManagerImpl.duplo(packet);
                ENTITY_ID_PACKTELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew)).add(relative);
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    resultPos = att.fixedForOffset(resultPos, e.yaw, e.pitch);
                    if (att.noRotate) {
                        Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle((float)attachedEntity.yaw);
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.pitch);
                    } else {
                        yaw = YAW_PACKTELENT.getByte(packet);
                        pitch = PITCH_PACKTELENT.getByte(packet);
                    }
                    yaw = EntityAttachmentHelper.adaptedCompressedAngle((byte)yaw, (float)att.positionalOffset.getYaw());
                    pitch = EntityAttachmentHelper.adaptedCompressedAngle((byte)pitch, (float)att.positionalOffset.getPitch());
                    POS_X_PACKTELENT.setDouble(pNew, resultPos.getX());
                    POS_Y_PACKTELENT.setDouble(pNew, resultPos.getY());
                    POS_Z_PACKTELENT.setDouble(pNew, resultPos.getZ());
                    YAW_PACKTELENT.setByte(pNew, yaw);
                    PITCH_PACKTELENT.setByte(pNew, pitch);
                }
                att.visiblePositions.put(this.player.getUniqueID(), resultPos.clone());
                this.oldManager.sendPacket(pNew);
            }
        }
        if (e.passengers != null && !e.passengers.isEmpty()) {
            for (Entity ent : e.passengers) {
                this.tryProcessTeleportPacketForAttach(packet, ent, new Vector(ent.locX() - e.locX(), ent.locY() - e.locY(), ent.locZ() - e.locZ()));
            }
        }
    }

    public boolean processAttachToForPacket(Packet<?> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                int ider = ENTITY_ID_PACKENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                this.tryProcessMovePacketForAttach(packet, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)this.player.getUniqueID(), (UUID)e.getUniqueID());
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                int ider = ENTITY_ID_PACKVELENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                this.tryProcessVelocityPacketForAttach(packet, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)this.player.getUniqueID(), (UUID)e.getUniqueID());
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                int ider = ENTITY_ID_PACKTELENT.getInt(packet);
                Entity e = this.player.getWorld().getEntity(ider);
                if (e == null) {
                    return false;
                }
                this.tryProcessTeleportPacketForAttach(packet, e, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)this.player.getUniqueID(), (UUID)e.getUniqueID());
            }
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
        return false;
    }

    public boolean isHidden(Entity entity) {
        return entity != null && NMSHandler.getEntityHelper().isHidden((Player)this.player.getBukkitEntity(), entity.getBukkitEntity().getUniqueId());
    }

    public boolean processHiddenEntitiesForPacket(Packet<?> packet) {
        if (EntityHelper.hiddenEntitiesEntPl.isEmpty()) {
            return false;
        }
        try {
            Entity e;
            if (packet instanceof PacketPlayOutNamedEntitySpawn || packet instanceof PacketPlayOutSpawnEntity || packet instanceof PacketPlayOutSpawnEntityLiving || packet instanceof PacketPlayOutSpawnEntityPainting || packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                PacketOutSpawnEntityImpl spawnEntity = new PacketOutSpawnEntityImpl(this.player, packet);
                Entity entity = this.player.getWorld().getEntity(spawnEntity.getEntityId());
                if (this.isHidden(entity)) {
                    return true;
                }
                this.processFakePlayerSpawn(entity);
            }
            int ider = -1;
            if (packet instanceof PacketPlayOutEntity) {
                ider = ENTITY_ID_PACKENT.getInt(packet);
            } else if (packet instanceof PacketPlayOutEntityMetadata) {
                ider = ENTITY_METADATA_EID.getInt(packet);
            } else if (packet instanceof PacketPlayOutEntityVelocity) {
                ider = ENTITY_ID_PACKVELENT.getInt(packet);
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                ider = ENTITY_ID_PACKTELENT.getInt(packet);
            }
            if (ider != -1 && this.isHidden(e = this.player.getWorld().getEntity(ider))) {
                return true;
            }
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
        return false;
    }

    public void processFakePlayerSpawn(Entity entity) {
        if (entity instanceof EntityFakePlayerImpl) {
            EntityFakePlayerImpl fakePlayer = (EntityFakePlayerImpl)entity;
            this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{fakePlayer}));
            Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> this.sendPacket((Packet<?>)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{fakePlayer})), 5L);
        }
    }

    public boolean processMirrorForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutPlayerInfo) {
            PacketPlayOutPlayerInfo playerInfo = (PacketPlayOutPlayerInfo)packet;
            ProfileEditorImpl.updatePlayerProfiles(playerInfo);
            if (!ProfileEditorImpl.handleAlteredProfiles(playerInfo, this)) {
                return true;
            }
        }
        return false;
    }

    public boolean processPacketHandlerForPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutChat && this.packetHandler.shouldInterceptChatPacket()) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), (PacketOutChat)new PacketOutChatImpl((PacketPlayOutChat)packet));
        }
        if (packet instanceof PacketPlayOutEntityMetadata && this.packetHandler.shouldInterceptMetadata()) {
            return this.packetHandler.sendPacket((Player)this.player.getBukkitEntity(), (PacketOutEntityMetadata)new PacketOutEntityMetadataImpl((PacketPlayOutEntityMetadata)packet));
        }
        return false;
    }

    public boolean processShowFakeForPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> genericfuturelistener) {
        if (FakeBlock.blocks.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutMapChunk) {
                FakeBlock.FakeBlockMap map = (FakeBlock.FakeBlockMap)FakeBlock.blocks.get(this.player.getUniqueID());
                if (map == null) {
                    return false;
                }
                int chunkX = CHUNKX_MAPCHUNK.getInt(packet);
                int chunkZ = CHUNKZ_MAPCHUNK.getInt(packet);
                ChunkCoordinate chunkCoord = new ChunkCoordinate(chunkX, chunkZ, this.player.getWorld().getWorld().getName());
                List blocks = FakeBlock.getFakeBlocksFor((UUID)this.player.getUniqueID(), (ChunkCoordinate)chunkCoord);
                if (blocks == null) {
                    return false;
                }
                PacketPlayOutMapChunk newPacket = FakeBlockHelper.handleMapChunkPacket((PacketPlayOutMapChunk)packet, blocks);
                this.oldManager.sendPacket((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutMultiBlockChange) {
                FakeBlock.FakeBlockMap map = (FakeBlock.FakeBlockMap)FakeBlock.blocks.get(this.player.getUniqueID());
                if (map == null) {
                    return false;
                }
                SectionPosition coord = (SectionPosition)SECTIONPOS_MULTIBLOCKCHANGE.get(packet);
                ChunkCoordinate coordinateDenizen = new ChunkCoordinate(coord.getX(), coord.getZ(), this.player.getWorld().getWorld().getName());
                if (!map.byChunk.containsKey(coordinateDenizen)) {
                    return false;
                }
                PacketPlayOutMultiBlockChange newPacket = new PacketPlayOutMultiBlockChange();
                DenizenNetworkManagerImpl.copyPacket(packet, newPacket);
                LocationTag location = new LocationTag((World)this.player.getWorld().getWorld(), 0.0, 0.0, 0.0);
                short[] originalOffsetArray = (short[])OFFSETARRAY_MULTIBLOCKCHANGE.get(newPacket);
                IBlockData[] originalDataArray = (IBlockData[])BLOCKARRAY_MULTIBLOCKCHANGE.get(newPacket);
                short[] offsetArray = Arrays.copyOf(originalOffsetArray, originalOffsetArray.length);
                IBlockData[] dataArray = Arrays.copyOf(originalDataArray, originalDataArray.length);
                OFFSETARRAY_MULTIBLOCKCHANGE.set(newPacket, offsetArray);
                BLOCKARRAY_MULTIBLOCKCHANGE.set(newPacket, dataArray);
                for (int i = 0; i < offsetArray.length; ++i) {
                    short offset = offsetArray[i];
                    BlockPosition pos = coord.g(offset);
                    location.setX((double)pos.getX());
                    location.setY((double)pos.getY());
                    location.setZ((double)pos.getZ());
                    FakeBlock block = (FakeBlock)map.byLocation.get(location);
                    if (block == null) continue;
                    dataArray[i] = FakeBlockHelper.getNMSState(block);
                }
                this.oldManager.sendPacket((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutBlockChange) {
                BlockPosition pos = (BlockPosition)BLOCKPOS_BLOCKCHANGE.get(packet);
                LocationTag loc = new LocationTag((World)this.player.getWorld().getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                FakeBlock block = FakeBlock.getFakeBlockFor((UUID)this.player.getUniqueID(), (LocationTag)loc);
                if (block != null) {
                    PacketPlayOutBlockChange newPacket = new PacketPlayOutBlockChange();
                    DenizenNetworkManagerImpl.copyPacket(packet, newPacket);
                    newPacket.block = FakeBlockHelper.getNMSState(block);
                    this.oldManager.sendPacket((Packet)newPacket, genericfuturelistener);
                    return true;
                }
            } else if (packet instanceof PacketPlayOutBlockBreak) {
                BlockPosition pos = (BlockPosition)BLOCKPOS_BLOCKBREAK.get(packet);
                LocationTag loc = new LocationTag((World)this.player.getWorld().getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                FakeBlock block = FakeBlock.getFakeBlockFor((UUID)this.player.getUniqueID(), (LocationTag)loc);
                if (block != null) {
                    PacketPlayOutBlockBreak newPacket = new PacketPlayOutBlockBreak();
                    DenizenNetworkManagerImpl.copyPacket(packet, newPacket);
                    BLOCKDATA_BLOCKBREAK.set(newPacket, FakeBlockHelper.getNMSState(block));
                    this.oldManager.sendPacket((Packet)newPacket, genericfuturelistener);
                    return true;
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
        return false;
    }

    public void processBlockLightForPacket(Packet<?> packet) {
        if (BlockLight.lightsByChunk.isEmpty()) {
            return;
        }
        if (packet instanceof PacketPlayOutLightUpdate) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutLightUpdate)packet, this.player.world);
        } else if (packet instanceof PacketPlayOutBlockChange) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutBlockChange)packet, this.player.world);
        }
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress getSocketAddress() {
        return this.oldManager.getSocketAddress();
    }

    public void close(IChatBaseComponent ichatbasecomponent) {
        this.oldManager.close(ichatbasecomponent);
    }

    public boolean isLocal() {
        return this.oldManager.isLocal();
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.oldManager.a(cipher, cipher1);
    }

    public boolean isConnected() {
        return this.oldManager.isConnected();
    }

    public boolean i() {
        return this.oldManager.i();
    }

    public PacketListener j() {
        return this.oldManager.j();
    }

    public IChatBaseComponent k() {
        return this.oldManager.k();
    }

    public void stopReading() {
        this.oldManager.stopReading();
    }

    public void setCompressionLevel(int i) {
        this.oldManager.setCompressionLevel(i);
    }

    public void handleDisconnection() {
        this.oldManager.handleDisconnection();
    }

    public float n() {
        return this.oldManager.n();
    }

    public SocketAddress getRawAddress() {
        return this.oldManager.getRawAddress();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            networkManagerField.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    static {
        Field directionField = null;
        MethodHandle managerField = null;
        try {
            directionField = NetworkManager.class.getDeclaredField("h");
            directionField.setAccessible(true);
            managerField = ReflectionHelper.getFinalSetter(PlayerConnection.class, (String)"networkManager");
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
        protocolDirectionField = directionField;
        networkManagerField = managerField;
    }
}

