/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;

public class BlockPhysicsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockPhysicsScriptEvent instance;
    public LocationTag location;
    public MaterialTag material;
    public BlockPhysicsEvent event;

    public BlockPhysicsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventArgLowerAt(1).equals("physics");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String mat = path.eventArgLowerAt(0);
        return this.tryMaterial(this.material, mat);
    }

    @Override
    public String getName() {
        return "BlockPhysics";
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return new MaterialTag(this.event.getChangedType());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        Material changedType = event.getChangedType();
        if (changedType == Material.REDSTONE_WIRE || MaterialCompat.isComparator(changedType) || MaterialCompat.isRepeater(changedType)) {
            return;
        }
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(this.location.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

