/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityInteractEvent;

public class EntityInteractScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityInteractScriptEvent instance;
    public EntityTag entity;
    public LocationTag location;
    private MaterialTag material;
    public EntityInteractEvent event;

    public EntityInteractScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).contains("interacts with");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(0))) {
            return false;
        }
        if (!this.tryMaterial(this.material, path.eventArgLowerAt(3))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "EntityInteracts";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? EntityTag.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? EntityTag.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityInteract(EntityInteractEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

