/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.BookScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.blocks.MaterialCompat;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.meta.BookMeta;

public class PlayerEditsBookScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerEditsBookScriptEvent instance;
    PlayerEditBookEvent event;
    ElementTag signing;
    ElementTag title;
    ElementTag pages;
    ItemTag book;
    PlayerTag player;
    BookMeta bookMeta;

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player edits book") || lower.startsWith("player signs book");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String action = path.eventArgLowerAt(1);
        if (action.equals("edits")) {
            return true;
        }
        return action.equals("signs") && this.signing.asBoolean();
    }

    @Override
    public String getName() {
        return "PlayerEditsBook";
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (determination.toUpperCase().equals("NOT_SIGNING")) {
            this.signing = new ElementTag(false);
        } else if (ScriptTag.matches(determination)) {
            ScriptTag script = ScriptTag.valueOf(determination);
            if (script.getContainer() instanceof BookScriptContainer) {
                ItemTag dBook = ((BookScriptContainer)script.getContainer()).getBookFrom((BukkitTagContext)this.getScriptEntryData().getTagContext());
                this.bookMeta = (BookMeta)dBook.getItemStack().getItemMeta();
                if (dBook.getMaterial().getMaterial() == MaterialCompat.WRITABLE_BOOK) {
                    this.signing = new ElementTag(false);
                }
            } else {
                Debug.echoError("Script '" + determination + "' is valid, but not of type 'book'!");
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("signing")) {
            return this.signing;
        }
        if (name.equals("title")) {
            return this.title;
        }
        if (name.equals("book")) {
            return this.book;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerEditsBook(PlayerEditBookEvent event) {
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.signing = new ElementTag(event.isSigning());
        this.bookMeta = event.getNewBookMeta();
        this.pages = new ElementTag(this.bookMeta.getPageCount());
        this.title = event.isSigning() ? new ElementTag(this.bookMeta.getTitle()) : null;
        this.book = new ItemTag(event.getPlayer().getInventory().getItem(event.getSlot()));
        this.event = event;
        this.fire((Event)event);
        event.setNewBookMeta(this.bookMeta);
        event.setSigning(this.signing.asBoolean());
    }
}

