/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.BukkitScriptEntryData;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class PlayerSneakScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerSneakScriptEvent instance;
    public Boolean state;
    public PlayerToggleSneakEvent event;

    public PlayerSneakScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(2, CoreUtilities.toLowerCase(s)).equals("sneaking");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (cmd.equals("starts") && !this.state.booleanValue()) {
            return false;
        }
        if (cmd.equals("stops") && this.state.booleanValue()) {
            return false;
        }
        return this.runInCheck(path, this.event.getPlayer().getLocation());
    }

    @Override
    public String getName() {
        return "PlayerSneak";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("state")) {
            return new ElementTag(this.state);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.state = event.isSneaking();
        this.event = event;
        this.fire((Event)event);
    }
}

